/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.d2j.node;

import com.googlecode.d2j.DexLabel;
import com.googlecode.d2j.Field;
import com.googlecode.d2j.Method;
import com.googlecode.d2j.node.DexDebugNode;
import com.googlecode.d2j.reader.Op;
import com.googlecode.d2j.visitors.DexCodeVisitor;
import com.googlecode.d2j.visitors.DexDebugVisitor;
import com.googlecode.d2j.visitors.DexMethodVisitor;
import java.util.ArrayList;
import java.util.List;

public class DexCodeNode
extends DexCodeVisitor {
    public List<DexStmtNode> stmts = new ArrayList<DexStmtNode>();
    public List<DexStmtNode> tryStmts = null;
    public DexDebugNode debugNode;
    public int totalRegister = -1;

    public DexCodeNode() {
    }

    public DexCodeNode(DexCodeVisitor visitor) {
        super(visitor);
    }

    public void accept(DexCodeVisitor v) {
        DexDebugVisitor ddv;
        if (this.tryStmts != null) {
            for (DexStmtNode n : this.tryStmts) {
                n.accept(v);
            }
        }
        if (this.debugNode != null && (ddv = v.visitDebug()) != null) {
            this.debugNode.accept(ddv);
            ddv.visitEnd();
        }
        if (this.totalRegister >= 0) {
            v.visitRegister(this.totalRegister);
        }
        for (DexStmtNode n : this.stmts) {
            n.accept(v);
        }
    }

    public void accept(DexMethodVisitor v) {
        DexCodeVisitor cv = v.visitCode();
        if (cv != null) {
            this.accept(cv);
            cv.visitEnd();
        }
    }

    protected void add(DexStmtNode stmt) {
        this.stmts.add(stmt);
    }

    @Override
    public void visitConstStmt(final Op op, final int ra, final Object value) {
        this.add(new DexStmtNode(){

            @Override
            public void accept(DexCodeVisitor cv) {
                cv.visitConstStmt(op, ra, value);
            }
        });
    }

    @Override
    public void visitFillArrayDataStmt(final Op op, final int ra, final Object array) {
        this.add(new DexStmtNode(){

            @Override
            public void accept(DexCodeVisitor cv) {
                cv.visitFillArrayDataStmt(op, ra, array);
            }
        });
    }

    @Override
    public void visitFieldStmt(final Op op, final int a, final int b, final Field field) {
        this.add(new DexStmtNode(){

            @Override
            public void accept(DexCodeVisitor cv) {
                cv.visitFieldStmt(op, a, b, field);
            }
        });
    }

    @Override
    public void visitFilledNewArrayStmt(Op op, int[] args, String type) {
        this.add(new FilledNewArrayStmtNode(op, args, type));
    }

    @Override
    public void visitJumpStmt(final Op op, final int a, final int b, final DexLabel label) {
        this.add(new DexStmtNode(){

            @Override
            public void accept(DexCodeVisitor cv) {
                cv.visitJumpStmt(op, a, b, label);
            }
        });
    }

    @Override
    public void visitLabel(DexLabel label) {
        this.add(new DexLabelStmtNode(label));
    }

    @Override
    public void visitMethodStmt(Op op, int[] args, Method method) {
        this.add(new MethodStmtNode(op, args, method));
    }

    @Override
    public void visitPackedSwitchStmt(final Op op, final int aA, final int first_case, final DexLabel[] labels) {
        this.add(new DexStmtNode(){

            @Override
            public void accept(DexCodeVisitor cv) {
                cv.visitPackedSwitchStmt(op, aA, first_case, labels);
            }
        });
    }

    @Override
    public void visitRegister(int total) {
        this.totalRegister = total;
    }

    @Override
    public void visitSparseSwitchStmt(final Op op, final int ra, final int[] cases, final DexLabel[] labels) {
        this.add(new DexStmtNode(){

            @Override
            public void accept(DexCodeVisitor cv) {
                cv.visitSparseSwitchStmt(op, ra, cases, labels);
            }
        });
    }

    @Override
    public void visitStmt0R(final Op op) {
        this.add(new DexStmtNode(){

            @Override
            public void accept(DexCodeVisitor cv) {
                cv.visitStmt0R(op);
            }
        });
    }

    @Override
    public void visitStmt1R(final Op op, final int reg) {
        this.add(new DexStmtNode(){

            @Override
            public void accept(DexCodeVisitor cv) {
                cv.visitStmt1R(op, reg);
            }
        });
    }

    @Override
    public void visitStmt2R(final Op op, final int a, final int b) {
        this.add(new DexStmtNode(){

            @Override
            public void accept(DexCodeVisitor cv) {
                cv.visitStmt2R(op, a, b);
            }
        });
    }

    @Override
    public void visitStmt2R1N(final Op op, final int distReg, final int srcReg, final int content) {
        this.add(new DexStmtNode(){

            @Override
            public void accept(DexCodeVisitor cv) {
                cv.visitStmt2R1N(op, distReg, srcReg, content);
            }
        });
    }

    @Override
    public void visitStmt3R(final Op op, final int a, final int b, final int c) {
        this.add(new DexStmtNode(){

            @Override
            public void accept(DexCodeVisitor cv) {
                cv.visitStmt3R(op, a, b, c);
            }
        });
    }

    @Override
    public void visitTryCatch(final DexLabel start, final DexLabel end, final DexLabel[] handler, final String[] type) {
        if (this.tryStmts == null) {
            this.tryStmts = new ArrayList<DexStmtNode>(3);
        }
        this.tryStmts.add(new DexStmtNode(){

            @Override
            public void accept(DexCodeVisitor cv) {
                cv.visitTryCatch(start, end, handler, type);
            }
        });
    }

    @Override
    public void visitTypeStmt(final Op op, final int a, final int b, final String type) {
        this.add(new DexStmtNode(){

            @Override
            public void accept(DexCodeVisitor cv) {
                cv.visitTypeStmt(op, a, b, type);
            }
        });
    }

    @Override
    public DexDebugVisitor visitDebug() {
        DexDebugNode dexDebugNode;
        this.debugNode = dexDebugNode = new DexDebugNode();
        return dexDebugNode;
    }

    public static class DexLabelStmtNode
    extends DexStmtNode {
        public DexLabel label;

        public DexLabelStmtNode(DexLabel label) {
            this.label = label;
        }

        @Override
        public void accept(DexCodeVisitor cv) {
            cv.visitLabel(this.label);
        }
    }

    public static abstract class DexStmtNode {
        public abstract void accept(DexCodeVisitor var1);
    }

    public static class FilledNewArrayStmtNode
    extends DexStmtNode {
        public final Op op;
        public final int[] args;
        public final String type;

        public FilledNewArrayStmtNode(Op op, int[] args, String type) {
            this.op = op;
            this.args = args;
            this.type = type;
        }

        @Override
        public void accept(DexCodeVisitor cv) {
            cv.visitFilledNewArrayStmt(this.op, this.args, this.type);
        }
    }

    public static class MethodStmtNode
    extends DexStmtNode {
        public final Op op;
        public final int[] args;
        public final Method method;

        public MethodStmtNode(Op op, int[] args, Method method) {
            this.op = op;
            this.args = args;
            this.method = method;
        }

        @Override
        public void accept(DexCodeVisitor cv) {
            cv.visitMethodStmt(this.op, this.args, this.method);
        }
    }
}

