/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.logviewer.ui;

import docking.EmptyBorderToggleButton;
import docking.widgets.EmptyBorderButton;
import ghidra.framework.main.logviewer.event.FVEvent;
import ghidra.framework.main.logviewer.event.FVEventListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JToolBar;
import resources.ResourceManager;

public class FVToolBar
extends JToolBar {
    private EmptyBorderToggleButton scrollLockBtn;
    private EmptyBorderButton fileOpenBtn;
    private FVEventListener eventListener;

    public FVToolBar(FVEventListener eventListener) {
        this.eventListener = eventListener;
        this.createScrollLockTool();
        this.createFileOpenTool();
    }

    public EmptyBorderToggleButton getScrollLockBtn() {
        return this.scrollLockBtn;
    }

    private void createFileOpenTool() {
        ImageIcon icon = ResourceManager.loadImage((String)"images/lock.png");
        ScrollLockAction lockAction = new ScrollLockAction("undefined", icon, "Scroll Lock");
        this.scrollLockBtn = new EmptyBorderToggleButton();
        this.scrollLockBtn.setAction((Action)lockAction);
        this.scrollLockBtn.setText("Scroll Lock");
        this.scrollLockBtn.setHideActionText(true);
        this.scrollLockBtn.setToolTipText("Scroll Lock");
        this.add((Component)this.scrollLockBtn);
    }

    private void createScrollLockTool() {
        ImageIcon icon = ResourceManager.loadImage((String)"images/openSmallFolder.png");
        FileOpenAction openAction = new FileOpenAction("undefined", icon, "Scroll Lock");
        this.fileOpenBtn = new EmptyBorderButton();
        this.fileOpenBtn.setAction((Action)openAction);
        this.fileOpenBtn.setText("Opens the log file folder");
        this.fileOpenBtn.setHideActionText(true);
        this.fileOpenBtn.setToolTipText("Opens the log file folder");
        this.add((Component)this.fileOpenBtn);
    }

    private class FileOpenAction
    extends AbstractAction {
        public FileOpenAction(String text, Icon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FVEvent openEvt = new FVEvent(FVEvent.EventType.OPEN_FILE_LOCATION, null);
            FVToolBar.this.eventListener.send(openEvt);
        }
    }

    private class ScrollLockAction
    extends AbstractAction {
        public ScrollLockAction(String text, Icon icon, String desc) {
            super(text, icon);
            this.putValue("ShortDescription", desc);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FVEvent tailEvt = FVToolBar.this.scrollLockBtn.isSelected() ? new FVEvent(FVEvent.EventType.SCROLL_LOCK_ON, null) : new FVEvent(FVEvent.EventType.SCROLL_LOCK_OFF, null);
            FVToolBar.this.eventListener.send(tailEvt);
        }
    }
}

