/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.projectdata.actions;

import docking.action.MenuData;
import ghidra.framework.main.datatable.DomainFileContext;
import ghidra.framework.main.datatree.VersionHistoryDialog;
import ghidra.framework.main.projectdata.actions.VersionControlAction;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.Plugin;
import java.util.List;

public class VersionControlShowHistoryAction
extends VersionControlAction {
    public VersionControlShowHistoryAction(Plugin plugin) {
        super("Show History", plugin.getName(), plugin.getTool());
        String[] menuItemName = new String[]{"Show History..."};
        this.setPopupMenuData(new MenuData(menuItemName, null, "Repository"));
        this.setDescription("Show version history");
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(DomainFileContext context) {
        this.showHistory(context.getSelectedFiles());
    }

    @Override
    public boolean isEnabledForContext(DomainFileContext context) {
        List<DomainFile> domainFiles = context.getSelectedFiles();
        if (domainFiles.size() != 1) {
            return false;
        }
        DomainFile domainFile = domainFiles.get(0);
        return domainFile.isVersioned();
    }

    private void showHistory(List<DomainFile> domainFiles) {
        if (!this.checkRepositoryConnected()) {
            return;
        }
        if (domainFiles.size() != 1) {
            return;
        }
        VersionHistoryDialog dialog = new VersionHistoryDialog(domainFiles.get(0));
        this.tool.showDialog(dialog);
    }
}

