/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.client.RepositoryServerAdapter;
import ghidra.framework.store.FileSystem;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public abstract class GhidraProtocolConnector {
    protected final URL url;
    protected final String repositoryName;
    protected final String itemPath;
    protected String folderPath;
    protected String folderItemName = null;
    protected int responseCode = -1;
    protected RepositoryAdapter repositoryAdapter;
    protected RepositoryServerAdapter repositoryServerAdapter;

    protected GhidraProtocolConnector(URL url) throws MalformedURLException {
        this.url = url;
        this.checkProtocol();
        this.checkUserInfo();
        this.checkHostInfo();
        this.repositoryName = this.parseRepositoryName();
        this.itemPath = this.parseItemPath();
    }

    protected abstract URL getRepositoryRootGhidraURL();

    protected void checkProtocol() throws MalformedURLException {
        if (!"ghidra".equals(this.url.getProtocol())) {
            throw new MalformedURLException("expected ghidra URL protocol");
        }
    }

    protected void checkUserInfo() throws MalformedURLException {
        if (this.url.getUserInfo() != null) {
            throw new MalformedURLException("URL does not support user info");
        }
    }

    protected void checkHostInfo() throws MalformedURLException {
        String host = this.url.getHost();
        if (host.length() == 0) {
            throw new MalformedURLException("missing server host specification");
        }
    }

    protected String parseRepositoryName() throws MalformedURLException {
        String path = this.url.getPath();
        if (path == null || path.length() < 2 || path.charAt(0) != '/') {
            return null;
        }
        int index = (path = path.substring(1)).indexOf(FileSystem.SEPARATOR);
        if (index >= 0) {
            path = path.substring(0, index);
        }
        if (path.length() == 0) {
            throw new MalformedURLException("invalid path specification");
        }
        return path;
    }

    protected String parseItemPath() throws MalformedURLException {
        String path = this.url.getPath();
        if (this.repositoryName == null) {
            return null;
        }
        if ((path = path.substring(this.repositoryName.length() + 1)).length() <= 1) {
            this.folderPath = FileSystem.SEPARATOR;
            return this.folderPath;
        }
        boolean isFolder = path.endsWith(FileSystem.SEPARATOR);
        this.folderPath = "";
        String pathToSplit = isFolder ? path.substring(0, path.length() - 1) : path;
        String[] pieces = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)pathToSplit, (String)FileSystem.SEPARATOR);
        if (pieces.length == 0) {
            throw new MalformedURLException("invalid repository path specification");
        }
        for (int i = 1; i < pieces.length; ++i) {
            String p = pieces[i];
            if (p.length() == 0) {
                throw new MalformedURLException("invalid repository path specification");
            }
            if (!isFolder && i == pieces.length - 1) {
                this.folderItemName = p;
                continue;
            }
            this.folderPath = this.folderPath + FileSystem.SEPARATOR + p;
        }
        if (this.folderPath.length() == 0) {
            this.folderPath = FileSystem.SEPARATOR;
        }
        return path;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public RepositoryAdapter getRepositoryAdapter() {
        return this.repositoryAdapter;
    }

    public RepositoryServerAdapter getRepositoryServerAdapter() {
        return this.repositoryServerAdapter;
    }

    public String getFolderPath() {
        return this.folderPath;
    }

    public String getFolderItemName() {
        return this.folderItemName;
    }

    private String appendSubfolderName(String folder, String subfolderName) {
        if (!((String)folder).endsWith(FileSystem.SEPARATOR)) {
            folder = (String)folder + FileSystem.SEPARATOR;
        }
        return (String)folder + this.folderItemName;
    }

    protected void resolveItemPath() throws IOException {
        if (this.folderItemName != null) {
            String path;
            if (this.itemPath.endsWith("/")) {
                this.folderPath = this.appendSubfolderName(this.folderPath, this.folderItemName);
                this.folderItemName = null;
            } else if (!this.repositoryAdapter.fileExists(this.folderPath, this.folderItemName) && this.repositoryAdapter.folderExists(path = this.appendSubfolderName(this.folderPath, this.folderItemName))) {
                this.folderPath = path;
                this.folderItemName = null;
            }
        }
    }

    protected void connect(RepositoryAdapter repository) throws IOException {
        if (this.responseCode != -1) {
            throw new IllegalStateException("already connected");
        }
        if (this.repositoryName == null || !this.repositoryName.equals(repository.getName())) {
            throw new UnsupportedOperationException("invalid repository connection");
        }
        if (!repository.isConnected()) {
            throw new IllegalStateException("expected connected repository");
        }
        this.responseCode = 200;
        this.repositoryAdapter = repository;
        this.repositoryServerAdapter = repository.getServer();
        this.resolveItemPath();
    }

    public abstract int connect(boolean var1) throws IOException;

    public abstract boolean isReadOnly() throws NotConnectedException;
}

