/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.protocol.ghidra;

import ghidra.framework.client.NotConnectedException;
import ghidra.framework.client.RepositoryServerAdapter;
import ghidra.framework.data.ProjectFileManager;
import ghidra.framework.model.ProjectData;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.protocol.ghidra.DefaultGhidraProtocolHandler;
import ghidra.framework.protocol.ghidra.DefaultLocalGhidraProtocolConnector;
import ghidra.framework.protocol.ghidra.GhidraProtocolConnector;
import ghidra.framework.protocol.ghidra.GhidraProtocolHandler;
import ghidra.framework.protocol.ghidra.GhidraURLWrappedContent;
import ghidra.framework.protocol.ghidra.TransientProjectData;
import ghidra.framework.protocol.ghidra.TransientProjectManager;
import ghidra.util.NotOwnerException;
import ghidra.util.exception.AssertException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownServiceException;

public class GhidraURLConnection
extends URLConnection {
    public static final int GHIDRA_OK = 200;
    public static final int GHIDRA_UNAUTHORIZED = 401;
    public static final int GHIDRA_NOT_FOUND = 404;
    public static final String GHIDRA_WRAPPED_CONTENT = "GhidraWrappedContent";
    public static final String REPOSITORY_SERVER_CONTENT = "RepositoryServer";
    private int responseCode = -1;
    private GhidraProtocolConnector protocolConnector;
    private ProjectFileManager projectData;
    private Object refObject;
    private boolean readOnly = true;

    public GhidraURLConnection(URL ghidraUrl) throws MalformedURLException {
        this(ghidraUrl, new DefaultGhidraProtocolHandler());
    }

    public GhidraURLConnection(URL url, GhidraProtocolHandler protocolHandler) throws MalformedURLException {
        super(url);
        if (protocolHandler == null) {
            throw new IllegalArgumentException("missing required protocol handler");
        }
        this.protocolConnector = protocolHandler.getConnector(url);
    }

    public boolean isReadOnly() {
        if (!this.connected) {
            return this.readOnly;
        }
        try {
            return this.protocolConnector.isReadOnly();
        }
        catch (NotConnectedException e) {
            throw new AssertException((Throwable)e);
        }
    }

    public void setReadOnly(boolean state) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        this.readOnly = state;
    }

    public String getRepositoryName() {
        return this.protocolConnector.getRepositoryName();
    }

    public String getFolderPath() {
        return this.protocolConnector.getFolderPath();
    }

    public String getFolderItemName() {
        return this.protocolConnector.getFolderItemName();
    }

    public int getResponseCode() throws IOException {
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        this.getContent();
        return this.responseCode;
    }

    @Override
    public String getContentType() {
        if (!this.connected || this.refObject == null) {
            return null;
        }
        if (this.refObject instanceof RepositoryServerAdapter) {
            return REPOSITORY_SERVER_CONTENT;
        }
        if (this.refObject instanceof GhidraURLWrappedContent) {
            return GHIDRA_WRAPPED_CONTENT;
        }
        return "Unknown";
    }

    @Override
    public Object getContent() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.refObject;
    }

    public ProjectData getProjectData() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.projectData instanceof TransientProjectData) {
            ((TransientProjectData)this.projectData).incrementInstanceUseCount();
        }
        return this.projectData;
    }

    private void localConnect(ProjectLocator localProjectLocator) throws IOException {
        this.responseCode = this.protocolConnector.connect(this.readOnly);
        if (this.responseCode != 200) {
            return;
        }
        try {
            this.projectData = new ProjectFileManager(localProjectLocator, !this.readOnly, false);
            this.refObject = new GhidraURLWrappedContent(this);
            this.responseCode = 200;
        }
        catch (NotOwnerException e) {
            this.responseCode = 401;
        }
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        if (this.protocolConnector instanceof DefaultLocalGhidraProtocolConnector) {
            DefaultLocalGhidraProtocolConnector localConnector = (DefaultLocalGhidraProtocolConnector)this.protocolConnector;
            this.localConnect(localConnector.getLocalProjectLocator());
            this.connected = true;
            return;
        }
        String repoName = this.protocolConnector.getRepositoryName();
        if (repoName == null) {
            this.responseCode = this.protocolConnector.connect(this.readOnly);
            this.connected = true;
            if (this.responseCode == 200) {
                this.refObject = this.protocolConnector.getRepositoryServerAdapter();
                if (this.refObject == null) {
                    throw new AssertException("expected RepositoryServerAdapter content");
                }
            }
            return;
        }
        TransientProjectManager transientProjectManager = TransientProjectManager.getTransientProjectManager();
        TransientProjectData transientProjectData = transientProjectManager.getTransientProject(this.protocolConnector, this.readOnly);
        this.connected = true;
        this.responseCode = this.protocolConnector.getResponseCode();
        if (this.responseCode != 200) {
            return;
        }
        this.projectData = transientProjectData;
        this.refObject = new GhidraURLWrappedContent(this);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new UnknownServiceException();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnknownServiceException();
    }
}

