/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emulate;

import ghidra.pcode.memstate.MemoryState;
import ghidra.program.model.address.Address;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryAccessException;
import java.math.BigInteger;

public class EmulateMemoryStateBuffer
implements MemBuffer {
    private final MemoryState memState;
    private Address address;

    public EmulateMemoryStateBuffer(MemoryState memState, Address addr) {
        this.memState = memState;
        this.setAddress(addr);
    }

    public void setAddress(Address addr) {
        this.address = addr;
    }

    @Override
    public Address getAddress() {
        return this.address;
    }

    private long availableInSpace(Address startAddr) {
        return this.address.getAddressSpace().getMaxAddress().subtract(startAddr) + 1L;
    }

    private Address getWrappedAddress(int offset) {
        return this.address.addWrap(offset);
    }

    private long checkGetRequest(int offset, int size) throws MemoryAccessException {
        Address offsetAddr = this.getWrappedAddress(offset);
        long available = this.availableInSpace(offsetAddr);
        if (available > 0L && available < (long)size) {
            throw new MemoryAccessException();
        }
        return offsetAddr.getOffset();
    }

    @Override
    public BigInteger getBigInteger(int offset, int size, boolean signed) throws MemoryAccessException {
        long memOffset = this.checkGetRequest(offset, size);
        return this.memState.getBigInteger(this.address.getAddressSpace(), memOffset, size, signed);
    }

    @Override
    public int getBytes(byte[] b, int offset) {
        Address offsetAddr = this.getWrappedAddress(offset);
        return this.memState.getChunk(b, this.address.getAddressSpace(), offsetAddr.getOffset(), b.length, true);
    }

    @Override
    public byte getByte(int offset) throws MemoryAccessException {
        long memOffset = this.checkGetRequest(offset, 1);
        return (byte)this.memState.getValue(this.address.getAddressSpace(), memOffset, 1);
    }

    @Override
    public short getShort(int offset) throws MemoryAccessException {
        long memOffset = this.checkGetRequest(offset, 2);
        return (short)this.memState.getValue(this.address.getAddressSpace(), memOffset, 2);
    }

    @Override
    public int getInt(int offset) throws MemoryAccessException {
        long memOffset = this.checkGetRequest(offset, 4);
        return (int)this.memState.getValue(this.address.getAddressSpace(), memOffset, 4);
    }

    @Override
    public long getLong(int offset) throws MemoryAccessException {
        long memOffset = this.checkGetRequest(offset, 8);
        return this.memState.getValue(this.address.getAddressSpace(), memOffset, 8);
    }

    @Override
    public Memory getMemory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isBigEndian() {
        return this.memState.getMemoryBank(this.address.getAddressSpace()).isBigEndian();
    }
}

