/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.opbehavior;

import ghidra.pcode.opbehavior.OpBehavior;
import ghidra.pcode.opbehavior.OpBehaviorBoolAnd;
import ghidra.pcode.opbehavior.OpBehaviorBoolNegate;
import ghidra.pcode.opbehavior.OpBehaviorBoolOr;
import ghidra.pcode.opbehavior.OpBehaviorBoolXor;
import ghidra.pcode.opbehavior.OpBehaviorCopy;
import ghidra.pcode.opbehavior.OpBehaviorEqual;
import ghidra.pcode.opbehavior.OpBehaviorFloatAbs;
import ghidra.pcode.opbehavior.OpBehaviorFloatAdd;
import ghidra.pcode.opbehavior.OpBehaviorFloatCeil;
import ghidra.pcode.opbehavior.OpBehaviorFloatDiv;
import ghidra.pcode.opbehavior.OpBehaviorFloatEqual;
import ghidra.pcode.opbehavior.OpBehaviorFloatFloat2Float;
import ghidra.pcode.opbehavior.OpBehaviorFloatFloor;
import ghidra.pcode.opbehavior.OpBehaviorFloatInt2Float;
import ghidra.pcode.opbehavior.OpBehaviorFloatLess;
import ghidra.pcode.opbehavior.OpBehaviorFloatLessEqual;
import ghidra.pcode.opbehavior.OpBehaviorFloatMult;
import ghidra.pcode.opbehavior.OpBehaviorFloatNan;
import ghidra.pcode.opbehavior.OpBehaviorFloatNeg;
import ghidra.pcode.opbehavior.OpBehaviorFloatNotEqual;
import ghidra.pcode.opbehavior.OpBehaviorFloatRound;
import ghidra.pcode.opbehavior.OpBehaviorFloatSqrt;
import ghidra.pcode.opbehavior.OpBehaviorFloatSub;
import ghidra.pcode.opbehavior.OpBehaviorFloatTrunc;
import ghidra.pcode.opbehavior.OpBehaviorInt2Comp;
import ghidra.pcode.opbehavior.OpBehaviorIntAdd;
import ghidra.pcode.opbehavior.OpBehaviorIntAnd;
import ghidra.pcode.opbehavior.OpBehaviorIntCarry;
import ghidra.pcode.opbehavior.OpBehaviorIntDiv;
import ghidra.pcode.opbehavior.OpBehaviorIntLeft;
import ghidra.pcode.opbehavior.OpBehaviorIntLess;
import ghidra.pcode.opbehavior.OpBehaviorIntLessEqual;
import ghidra.pcode.opbehavior.OpBehaviorIntMult;
import ghidra.pcode.opbehavior.OpBehaviorIntNegate;
import ghidra.pcode.opbehavior.OpBehaviorIntOr;
import ghidra.pcode.opbehavior.OpBehaviorIntRem;
import ghidra.pcode.opbehavior.OpBehaviorIntRight;
import ghidra.pcode.opbehavior.OpBehaviorIntSborrow;
import ghidra.pcode.opbehavior.OpBehaviorIntScarry;
import ghidra.pcode.opbehavior.OpBehaviorIntSdiv;
import ghidra.pcode.opbehavior.OpBehaviorIntSext;
import ghidra.pcode.opbehavior.OpBehaviorIntSless;
import ghidra.pcode.opbehavior.OpBehaviorIntSlessEqual;
import ghidra.pcode.opbehavior.OpBehaviorIntSrem;
import ghidra.pcode.opbehavior.OpBehaviorIntSright;
import ghidra.pcode.opbehavior.OpBehaviorIntSub;
import ghidra.pcode.opbehavior.OpBehaviorIntXor;
import ghidra.pcode.opbehavior.OpBehaviorIntZext;
import ghidra.pcode.opbehavior.OpBehaviorNotEqual;
import ghidra.pcode.opbehavior.OpBehaviorPiece;
import ghidra.pcode.opbehavior.OpBehaviorPopcount;
import ghidra.pcode.opbehavior.OpBehaviorSubpiece;
import ghidra.pcode.opbehavior.SpecialOpBehavior;
import java.util.HashMap;
import java.util.Map;

public class OpBehaviorFactory {
    private static Map<Integer, OpBehavior> opBehaviorMap = new HashMap<Integer, OpBehavior>();

    private OpBehaviorFactory() {
    }

    public static OpBehavior getOpBehavior(int opcode) {
        return opBehaviorMap.get(opcode);
    }

    static {
        opBehaviorMap.put(1, new OpBehaviorCopy());
        opBehaviorMap.put(2, new SpecialOpBehavior(2));
        opBehaviorMap.put(3, new SpecialOpBehavior(3));
        opBehaviorMap.put(4, new SpecialOpBehavior(4));
        opBehaviorMap.put(5, new SpecialOpBehavior(5));
        opBehaviorMap.put(6, new SpecialOpBehavior(6));
        opBehaviorMap.put(7, new SpecialOpBehavior(7));
        opBehaviorMap.put(8, new SpecialOpBehavior(8));
        opBehaviorMap.put(9, new SpecialOpBehavior(9));
        opBehaviorMap.put(10, new SpecialOpBehavior(10));
        opBehaviorMap.put(60, new SpecialOpBehavior(60));
        opBehaviorMap.put(61, new SpecialOpBehavior(61));
        opBehaviorMap.put(62, new OpBehaviorPiece());
        opBehaviorMap.put(63, new OpBehaviorSubpiece());
        opBehaviorMap.put(11, new OpBehaviorEqual());
        opBehaviorMap.put(12, new OpBehaviorNotEqual());
        opBehaviorMap.put(13, new OpBehaviorIntSless());
        opBehaviorMap.put(14, new OpBehaviorIntSlessEqual());
        opBehaviorMap.put(15, new OpBehaviorIntLess());
        opBehaviorMap.put(16, new OpBehaviorIntLessEqual());
        opBehaviorMap.put(17, new OpBehaviorIntZext());
        opBehaviorMap.put(18, new OpBehaviorIntSext());
        opBehaviorMap.put(19, new OpBehaviorIntAdd());
        opBehaviorMap.put(20, new OpBehaviorIntSub());
        opBehaviorMap.put(21, new OpBehaviorIntCarry());
        opBehaviorMap.put(22, new OpBehaviorIntScarry());
        opBehaviorMap.put(23, new OpBehaviorIntSborrow());
        opBehaviorMap.put(24, new OpBehaviorInt2Comp());
        opBehaviorMap.put(25, new OpBehaviorIntNegate());
        opBehaviorMap.put(26, new OpBehaviorIntXor());
        opBehaviorMap.put(27, new OpBehaviorIntAnd());
        opBehaviorMap.put(28, new OpBehaviorIntOr());
        opBehaviorMap.put(29, new OpBehaviorIntLeft());
        opBehaviorMap.put(30, new OpBehaviorIntRight());
        opBehaviorMap.put(31, new OpBehaviorIntSright());
        opBehaviorMap.put(32, new OpBehaviorIntMult());
        opBehaviorMap.put(33, new OpBehaviorIntDiv());
        opBehaviorMap.put(34, new OpBehaviorIntSdiv());
        opBehaviorMap.put(35, new OpBehaviorIntRem());
        opBehaviorMap.put(36, new OpBehaviorIntSrem());
        opBehaviorMap.put(37, new OpBehaviorBoolNegate());
        opBehaviorMap.put(38, new OpBehaviorBoolXor());
        opBehaviorMap.put(39, new OpBehaviorBoolAnd());
        opBehaviorMap.put(40, new OpBehaviorBoolOr());
        opBehaviorMap.put(64, new SpecialOpBehavior(64));
        opBehaviorMap.put(65, new SpecialOpBehavior(65));
        opBehaviorMap.put(66, new SpecialOpBehavior(66));
        opBehaviorMap.put(41, new OpBehaviorFloatEqual());
        opBehaviorMap.put(42, new OpBehaviorFloatNotEqual());
        opBehaviorMap.put(43, new OpBehaviorFloatLess());
        opBehaviorMap.put(44, new OpBehaviorFloatLessEqual());
        opBehaviorMap.put(46, new OpBehaviorFloatNan());
        opBehaviorMap.put(47, new OpBehaviorFloatAdd());
        opBehaviorMap.put(48, new OpBehaviorFloatDiv());
        opBehaviorMap.put(49, new OpBehaviorFloatMult());
        opBehaviorMap.put(50, new OpBehaviorFloatSub());
        opBehaviorMap.put(51, new OpBehaviorFloatNeg());
        opBehaviorMap.put(52, new OpBehaviorFloatAbs());
        opBehaviorMap.put(53, new OpBehaviorFloatSqrt());
        opBehaviorMap.put(54, new OpBehaviorFloatInt2Float());
        opBehaviorMap.put(55, new OpBehaviorFloatFloat2Float());
        opBehaviorMap.put(56, new OpBehaviorFloatTrunc());
        opBehaviorMap.put(57, new OpBehaviorFloatCeil());
        opBehaviorMap.put(58, new OpBehaviorFloatFloor());
        opBehaviorMap.put(59, new OpBehaviorFloatRound());
        opBehaviorMap.put(67, new SpecialOpBehavior(67));
        opBehaviorMap.put(68, new SpecialOpBehavior(68));
        opBehaviorMap.put(69, new SpecialOpBehavior(69));
        opBehaviorMap.put(70, new SpecialOpBehavior(70));
        opBehaviorMap.put(71, new SpecialOpBehavior(71));
        opBehaviorMap.put(72, new OpBehaviorPopcount());
    }
}

