/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcodeCPort.slghsymbol;

import generic.stl.IteratorSTL;
import generic.stl.VectorSTL;
import ghidra.pcodeCPort.context.ParserWalker;
import ghidra.pcodeCPort.context.ParserWalkerChange;
import ghidra.pcodeCPort.context.SleighError;
import ghidra.pcodeCPort.semantics.ConstTpl;
import ghidra.pcodeCPort.semantics.ConstructTpl;
import ghidra.pcodeCPort.semantics.HandleTpl;
import ghidra.pcodeCPort.sleighbase.SleighBase;
import ghidra.pcodeCPort.slghpatexpress.OperandResolve;
import ghidra.pcodeCPort.slghpatexpress.PatternEquation;
import ghidra.pcodeCPort.slghpatexpress.PatternExpression;
import ghidra.pcodeCPort.slghpatexpress.TokenPattern;
import ghidra.pcodeCPort.slghsymbol.ContextChange;
import ghidra.pcodeCPort.slghsymbol.ContextCommit;
import ghidra.pcodeCPort.slghsymbol.ContextOp;
import ghidra.pcodeCPort.slghsymbol.OperandSymbol;
import ghidra.pcodeCPort.slghsymbol.SubtableSymbol;
import ghidra.pcodeCPort.slghsymbol.TripleSymbol;
import ghidra.pcodeCPort.slghsymbol.symbol_type;
import ghidra.pcodeCPort.utils.XmlUtils;
import ghidra.sleigh.grammar.Location;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class Constructor {
    public final Location location;
    private TokenPattern pattern;
    private SubtableSymbol parent;
    private PatternEquation pateq;
    private VectorSTL<OperandSymbol> operands = new VectorSTL();
    private VectorSTL<String> printpiece = new VectorSTL();
    private VectorSTL<ContextChange> context = new VectorSTL();
    private ConstructTpl templ;
    private VectorSTL<ConstructTpl> namedtempl;
    private int minimumlength;
    private long id;
    private int firstwhitespace;
    private int flowthruindex;
    private boolean inerror;

    public TokenPattern getPattern() {
        return this.pattern;
    }

    public String getFilename() {
        return this.location == null ? "(null)" : this.location.filename;
    }

    public void setMinimumLength(int l) {
        this.minimumlength = l;
    }

    public int getMinimumLength() {
        return this.minimumlength;
    }

    public void setId(long i) {
        this.id = i;
    }

    public long getId() {
        return this.id;
    }

    public int getLineno() {
        return this.location == null ? 0 : this.location.lineno;
    }

    public void addContext(VectorSTL<ContextChange> vec) {
        this.context = vec;
    }

    public SubtableSymbol getParent() {
        return this.parent;
    }

    public int getNumOperands() {
        return this.operands.size();
    }

    public OperandSymbol getOperand(int i) {
        return (OperandSymbol)this.operands.get(i);
    }

    public PatternEquation getPatternEquation() {
        return this.pateq;
    }

    public ConstructTpl getTempl() {
        return this.templ;
    }

    public ConstructTpl getNamedTempl(int secnum) {
        if (secnum < this.namedtempl.size()) {
            return (ConstructTpl)this.namedtempl.get(secnum);
        }
        return null;
    }

    public int getNumSections() {
        return this.namedtempl.size();
    }

    public void applyContext(ParserWalkerChange pos) {
        IteratorSTL iter = this.context.begin();
        while (!iter.isEnd()) {
            ((ContextChange)iter.get()).apply(pos);
            iter.increment();
        }
    }

    public void markSubtableOperands(VectorSTL<Integer> check) {
        check.resize(this.operands.size(), (Object)0);
        for (int i = 0; i < this.operands.size(); ++i) {
            TripleSymbol sym = ((OperandSymbol)this.operands.get(i)).getDefiningSymbol();
            if (sym != null && sym.getType() == symbol_type.subtable_symbol) {
                check.set(i, (Object)0);
                continue;
            }
            check.set(i, (Object)2);
        }
    }

    public void collectLocalExports(ArrayList<Long> results) {
        if (this.templ == null) {
            return;
        }
        HandleTpl handle = this.templ.getResult();
        if (handle == null) {
            return;
        }
        if (handle.getSpace().isConstSpace()) {
            return;
        }
        if (handle.getPtrSpace().getType() != ConstTpl.const_type.real) {
            if (handle.getTempSpace().isUniqueSpace()) {
                results.add(handle.getTempOffset().getReal());
            }
            return;
        }
        if (handle.getSpace().isUniqueSpace()) {
            results.add(handle.getPtrOffset().getReal());
            return;
        }
        if (handle.getSpace().getType() == ConstTpl.const_type.handle) {
            int handleIndex = handle.getSpace().getHandleIndex();
            OperandSymbol opSym = this.getOperand(handleIndex);
            opSym.collectLocalValues(results);
        }
    }

    public void setError(boolean val) {
        this.inerror = val;
    }

    public boolean isError() {
        return this.inerror;
    }

    public boolean isRecursive() {
        for (int i = 0; i < this.operands.size(); ++i) {
            TripleSymbol sym = ((OperandSymbol)this.operands.get(i)).getDefiningSymbol();
            if (sym != this.parent) continue;
            return true;
        }
        return false;
    }

    public Constructor(Location location) {
        this.location = location;
        this.pattern = null;
        this.parent = null;
        this.pateq = null;
        this.templ = null;
        this.namedtempl = new VectorSTL();
        this.firstwhitespace = -1;
        this.flowthruindex = -1;
        this.inerror = false;
    }

    public Constructor(Location location, SubtableSymbol p) {
        this.location = location;
        this.pattern = null;
        this.parent = p;
        this.pateq = null;
        this.templ = null;
        this.namedtempl = new VectorSTL();
        this.firstwhitespace = -1;
        this.inerror = false;
    }

    public void dispose() {
        if (this.pattern != null) {
            this.pattern.dispose();
        }
        if (this.pateq != null) {
            PatternEquation.release(this.pateq);
        }
        if (this.templ != null) {
            this.templ.dispose();
        }
        IteratorSTL iter = this.context.begin();
        while (!iter.isEnd()) {
            ((ContextChange)iter.get()).dispose();
            iter.increment();
        }
    }

    public void addInvisibleOperand(OperandSymbol sym) {
        this.operands.push_back((Object)sym);
    }

    public void addOperand(OperandSymbol sym) {
        String operstring = "\n" + (char)(65 + this.operands.size());
        this.operands.push_back((Object)sym);
        this.printpiece.push_back((Object)operstring);
    }

    public void addSyntax(String syn) {
        if (!syn.isEmpty() && syn.trim().isEmpty()) {
            syn = " ";
        }
        if (this.firstwhitespace == -1 && " ".equals(syn)) {
            this.firstwhitespace = this.printpiece.size();
        }
        if (syn.isEmpty()) {
            return;
        }
        if (this.printpiece.empty()) {
            this.printpiece.push_back((Object)syn);
        } else if (!" ".equals(this.printpiece.back()) || !" ".equals(syn)) {
            if (((String)this.printpiece.back()).charAt(0) == '\n' || " ".equals(this.printpiece.back()) || " ".equals(syn)) {
                this.printpiece.push_back((Object)syn);
            } else {
                Object push = (String)this.printpiece.pop_back() + syn;
                if ("".equals(push)) {
                    push = " ";
                }
                this.printpiece.push_back(push);
            }
        }
    }

    public void addEquation(PatternEquation pe) {
        this.pateq = pe;
        this.pateq.layClaim();
    }

    public void setMainSection(ConstructTpl tpl) {
        this.templ = tpl;
    }

    public void setNamedSection(ConstructTpl tpl, int id) {
        while (this.namedtempl.size() <= id) {
            this.namedtempl.push_back(null);
        }
        this.namedtempl.set(id, (Object)tpl);
    }

    public void print(PrintStream s, ParserWalker pos) {
        IteratorSTL piter = this.printpiece.begin();
        while (!piter.isEnd()) {
            if (((String)piter.get()).charAt(0) == '\n') {
                int index = ((String)piter.get()).charAt(1) - 65;
                ((OperandSymbol)this.operands.get(index)).print(s, pos);
            } else {
                s.append((CharSequence)piter.get());
            }
            piter.increment();
        }
    }

    public void printMnemonic(PrintStream s, ParserWalker pos) {
        TripleSymbol definingSymbol;
        if (this.flowthruindex != -1 && (definingSymbol = ((OperandSymbol)this.operands.get(this.flowthruindex)).getDefiningSymbol()) instanceof SubtableSymbol) {
            pos.pushOperand(this.flowthruindex);
            pos.getConstructor().printMnemonic(s, pos);
            pos.popOperand();
            return;
        }
        int endind = this.firstwhitespace == -1 ? this.printpiece.size() : this.firstwhitespace;
        for (int i = 0; i < endind; ++i) {
            if (((String)this.printpiece.get(i)).charAt(0) == '\n') {
                int index = ((String)this.printpiece.get(i)).charAt(1) - 65;
                ((OperandSymbol)this.operands.get(index)).print(s, pos);
                continue;
            }
            s.append((CharSequence)this.printpiece.get(i));
        }
    }

    public void printBody(PrintStream s, ParserWalker pos) {
        TripleSymbol sym;
        if (this.flowthruindex != -1 && (sym = ((OperandSymbol)this.operands.get(this.flowthruindex)).getDefiningSymbol()) instanceof SubtableSymbol) {
            pos.pushOperand(this.flowthruindex);
            pos.getConstructor().printBody(s, pos);
            pos.popOperand();
            return;
        }
        if (this.firstwhitespace == -1) {
            return;
        }
        for (int i = this.firstwhitespace + 1; i < this.printpiece.size(); ++i) {
            if (((String)this.printpiece.get(i)).charAt(0) == '\n') {
                int index = ((String)this.printpiece.get(i)).charAt(1) - 65;
                ((OperandSymbol)this.operands.get(index)).print(s, pos);
                continue;
            }
            s.append((CharSequence)this.printpiece.get(i));
        }
    }

    public void removeTrailingSpace() {
        if (!this.printpiece.empty() && ((String)this.printpiece.back()).equals(" ")) {
            this.printpiece.pop_back();
        }
    }

    public void saveXml(PrintStream s) {
        int i;
        s.append("<constructor");
        s.append(" parent=\"0x");
        s.append(Long.toHexString(this.parent.getId()));
        s.append("\"");
        s.append(" first=\"");
        s.print(this.firstwhitespace);
        s.append("\"");
        s.append(" length=\"");
        s.print(this.minimumlength);
        s.append("\"");
        s.append(" line=\"");
        s.print(this.getLineno());
        s.append("\">\n");
        for (int i2 = 0; i2 < this.operands.size(); ++i2) {
            s.append("<oper id=\"0x");
            s.append(Long.toHexString(((OperandSymbol)this.operands.get(i2)).getId()));
            s.append("\"/>\n");
        }
        int printpieces = this.printpiece.size();
        for (i = 0; i < printpieces; ++i) {
            String piece = (String)this.printpiece.get(i);
            if (piece.length() > 0 && piece.charAt(0) == '\n') {
                int index = piece.charAt(1) - 65;
                s.append("<opprint id=\"");
                s.print(index);
                s.append("\"/>\n");
                continue;
            }
            s.append("<print piece=\"");
            XmlUtils.xml_escape(s, piece);
            s.append("\"/>\n");
        }
        for (i = 0; i < this.context.size(); ++i) {
            ((ContextChange)this.context.get(i)).saveXml(s);
        }
        if (this.templ != null) {
            this.templ.saveXml(s, -1);
        }
        for (i = 0; i < this.namedtempl.size(); ++i) {
            if (this.namedtempl.get(i) == null) continue;
            ((ConstructTpl)this.namedtempl.get(i)).saveXml(s, i);
        }
        s.append("</constructor>\n");
    }

    public void restoreXml(Element el, SleighBase trans) {
        int id = XmlUtils.decodeUnknownInt(el.getAttributeValue("parent"));
        this.parent = (SubtableSymbol)trans.findSymbol(id);
        this.firstwhitespace = XmlUtils.decodeUnknownInt(el.getAttributeValue("first"));
        this.minimumlength = XmlUtils.decodeUnknownInt(el.getAttributeValue("length"));
        int lineno = XmlUtils.decodeUnknownInt(el.getAttributeValue("line"));
        List list = el.getChildren();
        for (Element child : list) {
            ContextChange c_op;
            if (child.getName().equals("oper")) {
                id = XmlUtils.decodeUnknownInt(child.getAttributeValue("id"));
                OperandSymbol sym = (OperandSymbol)trans.findSymbol(id);
                this.operands.push_back((Object)sym);
                continue;
            }
            if (child.getName().equals("print")) {
                this.printpiece.push_back((Object)child.getAttributeValue("piece"));
                continue;
            }
            if (child.getName().equals("opprint")) {
                int index = XmlUtils.decodeUnknownInt(child.getAttributeValue("id"));
                char c = (char)(65 + index);
                String operstring = "\n" + c;
                this.printpiece.push_back((Object)operstring);
                continue;
            }
            if (child.getName().equals("context_op")) {
                c_op = new ContextOp(this.location);
                ((ContextOp)c_op).restoreXml(child, trans);
                this.context.push_back((Object)c_op);
                continue;
            }
            if (child.getName().equals("commit")) {
                c_op = new ContextCommit();
                ((ContextCommit)c_op).restoreXml(child, trans);
                this.context.push_back((Object)c_op);
                continue;
            }
            this.templ = new ConstructTpl(null);
            this.templ.restoreXml(child, trans);
        }
        this.pattern = null;
        this.flowthruindex = this.printpiece.size() == 1 && ((String)this.printpiece.get(0)).charAt(0) == '\n' ? ((String)this.printpiece.get(0)).charAt(1) - 65 : -1;
    }

    private void orderOperands() {
        int i;
        int lastsize;
        OperandSymbol sym;
        int i2;
        VectorSTL patternorder = new VectorSTL();
        VectorSTL newops = new VectorSTL();
        this.pateq.operandOrder(this, (VectorSTL<OperandSymbol>)patternorder);
        for (i2 = 0; i2 < this.operands.size(); ++i2) {
            sym = (OperandSymbol)this.operands.get(i2);
            if (sym.isMarked()) continue;
            patternorder.push_back((Object)sym);
            sym.setMark();
        }
        do {
            lastsize = newops.size();
            for (i2 = 0; i2 < patternorder.size(); ++i2) {
                sym = (OperandSymbol)patternorder.get(i2);
                if (!sym.isMarked() || sym.isOffsetIrrelevant() || sym.offsetbase != -1 && ((OperandSymbol)this.operands.get(sym.offsetbase)).isMarked()) continue;
                newops.push_back((Object)sym);
                sym.clearMark();
            }
        } while (newops.size() != lastsize);
        for (i2 = 0; i2 < patternorder.size(); ++i2) {
            sym = (OperandSymbol)patternorder.get(i2);
            if (!sym.isOffsetIrrelevant()) continue;
            newops.push_back((Object)sym);
            sym.clearMark();
        }
        if (newops.size() != this.operands.size()) {
            throw new SleighError("Circular offset dependency between operands", this.location);
        }
        for (i2 = 0; i2 < newops.size(); ++i2) {
            ((OperandSymbol)newops.get((int)i2)).hand = i2;
            ((OperandSymbol)newops.get((int)i2)).localexp.changeIndex(i2);
        }
        VectorSTL handmap = new VectorSTL(this.operands.size());
        for (i = 0; i < this.operands.size(); ++i) {
            handmap.push_back((Object)((OperandSymbol)this.operands.get((int)i)).hand);
        }
        for (i = 0; i < newops.size(); ++i) {
            sym = (OperandSymbol)newops.get(i);
            if (sym.offsetbase == -1) continue;
            sym.offsetbase = (Integer)handmap.get(sym.offsetbase);
        }
        if (this.templ != null) {
            this.templ.changeHandleIndex((VectorSTL<Integer>)handmap);
        }
        for (i = 0; i < this.namedtempl.size(); ++i) {
            ConstructTpl ntempl = (ConstructTpl)this.namedtempl.get(i);
            if (ntempl == null) continue;
            ntempl.changeHandleIndex((VectorSTL<Integer>)handmap);
        }
        for (i = 0; i < this.printpiece.size(); ++i) {
            String piece = (String)this.printpiece.get(i);
            if (piece.length() <= 0 || piece.charAt(0) != '\n') continue;
            int index = piece.charAt(1) - 65;
            index = (Integer)handmap.get(index);
            char c = (char)(65 + index);
            this.printpiece.set(i, (Object)("\n" + c));
        }
        this.operands = newops;
    }

    TokenPattern buildPattern(PrintStream s) {
        int i;
        if (this.pattern != null) {
            return this.pattern;
        }
        this.pattern = new TokenPattern(this.location);
        VectorSTL oppattern = new VectorSTL();
        boolean recursion = false;
        for (int i2 = 0; i2 < this.operands.size(); ++i2) {
            OperandSymbol sym = (OperandSymbol)this.operands.get(i2);
            TripleSymbol triple = sym.getDefiningSymbol();
            PatternExpression defexp = sym.getDefiningExpression();
            if (triple != null) {
                if (triple instanceof SubtableSymbol) {
                    SubtableSymbol subsym = (SubtableSymbol)triple;
                    if (subsym.isBeingBuilt()) {
                        if (recursion) {
                            throw new SleighError("Illegal recursion", this.location);
                        }
                        recursion = true;
                        oppattern.push_back((Object)new TokenPattern(this.location));
                    } else {
                        oppattern.push_back((Object)subsym.buildPattern(s));
                    }
                } else {
                    oppattern.push_back((Object)triple.getPatternExpression().genMinPattern((VectorSTL<TokenPattern>)oppattern));
                }
            } else if (defexp != null) {
                TokenPattern tmppat = defexp.genMinPattern((VectorSTL<TokenPattern>)oppattern);
                if (null == tmppat) {
                    throw new SleighError("operand " + sym.getName() + " has an issue", this.location);
                }
                oppattern.push_back((Object)tmppat);
            } else {
                throw new SleighError("operand " + sym.getName() + " is undefined", this.location);
            }
            TokenPattern sympat = (TokenPattern)oppattern.back();
            sym.minimumlength = sympat.getMinimumLength();
            if (!sympat.getLeftEllipsis() && !sympat.getRightEllipsis()) continue;
            sym.setVariableLength();
        }
        if (this.pateq == null) {
            throw new SleighError("Missing equation", this.location);
        }
        this.pateq.genPattern((VectorSTL<TokenPattern>)oppattern);
        this.pattern = new TokenPattern(this.location, this.pateq.getTokenPattern());
        if (this.pattern.alwaysFalse()) {
            throw new SleighError("Impossible pattern--always false", this.location);
        }
        if (recursion) {
            this.pattern.setRightEllipsis(true);
        }
        this.minimumlength = this.pattern.getMinimumLength();
        OperandResolve resolve = new OperandResolve(this.operands);
        if (!this.pateq.resolveOperandLeft(resolve)) {
            throw new SleighError("Unable to resolve operand offsets", this.location);
        }
        for (i = 0; i < this.operands.size(); ++i) {
            OperandSymbol sym = (OperandSymbol)this.operands.get(i);
            if (sym.isOffsetIrrelevant()) {
                sym.offsetbase = -1;
                sym.reloffset = 0;
                continue;
            }
            int base = sym.offsetbase;
            int offset = sym.reloffset;
            while (base >= 0 && !(sym = (OperandSymbol)this.operands.get(base)).isVariableLength()) {
                base = sym.offsetbase;
                offset += sym.getMinimumLength();
                offset += sym.reloffset;
                if (base >= 0) continue;
                ((OperandSymbol)this.operands.get((int)i)).offsetbase = base;
                ((OperandSymbol)this.operands.get((int)i)).reloffset = offset;
            }
        }
        for (i = 0; i < this.context.size(); ++i) {
            ((ContextChange)this.context.get(i)).validate();
        }
        this.orderOperands();
        return this.pattern;
    }

    String detailedName() {
        return "";
    }

    public void printInfo(PrintStream s) {
        s.append("table \"").append(this.parent.getName());
        s.append("\" constructor " + this.detailedName() + "from " + this.location);
    }

    public String toString() {
        return "table \"" + this.parent.getName() + "\" constructor " + this.detailedName() + "from " + this.location;
    }
}

