/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import db.Record;
import ghidra.program.database.DatabaseObject;
import ghidra.program.model.address.KeyRange;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DBObjectCache<T extends DatabaseObject> {
    private Map<Long, KeyedSoftReference> map;
    private ReferenceQueue<T> refQueue;
    private LinkedList<T> hardCache;
    private int hardCacheSize;
    private volatile int invalidateCount;

    public DBObjectCache(int hardCacheSize) {
        this.hardCacheSize = hardCacheSize;
        this.map = new HashMap<Long, KeyedSoftReference>();
        this.refQueue = new ReferenceQueue();
        this.hardCache = new LinkedList();
    }

    public synchronized T get(long key) {
        KeyedSoftReference ref = this.map.get(key);
        if (ref != null) {
            DatabaseObject obj = (DatabaseObject)ref.get();
            if (obj == null) {
                this.map.remove(key);
            } else {
                if (obj.checkIsValid()) {
                    this.addToHardCache(obj);
                    return (T)obj;
                }
                this.map.remove(key);
            }
        }
        return null;
    }

    public synchronized T get(Record objectRecord) {
        long key = objectRecord.getKey();
        KeyedSoftReference ref = this.map.get(key);
        if (ref != null) {
            DatabaseObject obj = (DatabaseObject)ref.get();
            if (obj == null) {
                this.map.remove(key);
            } else {
                if (obj.checkIsValid(objectRecord)) {
                    this.addToHardCache(obj);
                    return (T)obj;
                }
                this.map.remove(key);
            }
        }
        return null;
    }

    public int size() {
        return this.map.size();
    }

    public synchronized void setHardCacheSize(int size) {
        while (this.hardCache.size() > size) {
            this.hardCache.removeLast();
        }
        this.hardCacheSize = size;
    }

    void put(T data) {
        this.processQueue();
        long key = ((DatabaseObject)data).getKey();
        this.addToHardCache(data);
        KeyedSoftReference ref = new KeyedSoftReference(this, key, data, this.refQueue);
        this.map.put(key, ref);
    }

    public synchronized List<T> getCachedObjects() {
        ArrayList<DatabaseObject> list = new ArrayList<DatabaseObject>();
        this.processQueue();
        for (KeyedSoftReference ref : this.map.values()) {
            DatabaseObject obj = (DatabaseObject)ref.get();
            if (obj == null) continue;
            list.add(obj);
        }
        return list;
    }

    public synchronized void delete(List<KeyRange> keyRanges) {
        this.hardCache.clear();
        this.processQueue();
        long rangesSize = this.getKeyRangesSize(keyRanges);
        if (rangesSize < 0L || rangesSize > (long)this.map.size()) {
            this.deleteLargeKeyRanges(keyRanges);
        } else {
            this.deleteSmallKeyRanges(keyRanges);
        }
    }

    private void deleteSmallKeyRanges(List<KeyRange> keyRanges) {
        for (KeyRange range : keyRanges) {
            for (long key = range.minKey; key <= range.maxKey; ++key) {
                DatabaseObject obj;
                KeyedSoftReference ref = this.map.remove(key);
                if (ref == null || (obj = (DatabaseObject)ref.get()) == null) continue;
                obj.setDeleted();
                ref.clear();
            }
        }
    }

    private void deleteLargeKeyRanges(List<KeyRange> keyRanges) {
        this.map.values().removeIf(ref -> this.checkRef((KeyedSoftReference)ref, keyRanges));
    }

    private boolean checkRef(KeyedSoftReference ref, List<KeyRange> keyRanges) {
        long key = ref.getKey();
        if (this.keyRangesContain(keyRanges, key)) {
            DatabaseObject obj = (DatabaseObject)ref.get();
            if (obj != null) {
                obj.setDeleted();
                ref.clear();
            }
            return true;
        }
        return false;
    }

    private long getKeyRangesSize(List<KeyRange> keyRanges) {
        long size = 0L;
        for (KeyRange range : keyRanges) {
            if ((size += range.length()) >= 0L) continue;
            return -1L;
        }
        return size;
    }

    private boolean keyRangesContain(List<KeyRange> keyRanges, long key) {
        for (KeyRange range : keyRanges) {
            if (!range.contains(key)) continue;
            return true;
        }
        return false;
    }

    public synchronized void invalidate() {
        this.hardCache.clear();
        this.processQueue();
        if (++this.invalidateCount <= 0) {
            this.invalidateCount = 1;
            for (KeyedSoftReference ref : this.map.values()) {
                DatabaseObject obj = (DatabaseObject)ref.get();
                if (obj == null) continue;
                obj.setInvalid();
            }
        }
    }

    int getInvalidateCount() {
        return this.invalidateCount;
    }

    public synchronized void delete(long key) {
        this.processQueue();
        KeyedSoftReference ref = this.map.get(key);
        if (ref != null) {
            DatabaseObject obj = (DatabaseObject)ref.get();
            if (obj != null) {
                obj.setDeleted();
                ref.clear();
            }
            this.map.remove(key);
        }
    }

    private void addToHardCache(T obj) {
        this.hardCache.addLast(obj);
        if (this.hardCache.size() > this.hardCacheSize) {
            this.hardCache.removeFirst();
        }
    }

    private void processQueue() {
        KeyedSoftReference ref;
        while ((ref = (KeyedSoftReference)this.refQueue.poll()) != null) {
            long key = ref.getKey();
            KeyedSoftReference oldValue = this.map.remove(key);
            if (oldValue == null || oldValue == ref) continue;
            this.map.put(key, oldValue);
        }
    }

    public synchronized void keyChanged(long oldKey, long newKey) {
        this.processQueue();
        KeyedSoftReference ref = this.map.remove(oldKey);
        if (ref != null) {
            this.map.put(newKey, ref);
            DatabaseObject t = (DatabaseObject)ref.get();
            if (t != null) {
                t.setInvalid();
            }
        }
    }

    private class KeyedSoftReference
    extends WeakReference<T> {
        private long key;
        final /* synthetic */ DBObjectCache this$0;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        KeyedSoftReference(long obj, T t, ReferenceQueue<T> referenceQueue) {
            void key;
            void queue;
            this.this$0 = (DBObjectCache)l;
            super(obj, queue);
            this.key = key;
        }

        long getKey() {
            return this.key;
        }
    }
}

