/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.code;

import db.DBHandle;
import db.Record;
import db.RecordIterator;
import db.Table;
import ghidra.program.database.code.InstDBAdapter;
import ghidra.program.database.map.AddressKeyIterator;
import ghidra.program.database.map.AddressKeyRecordIterator;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.map.AddressRecordDeleter;
import ghidra.program.database.util.DatabaseTableUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

class InstDBAdapterV1
extends InstDBAdapter {
    private static final int VERSION = 1;
    private Table instTable;
    private AddressMap addrMap;

    public InstDBAdapterV1(DBHandle handle, AddressMap addrMap, boolean create) throws IOException, VersionException {
        this.addrMap = addrMap;
        if (create) {
            this.instTable = handle.createTable("Instructions", INSTRUCTION_SCHEMA);
        } else {
            this.instTable = handle.getTable("Instructions");
            if (this.instTable == null) {
                throw new VersionException("Missing Table: Instructions");
            }
            if (this.instTable.getSchema().getVersion() != 1) {
                int version = this.instTable.getSchema().getVersion();
                if (version < 1) {
                    throw new VersionException(true);
                }
                throw new VersionException(2, false);
            }
        }
    }

    @Override
    void createInstruction(long addr, int protoID, byte flags) throws IOException {
        Record record = INSTRUCTION_SCHEMA.createRecord(addr);
        record.setIntValue(0, protoID);
        record.setByteValue(1, flags);
        this.instTable.putRecord(record);
    }

    @Override
    void deleteRecord(long addr) throws IOException {
        this.instTable.deleteRecord(addr);
    }

    @Override
    Record getRecordAtOrAfter(Address addr) throws IOException {
        AddressKeyRecordIterator it = new AddressKeyRecordIterator(this.instTable, this.addrMap, addr, true);
        return it.next();
    }

    @Override
    Record getRecord(long addr) throws IOException {
        return this.instTable.getRecord(addr);
    }

    @Override
    Record getRecord(Address addr) throws IOException {
        return this.instTable.getRecord(this.addrMap.getKey(addr, false));
    }

    @Override
    Record getRecordAfter(Address addr) throws IOException {
        AddressKeyRecordIterator it = new AddressKeyRecordIterator(this.instTable, this.addrMap, addr, false);
        return it.next();
    }

    @Override
    Record getRecordBefore(Address addr) throws IOException {
        AddressKeyRecordIterator it = new AddressKeyRecordIterator(this.instTable, this.addrMap, addr, true);
        return it.previous();
    }

    @Override
    RecordIterator getRecords(Address addr, boolean forward) throws IOException {
        return new AddressKeyRecordIterator(this.instTable, this.addrMap, addr, forward);
    }

    @Override
    RecordIterator getRecords(AddressSetView set, boolean forward) throws IOException {
        return new AddressKeyRecordIterator(this.instTable, this.addrMap, set, forward ? set.getMinAddress() : set.getMaxAddress(), forward);
    }

    @Override
    RecordIterator getRecords(Address start, Address end, boolean atStart) throws IOException {
        if (atStart) {
            return new AddressKeyRecordIterator(this.instTable, this.addrMap, start, end, start, true);
        }
        return new AddressKeyRecordIterator(this.instTable, this.addrMap, start, end, end, false);
    }

    @Override
    Record getRecordAtOrBefore(Address addr) throws IOException {
        AddressKeyRecordIterator it = new AddressKeyRecordIterator(this.instTable, this.addrMap, addr, false);
        return it.previous();
    }

    @Override
    int getRecordCount() throws IOException {
        return this.instTable.getRecordCount();
    }

    @Override
    AddressKeyIterator getKeys(Address start, Address end, boolean atStart) throws IOException {
        if (atStart) {
            return new AddressKeyIterator(this.instTable, this.addrMap, start, end, start, true);
        }
        return new AddressKeyIterator(this.instTable, this.addrMap, start, end, end, false);
    }

    @Override
    AddressKeyIterator getKeys(AddressSetView set, boolean forward) throws IOException {
        if (forward) {
            return new AddressKeyIterator(this.instTable, this.addrMap, set, set.getMinAddress(), true);
        }
        return new AddressKeyIterator(this.instTable, this.addrMap, set, set.getMaxAddress(), false);
    }

    @Override
    boolean deleteRecords(Address start, Address end) throws IOException {
        return AddressRecordDeleter.deleteRecords(this.instTable, this.addrMap, start, end);
    }

    @Override
    void putRecord(Record record) throws IOException {
        this.instTable.putRecord(record);
    }

    @Override
    RecordIterator getRecords() throws IOException {
        return new AddressKeyRecordIterator(this.instTable, this.addrMap);
    }

    @Override
    void updateFlags(long addr, byte flags) throws IOException {
        Record rec = this.instTable.getRecord(addr);
        rec.setByteValue(1, flags);
        this.instTable.putRecord(rec);
    }

    @Override
    void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws CancelledException, IOException {
        DatabaseTableUtils.updateAddressKey(this.instTable, this.addrMap, fromAddr, toAddr, length, monitor);
    }

    @Override
    void deleteAll() throws IOException {
        this.instTable.deleteAll();
    }
}

