/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.BooleanField;
import db.DBHandle;
import db.Field;
import db.IntField;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.CompositeDBAdapter;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.util.ReadOnlyException;
import ghidra.util.UniversalID;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Date;

class CompositeDBAdapterV2V3
extends CompositeDBAdapter {
    static final int VERSION = 4;
    static final int MIN_READ_ONLY_VERSION = 2;
    static final int V2_COMPOSITE_NAME_COL = 0;
    static final int V2_COMPOSITE_COMMENT_COL = 1;
    static final int V2_COMPOSITE_IS_UNION_COL = 2;
    static final int V2_COMPOSITE_CAT_COL = 3;
    static final int V2_COMPOSITE_LENGTH_COL = 4;
    static final int V2_COMPOSITE_NUM_COMPONENTS_COL = 5;
    static final int V2_COMPOSITE_SOURCE_ARCHIVE_ID_COL = 6;
    static final int V2_COMPOSITE_UNIVERSAL_DT_ID_COL = 7;
    static final int V2_COMPOSITE_SOURCE_SYNC_TIME_COL = 8;
    static final int V2_COMPOSITE_LAST_CHANGE_TIME_COL = 9;
    static final int V2_COMPOSITE_INTERNAL_ALIGNMENT_COL = 10;
    static final int V2_COMPOSITE_EXTERNAL_ALIGNMENT_COL = 11;
    static final Schema V2_COMPOSITE_SCHEMA = new Schema(4, "Data Type ID", new Class[]{StringField.class, StringField.class, BooleanField.class, LongField.class, IntField.class, IntField.class, LongField.class, LongField.class, LongField.class, LongField.class, IntField.class, IntField.class}, new String[]{"Name", "Comment", "Is Union", "Category ID", "Length", "Number Of Components", "Source Archive ID", "Source Data Type ID", "Source Sync Time", "Last Change Time", "Internal Alignment", "External Alignment"});
    private Table compositeTable;
    private boolean readOnly;

    public CompositeDBAdapterV2V3(DBHandle handle, int openMode) throws VersionException, IOException {
        boolean bl = this.readOnly = openMode == 2;
        if (openMode == 0) {
            this.compositeTable = handle.createTable("Composite Data Types", V2_COMPOSITE_SCHEMA, new int[]{3, 7});
        } else {
            this.compositeTable = handle.getTable("Composite Data Types");
            if (this.compositeTable == null) {
                throw new VersionException("Missing Table: Composite Data Types");
            }
            int version = this.compositeTable.getSchema().getVersion();
            if (version != 4) {
                if (version < 4 && version >= 2) {
                    if (openMode == 2) {
                        return;
                    }
                    throw new VersionException(1, true);
                }
                String msg = "Expected version 2-4 for table Composite Data Types but got " + version;
                throw new VersionException(msg, 2, false);
            }
        }
    }

    public CompositeDBAdapterV2V3(DBHandle handle) throws VersionException {
        this.readOnly = true;
        this.compositeTable = handle.getTable("Composite Data Types");
        if (this.compositeTable == null) {
            throw new VersionException("Missing Table: Composite Data Types");
        }
        int version = this.compositeTable.getSchema().getVersion();
        if (version < 2) {
            throw new VersionException(1, true);
        }
        if (version > 4) {
            String msg = "Expected version 4 for table Composite Data Types but got " + version;
            throw new VersionException(msg, 2, false);
        }
    }

    @Override
    public Record createRecord(String name, String comments, boolean isUnion, long categoryID, int length, long sourceArchiveID, long sourceDataTypeID, long lastChangeTime, int internalAlignment, int externalAlignment) throws IOException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        if (internalAlignment == -1) {
            length = 0;
        }
        long tableKey = this.compositeTable.getKey();
        long key = DataTypeManagerDB.createKey(1, tableKey);
        Record record = CompositeDBAdapter.COMPOSITE_SCHEMA.createRecord(key);
        record.setString(0, name);
        record.setString(1, comments);
        record.setBooleanValue(2, isUnion);
        record.setLongValue(3, categoryID);
        record.setIntValue(4, length);
        record.setIntValue(5, length);
        record.setLongValue(6, sourceArchiveID);
        record.setLongValue(7, sourceDataTypeID);
        record.setLongValue(8, lastChangeTime);
        record.setLongValue(9, lastChangeTime);
        record.setIntValue(10, internalAlignment);
        record.setIntValue(11, externalAlignment);
        this.compositeTable.putRecord(record);
        return record;
    }

    @Override
    public Record getRecord(long dataTypeID) throws IOException {
        return this.compositeTable.getRecord(dataTypeID);
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.compositeTable.iterator();
    }

    @Override
    public void updateRecord(Record record, boolean setLastChangeTime) throws IOException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        if (setLastChangeTime) {
            record.setLongValue(9, new Date().getTime());
        }
        this.compositeTable.putRecord(record);
    }

    @Override
    public boolean removeRecord(long compositeID) throws IOException {
        if (this.readOnly) {
            throw new ReadOnlyException();
        }
        return this.compositeTable.deleteRecord(compositeID);
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable("Composite Data Types");
    }

    @Override
    public long[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.compositeTable.findRecords((Field)new LongField(categoryID), 3);
    }

    @Override
    long[] getRecordIdsForSourceArchive(long archiveID) throws IOException {
        return this.compositeTable.findRecords((Field)new LongField(archiveID), 6);
    }

    @Override
    Record getRecordWithIDs(UniversalID sourceID, UniversalID datatypeID) throws IOException {
        long[] keys = this.compositeTable.findRecords((Field)new LongField(datatypeID.getValue()), 7);
        for (int i = 0; i < keys.length; ++i) {
            Record record = this.compositeTable.getRecord(keys[i]);
            if (record.getLongValue(6) != sourceID.getValue()) continue;
            return record;
        }
        return null;
    }
}

