/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.ByteField;
import db.DBHandle;
import db.Field;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.DataTypeManagerDB;
import ghidra.program.database.data.FunctionDefinitionDBAdapter;
import ghidra.program.model.data.GenericCallingConvention;
import ghidra.util.Msg;
import ghidra.util.UniversalID;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Date;

class FunctionDefinitionDBAdapterV1
extends FunctionDefinitionDBAdapter {
    static final int VERSION = 1;
    static final int V1_FUNCTION_DEF_NAME_COL = 0;
    static final int V1_FUNCTION_DEF_COMMENT_COL = 1;
    static final int V1_FUNCTION_DEF_CAT_ID_COL = 2;
    static final int V1_FUNCTION_DEF_RETURN_ID_COL = 3;
    static final int V1_FUNCTION_DEF_FLAGS_COL = 4;
    static final int V1_FUNCTION_DEF_SOURCE_ARCHIVE_ID_COL = 5;
    static final int V1_FUNCTION_DEF_UNIVERSAL_DT_ID_COL = 6;
    static final int V1_FUNCTION_DEF_SOURCE_SYNC_TIME_COL = 7;
    static final int V1_FUNCTION_DEF_LAST_CHANGE_TIME_COL = 8;
    static final Schema V1_FUN_DEF_SCHEMA = new Schema(1, "Data Type ID", new Class[]{StringField.class, StringField.class, LongField.class, LongField.class, ByteField.class, LongField.class, LongField.class, LongField.class, LongField.class}, new String[]{"Name", "Comment", "Category ID", "Return Type ID", "Flags", "Source Archive ID", "Source Data Type ID", "Source Sync Time", "Last Change Time"});
    private Table table;

    public FunctionDefinitionDBAdapterV1(DBHandle handle, boolean create) throws VersionException, IOException {
        if (create) {
            this.table = handle.createTable("Function Definitions", V1_FUN_DEF_SCHEMA, new int[]{2, 6});
        } else {
            this.table = handle.getTable("Function Definitions");
            if (this.table == null) {
                throw new VersionException("Missing Table: Function Definitions");
            }
            int version = this.table.getSchema().getVersion();
            if (version != 1) {
                String msg = "Expected version 1 for table Function Definitions but got " + this.table.getSchema().getVersion();
                if (version < 1) {
                    throw new VersionException(msg, 1, true);
                }
                throw new VersionException(msg, 2, false);
            }
        }
    }

    @Override
    public Record createRecord(String name, String comments, long categoryID, long returnDtID, boolean hasVarArgs, GenericCallingConvention genericCallingConvention, long sourceArchiveID, long sourceDataTypeID, long lastChangeTime) throws IOException {
        byte flags = 0;
        if (hasVarArgs) {
            flags = (byte)(flags | 1);
        }
        if (genericCallingConvention != null) {
            int ordinal = genericCallingConvention.ordinal();
            if (ordinal < 0 || ordinal > 15) {
                Msg.error((Object)this, (Object)("GenericCallingConvention ordinal unsupported: " + ordinal));
            } else {
                flags = (byte)(flags | ordinal << 1);
            }
        }
        long tableKey = this.table.getKey();
        long key = DataTypeManagerDB.createKey(6, tableKey);
        Record record = V1_FUN_DEF_SCHEMA.createRecord(key);
        record.setString(0, name);
        record.setString(1, comments);
        record.setLongValue(2, categoryID);
        record.setLongValue(3, returnDtID);
        record.setByteValue(4, flags);
        record.setLongValue(5, sourceArchiveID);
        record.setLongValue(6, sourceDataTypeID);
        record.setLongValue(7, lastChangeTime);
        record.setLongValue(8, lastChangeTime);
        this.table.putRecord(record);
        return record;
    }

    @Override
    public Record getRecord(long functionDefID) throws IOException {
        return this.table.getRecord(functionDefID);
    }

    @Override
    public void updateRecord(Record record, boolean setLastChangeTime) throws IOException {
        if (setLastChangeTime) {
            record.setLongValue(8, new Date().getTime());
        }
        this.table.putRecord(record);
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    public boolean removeRecord(long functionDefID) throws IOException {
        return this.table.deleteRecord(functionDefID);
    }

    @Override
    protected void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable("Function Definitions");
    }

    @Override
    public long[] getRecordIdsInCategory(long categoryID) throws IOException {
        return this.table.findRecords((Field)new LongField(categoryID), 2);
    }

    @Override
    long[] getRecordIdsForSourceArchive(long archiveID) throws IOException {
        return this.table.findRecords((Field)new LongField(archiveID), 5);
    }

    @Override
    Record getRecordWithIDs(UniversalID sourceID, UniversalID datatypeID) throws IOException {
        long[] keys = this.table.findRecords((Field)new LongField(datatypeID.getValue()), 6);
        for (int i = 0; i < keys.length; ++i) {
            Record record = this.table.getRecord(keys[i]);
            if (record.getLongValue(5) != sourceID.getValue()) continue;
            return record;
        }
        return null;
    }
}

