/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.data;

import db.BooleanField;
import db.ByteField;
import db.DBHandle;
import db.LongField;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.data.SourceArchiveAdapter;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.UniversalID;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

class SourceArchiveAdapterV0
extends SourceArchiveAdapter {
    static final int VERSION = 0;
    static final int V0_ARCHIVE_ID_DOMAIN_FILE_ID_COL = 0;
    static final int V0_ARCHIVE_ID_NAME_COL = 1;
    static final int V0_ARCHIVE_ID_TYPE_COL = 2;
    static final int V0_ARCHIVE_ID_LAST_SYNC_TIME_COL = 3;
    static final int V0_ARCHIVE_ID_DIRTY_FLAG_COL = 4;
    static final Schema V0_SCHEMA = new Schema(0, "Archive ID", new Class[]{StringField.class, StringField.class, ByteField.class, LongField.class, BooleanField.class}, new String[]{"Domain File ID", "Name", "Type", "Last Sync Time", "Dirty Flag"});
    private Table table;

    public SourceArchiveAdapterV0(DBHandle handle, boolean create) throws VersionException, IOException {
        if (create) {
            this.table = handle.createTable("Data Type Archive IDs", V0_SCHEMA);
            this.createRecordForLocalManager();
        } else {
            this.table = handle.getTable("Data Type Archive IDs");
            if (this.table == null) {
                throw new VersionException(true);
            }
            int version = this.table.getSchema().getVersion();
            if (version != 0) {
                String msg = "Expected version 0 for table Data Type Archive IDs but got " + this.table.getSchema().getVersion();
                if (version < 0) {
                    throw new VersionException(msg, 1, true);
                }
                throw new VersionException(msg, 2, false);
            }
        }
    }

    private void createRecordForLocalManager() throws IOException {
        Record record = V0_SCHEMA.createRecord(0L);
        record.setLongValue(3, new Date().getTime());
        this.table.putRecord(record);
    }

    @Override
    public Record createRecord(SourceArchive archive) throws IOException {
        Record record = V0_SCHEMA.createRecord(archive.getSourceArchiveID().getValue());
        record.setString(0, archive.getDomainFileID());
        record.setString(1, archive.getName());
        record.setByteValue(2, (byte)archive.getArchiveType().ordinal());
        record.setLongValue(3, archive.getLastSyncTime());
        record.setBooleanValue(4, false);
        this.table.putRecord(record);
        return record;
    }

    @Override
    void deleteRecord(UniversalID sourceArchiveID) throws IOException {
        this.table.deleteRecord(sourceArchiveID.getValue());
    }

    @Override
    public Record getRecord(long key) throws IOException {
        return this.table.getRecord(key);
    }

    @Override
    public List<Record> getRecords() throws IOException {
        ArrayList<Record> records = new ArrayList<Record>();
        RecordIterator iterator = this.table.iterator();
        while (iterator.hasNext()) {
            records.add(iterator.next());
        }
        return records;
    }

    @Override
    public void updateRecord(Record record) throws IOException {
        this.table.putRecord(record);
    }

    @Override
    public boolean removeRecord(long dataTypeArchiveID) throws IOException {
        return this.table.deleteRecord(dataTypeArchiveID);
    }

    @Override
    protected void deleteTable(DBHandle handle) throws IOException {
    }
}

