/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.mem;

import db.Record;
import ghidra.program.database.mem.MemoryMapDBAdapter;
import ghidra.program.database.mem.SubMemoryBlock;
import ghidra.program.model.mem.MemoryAccessException;
import java.io.IOException;

class UninitializedSubMemoryBlock
extends SubMemoryBlock {
    UninitializedSubMemoryBlock(MemoryMapDBAdapter adapter, Record record) {
        super(adapter, record);
    }

    @Override
    public boolean isInitialized() {
        return false;
    }

    @Override
    public byte getByte(long offset) throws MemoryAccessException {
        if (offset < this.subBlockOffset || offset >= this.subBlockOffset + this.subBlockLength) {
            throw new IllegalArgumentException("Offset " + offset + "is out of bounds. Should be in [" + this.subBlockOffset + "," + (this.subBlockOffset + this.subBlockLength - 1L));
        }
        throw new MemoryAccessException("Attempted to read from uninitialized block");
    }

    @Override
    public int getBytes(long offset, byte[] b, int off, int len) throws MemoryAccessException {
        throw new MemoryAccessException("Attempted to read from uninitialized block");
    }

    @Override
    public void putByte(long offset, byte b) throws MemoryAccessException {
        throw new MemoryAccessException("Attempted to write to an uninitialized block");
    }

    @Override
    public int putBytes(long offset, byte[] b, int off, int len) throws MemoryAccessException {
        throw new MemoryAccessException("Attempted to write to an uninitialized block");
    }

    @Override
    protected boolean join(SubMemoryBlock block) throws IOException {
        if (!(block instanceof UninitializedSubMemoryBlock)) {
            return false;
        }
        this.setLength(this.subBlockLength + block.subBlockLength);
        this.adapter.deleteSubBlock(block.record.getKey());
        return true;
    }

    @Override
    protected SubMemoryBlock split(long memBlockOffset) throws IOException {
        long offset = memBlockOffset - this.subBlockOffset;
        long newLength = this.subBlockLength - offset;
        this.subBlockLength = offset;
        this.record.setLongValue(2, this.subBlockLength);
        this.adapter.updateSubBlockRecord(this.record);
        Record newSubRecord = this.adapter.createSubBlockRecord(-1L, 0L, newLength, (byte)3, 0, 0L);
        return new UninitializedSubMemoryBlock(this.adapter, newSubRecord);
    }

    @Override
    protected String getDescription() {
        return "";
    }
}

