/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.module;

import db.DBHandle;
import db.Field;
import db.Record;
import db.RecordIterator;
import db.StringField;
import db.Table;
import ghidra.program.database.module.TreeDBAdapter;
import ghidra.program.database.module.TreeManager;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class TreeDBAdapterV0
implements TreeDBAdapter {
    private Table treeTable;
    private DBHandle handle;

    TreeDBAdapterV0(DBHandle handle) throws VersionException {
        this.handle = handle;
        this.treeTable = handle.getTable("Trees");
        this.testVersion(0);
    }

    private void testVersion(int expectedVersion) throws VersionException {
        if (this.treeTable == null) {
            throw new VersionException("Tree table not found");
        }
        int versionNumber = this.treeTable.getSchema().getVersion();
        if (versionNumber != expectedVersion) {
            throw new VersionException(2, false);
        }
    }

    @Override
    public Record createRecord(String name) throws IOException {
        Record record = TreeManager.TREE_SCHEMA.createRecord(this.treeTable.getKey());
        record.setString(0, name);
        record.setLongValue(1, 0L);
        this.treeTable.putRecord(record);
        return record;
    }

    @Override
    public boolean deleteRecord(long treeID) throws IOException {
        if (this.treeTable.deleteRecord(treeID)) {
            this.handle.deleteTable(TreeManager.getFragmentTableName(treeID));
            this.handle.deleteTable(TreeManager.getModuleTableName(treeID));
            this.handle.deleteTable(TreeManager.getParentChildTableName(treeID));
            return true;
        }
        return false;
    }

    @Override
    public Record getRecord(long treeID) throws IOException {
        return this.treeTable.getRecord(treeID);
    }

    @Override
    public Record getRecord(String name) throws IOException {
        long[] keys = this.treeTable.findRecords((Field)new StringField(name), 0);
        if (keys.length == 0) {
            return null;
        }
        if (keys.length > 1) {
            throw new AssertException("Found " + keys.length + " trees named " + name);
        }
        return this.treeTable.getRecord(keys[0]);
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.treeTable.iterator();
    }

    @Override
    public void updateRecord(Record record) throws IOException {
        this.treeTable.putRecord(record);
    }
}

