/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.references;

import ghidra.program.database.references.ReferenceDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.RefType;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.util.SimpleDiffUtility;

class MemReferenceDB
extends ReferenceDB {
    private Program program;
    private boolean isOffset;
    private boolean isShifted;
    protected long offsetOrShift;

    protected MemReferenceDB(Program program, Address fromAddr, Address toAddr, RefType refType, int opIndex, SourceType sourceType, boolean isPrimary, long symbolID, boolean isOffset, boolean isShifted, long offsetOrShift) {
        super(fromAddr, toAddr, refType, opIndex, sourceType, isPrimary, symbolID);
        this.program = program;
        this.isOffset = isOffset;
        this.isShifted = isShifted;
        this.offsetOrShift = offsetOrShift;
    }

    MemReferenceDB(Program program, Address from, Address to, RefType type, int opIndex, SourceType sourceType, boolean isPrimary, long symbolID) {
        this(program, from, to, type, opIndex, sourceType, isPrimary, symbolID, false, false, 0L);
    }

    public boolean isOffset() {
        return this.isOffset;
    }

    public boolean isShifted() {
        return this.isShifted;
    }

    public long getOffsetOrShift() {
        return this.offsetOrShift;
    }

    void setProgram(Program program) {
    }

    @Override
    public boolean isOffsetReference() {
        return this.isOffset;
    }

    @Override
    public boolean isShiftedReference() {
        return this.isShifted;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof MemReferenceDB) {
            MemReferenceDB memRef = (MemReferenceDB)obj;
            if (this.program == memRef.program) {
                return this.fromAddr.equals(memRef.getFromAddress()) && this.toAddr.equals(memRef.getToAddress()) && this.opIndex == memRef.getOperandIndex() && this.symbolID == memRef.getSymbolID() && this.isPrimary == memRef.isPrimary() && this.sourceType == memRef.getSource() && this.refType == memRef.getReferenceType() && this.isShiftedReference() == memRef.isShiftedReference() && this.isOffsetReference() == memRef.isOffsetReference();
            }
            Address compatibleFromAddr = SimpleDiffUtility.getCompatibleAddress(this.program, this.fromAddr, memRef.program);
            if (compatibleFromAddr == null) {
                compatibleFromAddr = this.fromAddr;
            }
            return compatibleFromAddr.equals(memRef.fromAddr) && this.opIndex == memRef.opIndex && this.sourceType == memRef.sourceType && this.refType == memRef.getReferenceType() && this.toAddr.getOffset() == memRef.toAddr.getOffset() && this.isPrimary == memRef.isPrimary() && this.isShiftedReference() == memRef.isShiftedReference() && this.isOffsetReference() == memRef.isOffsetReference();
        }
        if (obj instanceof Reference) {
            Reference ref = (Reference)obj;
            return this.fromAddr.equals(ref.getFromAddress()) && this.toAddr.equals(ref.getToAddress()) && this.opIndex == ref.getOperandIndex() && this.symbolID == ref.getSymbolID() && this.isPrimary == ref.isPrimary() && this.sourceType == ref.getSource() && this.refType == ref.getReferenceType() && this.isShiftedReference() == ref.isShiftedReference() && this.isOffsetReference() == ref.isOffsetReference();
        }
        return false;
    }
}

