/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.util;

import db.BooleanField;
import db.DBHandle;
import db.Field;
import db.util.ErrorHandler;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.util.AddressRangeMapDB;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.EmptyAddressIterator;
import ghidra.program.model.util.AddressSetPropertyMap;
import ghidra.util.Lock;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.util.ConcurrentModificationException;

public class AddressSetPropertyMapDB
implements AddressSetPropertyMap {
    private static final String MY_PREFIX = "AddressSet - ";
    private static final String TABLE_PREFIX = "Range Map - AddressSet - ";
    private ProgramDB program;
    private AddressRangeMapDB propertyMap;
    private Lock lock;
    private boolean invalid;
    private String mapName;
    private static Field FIELD = new BooleanField(true);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AddressSetPropertyMapDB getPropertyMap(ProgramDB program, String mapName, ErrorHandler errHandler, AddressMap addrMap, Lock lock) {
        lock.acquire();
        try {
            String tableName = TABLE_PREFIX + mapName;
            DBHandle dbh = program.getDBHandle();
            if (dbh.getTable(tableName) != null) {
                AddressSetPropertyMapDB addressSetPropertyMapDB = new AddressSetPropertyMapDB(program, mapName, (ErrorHandler)program, addrMap, lock);
                return addressSetPropertyMapDB;
            }
        }
        finally {
            lock.release();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AddressSetPropertyMapDB createPropertyMap(ProgramDB program, String mapName, ErrorHandler errHandler, AddressMap addrMap, Lock lock) throws DuplicateNameException {
        lock.acquire();
        try {
            DBHandle dbh = program.getDBHandle();
            String tableName = TABLE_PREFIX + mapName;
            if (dbh.getTable(tableName) != null) {
                throw new DuplicateNameException("Address Set Property Map named " + mapName + " already exists.");
            }
            AddressSetPropertyMapDB addressSetPropertyMapDB = new AddressSetPropertyMapDB(program, mapName, (ErrorHandler)program, addrMap, lock);
            return addressSetPropertyMapDB;
        }
        finally {
            lock.release();
        }
    }

    private AddressSetPropertyMapDB(ProgramDB program, String mapName, ErrorHandler errHandler, AddressMap addrMap, Lock lock) {
        this.program = program;
        this.mapName = mapName;
        this.lock = lock;
        this.propertyMap = new AddressRangeMapDB(program.getDBHandle(), program.getAddressMap(), program.getLock(), MY_PREFIX + mapName, errHandler, BooleanField.class, true);
    }

    @Override
    public void add(Address startAddr, Address endAddr) {
        this.checkDeleted();
        this.lock.acquire();
        try {
            this.propertyMap.paintRange(startAddr, endAddr, FIELD);
            this.program.setChanged(168, null, this.mapName);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(AddressSetView addressSet) {
        this.checkDeleted();
        this.lock.acquire();
        try {
            AddressRangeIterator iter = addressSet.getAddressRanges();
            while (iter.hasNext()) {
                AddressRange range = (AddressRange)iter.next();
                this.add(range.getMinAddress(), range.getMaxAddress());
            }
            this.program.setChanged(168, null, this.mapName);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void set(AddressSetView addressSet) {
        this.checkDeleted();
        this.lock.acquire();
        try {
            this.clear();
            this.add(addressSet);
            this.program.setChanged(168, null, this.mapName);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void remove(Address startAddr, Address endAddr) {
        this.checkDeleted();
        this.lock.acquire();
        try {
            this.propertyMap.clearRange(startAddr, endAddr);
            this.program.setChanged(168, null, this.mapName);
        }
        finally {
            this.lock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(AddressSetView addressSet) {
        this.checkDeleted();
        this.lock.acquire();
        try {
            AddressRangeIterator iter = addressSet.getAddressRanges();
            while (iter.hasNext()) {
                AddressRange range = (AddressRange)iter.next();
                this.remove(range.getMinAddress(), range.getMaxAddress());
            }
            this.program.setChanged(168, null, this.mapName);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AddressSet getAddressSet() {
        this.checkDeleted();
        this.lock.acquire();
        try {
            AddressSet addressSet = this.propertyMap.getAddressSet();
            return addressSet;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AddressIterator getAddresses() {
        this.checkDeleted();
        this.lock.acquire();
        try {
            if (this.propertyMap.isEmpty()) {
                EmptyAddressIterator emptyAddressIterator = new EmptyAddressIterator();
                return emptyAddressIterator;
            }
            AddressSet set = this.getAddressSet();
            AddressIterator addressIterator = set.getAddresses(true);
            return addressIterator;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public AddressRangeIterator getAddressRanges() {
        this.checkDeleted();
        this.lock.acquire();
        try {
            AddressRangeIterator addressRangeIterator = this.propertyMap.getAddressRanges();
            return addressRangeIterator;
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public void clear() {
        this.checkDeleted();
        this.lock.acquire();
        try {
            this.propertyMap.dispose();
            this.program.setChanged(168, null, this.mapName);
        }
        finally {
            this.lock.release();
        }
    }

    @Override
    public boolean contains(Address addr) {
        this.checkDeleted();
        this.lock.acquire();
        try {
            boolean bl = this.propertyMap.getValue(addr) != null;
            return bl;
        }
        finally {
            this.lock.release();
        }
    }

    public void delete() {
        this.propertyMap.dispose();
        this.invalid = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAddressRange(Address fromAddr, Address toAddr, long length, TaskMonitor monitor) throws AddressOverflowException, CancelledException {
        this.lock.acquire();
        try {
            Address rangeEnd = fromAddr.addNoWrap(length - 1L);
            AddressSet currentSet = new AddressSet();
            AddressRangeIterator rangeIter = this.propertyMap.getAddressRanges(fromAddr, rangeEnd);
            while (rangeIter.hasNext()) {
                monitor.checkCanceled();
                currentSet.add((AddressRange)rangeIter.next());
            }
            this.propertyMap.clearRange(fromAddr, rangeEnd);
            rangeIter = currentSet.getAddressRanges();
            while (rangeIter.hasNext()) {
                monitor.checkCanceled();
                AddressRange range = (AddressRange)rangeIter.next();
                Address startAddr = range.getMinAddress();
                Address endAddr = range.getMaxAddress();
                long offset = startAddr.subtract(fromAddr);
                startAddr = toAddr.add(offset);
                offset = endAddr.subtract(fromAddr);
                endAddr = toAddr.add(offset);
                this.propertyMap.paintRange(startAddr, endAddr, FIELD);
            }
        }
        finally {
            this.lock.release();
        }
    }

    private void checkDeleted() {
        if (this.invalid) {
            throw new ConcurrentModificationException("AddressSetPropertyMap has been deleted.");
        }
    }
}

