/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import generic.util.UnsignedDataUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOutOfBoundsException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.GenericAddress;
import ghidra.program.model.address.OverlayAddressSpace;
import ghidra.util.MathUtilities;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.AssertException;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractAddressSpace
implements AddressSpace {
    protected String name;
    protected int size;
    protected int unitSize = 1;
    protected int type;
    protected long spaceSize = 0L;
    protected boolean signed;
    protected long minOffset;
    protected long maxOffset;
    protected Address minAddress;
    protected Address maxAddress;
    private int hashcode;
    protected int spaceID;
    private boolean showSpaceName;
    private boolean hasMemoryMappedRegisters = false;
    private long wordAddressMask = -1L;

    protected AbstractAddressSpace(String name, int size, int unitSize, int type, int unique) {
        boolean bl = this.showSpaceName = type != 1 || this.isOverlaySpace();
        if (type == 15) {
            this.name = name;
            this.type = 15;
            this.minAddress = this.maxAddress = this.getUncheckedAddress(0L);
            this.spaceID = -1;
            this.hashcode = name.hashCode() + type;
            return;
        }
        if (unique < 0 || unique > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Unique space id must be between 0 and 32767 inclusive");
        }
        this.name = name;
        this.size = size;
        this.unitSize = unitSize;
        this.type = type;
        if (this.bitsConsumedByUnitSize(unitSize) + size > 64) {
            throw new IllegalArgumentException("Unsupport address space size (2^size * wordsize > 2^64)");
        }
        if (size != 64) {
            this.spaceSize = (long)unitSize << size;
            this.wordAddressMask = (1L << size) - 1L;
        }
        boolean bl2 = this.signed = type == 0 || type == 5;
        if (this.signed) {
            this.maxOffset = this.spaceSize - 1L >>> 1;
            this.minOffset = -this.maxOffset - 1L;
        } else {
            this.maxOffset = this.spaceSize - 1L;
            this.minOffset = 0L;
        }
        this.maxAddress = this.getUncheckedAddress(this.maxOffset);
        this.minAddress = this.getUncheckedAddress(this.minOffset);
        int logsize = 7;
        switch (size) {
            case 8: {
                logsize = 0;
                break;
            }
            case 16: {
                logsize = 1;
                break;
            }
            case 32: {
                logsize = 2;
                break;
            }
            case 64: {
                logsize = 3;
            }
        }
        this.spaceID = unique << 7 | logsize << 4 | type;
        this.hashcode = name.hashCode() + type;
    }

    private int bitsConsumedByUnitSize(int unitSize) {
        if (unitSize < 1 || unitSize > 8) {
            throw new IllegalArgumentException("Unsupported unit size: " + unitSize);
        }
        int cnt = 0;
        for (int test = unitSize - 1; test != 0; test >>= 1) {
            ++cnt;
        }
        return cnt;
    }

    @Override
    public boolean hasSignedOffset() {
        return this.signed;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getAddressableUnitSize() {
        return this.unitSize;
    }

    @Override
    public long getAddressableWordOffset(long byteOffset) {
        boolean isNegative = false;
        if (this.signed && byteOffset < 0L) {
            byteOffset = -byteOffset;
            isNegative = true;
        }
        long offset = AbstractAddressSpace.getUnsignedWordOffset(byteOffset, this.unitSize);
        if (isNegative) {
            offset = -offset;
        }
        return offset;
    }

    private static long getUnsignedWordOffset(long byteOffset, int wordSize) {
        switch (wordSize) {
            case 1: {
                return byteOffset;
            }
            case 2: {
                return byteOffset >>> 1;
            }
            case 4: {
                return byteOffset >>> 2;
            }
            case 8: {
                return byteOffset >>> 3;
            }
        }
        return MathUtilities.unsignedDivide((long)byteOffset, (long)wordSize);
    }

    @Override
    public int getPointerSize() {
        int ptrSize = this.size / 8;
        if (this.size % 8 != 0) {
            ++ptrSize;
        }
        return ptrSize;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getUnique() {
        return this.spaceID >> 7;
    }

    @Override
    public Address getAddress(String addrString) throws AddressFormatException {
        return this.getAddress(addrString, true);
    }

    @Override
    public Address getAddress(String addrString, boolean caseSensitive) throws AddressFormatException {
        String offStr = addrString;
        int colonPos = addrString.lastIndexOf(58);
        if (colonPos >= 0) {
            String addrSpaceStr = addrString.substring(0, colonPos);
            if (!StringUtils.equals((CharSequence)this.name, (CharSequence)addrSpaceStr)) {
                return null;
            }
            offStr = addrString.substring(colonPos + 1);
        }
        try {
            long off = this.parseString(offStr);
            return this.getAddress(off);
        }
        catch (NumberFormatException e) {
            throw new AddressFormatException(addrString + " contains invalid address hex offset");
        }
        catch (AddressOutOfBoundsException e) {
            throw new AddressFormatException(e.getMessage());
        }
    }

    private long parseString(String addr) throws NumberFormatException, AddressFormatException {
        BigInteger bi;
        int ix;
        if (addr.startsWith("0x") || addr.startsWith("0X")) {
            addr = addr.substring(2);
        }
        long mod = 0L;
        if (this.unitSize > 1 && (ix = addr.indexOf(46)) > 0) {
            String unitOffset = addr.substring(ix + 1);
            BigInteger bi2 = new BigInteger(unitOffset, 16);
            mod = bi2.longValue();
            if (bi2.bitLength() > 8 || mod >= (long)this.unitSize) {
                throw new AddressFormatException("invalid address unit offset: ." + unitOffset);
            }
            addr = addr.substring(0, ix);
        }
        if ((bi = new BigInteger(addr, 16)).bitLength() > 64) {
            throw new AddressFormatException("unsupported address offset: " + addr);
        }
        return (long)this.unitSize * bi.longValue() + mod;
    }

    @Override
    public Address getAddress(long offset, boolean isAddressableWordOffset) throws AddressOutOfBoundsException {
        long byteOffset = isAddressableWordOffset ? offset * (long)this.unitSize : offset;
        return this.getAddress(byteOffset);
    }

    @Override
    public Address getTruncatedAddress(long offset, boolean isAddressableWordOffset) {
        long truncatedOffset = isAddressableWordOffset ? this.truncateAddressableWordOffset(offset) : this.truncateOffset(offset);
        try {
            return this.getAddress(truncatedOffset, isAddressableWordOffset);
        }
        catch (AddressOutOfBoundsException e) {
            throw new AssertException((Throwable)e);
        }
    }

    @Override
    public long subtract(Address addr1, Address addr2) {
        AddressSpace space2;
        AddressSpace space1 = addr1.getAddressSpace();
        if (!space1.equals(space2 = addr2.getAddressSpace())) {
            int base2;
            int base1 = space1.isOverlaySpace() ? ((OverlayAddressSpace)space1).getBaseSpaceID() : space1.getSpaceID();
            int n = base2 = space2.isOverlaySpace() ? ((OverlayAddressSpace)space2).getBaseSpaceID() : space2.getSpaceID();
            if (base1 != base2) {
                throw new IllegalArgumentException("Address are in different spaces " + addr1.getAddressSpace().getName() + " != " + addr2.getAddressSpace().getName());
            }
        }
        return addr1.getOffset() - addr2.getOffset();
    }

    @Override
    public Address subtractWrap(Address addr, long displacement) {
        this.testAddressSpace(addr);
        return this.getUncheckedAddress(this.truncateOffset(addr.getOffset() - displacement));
    }

    @Override
    public Address subtractWrapSpace(Address addr, long displacement) {
        return this.subtractWrap(addr, displacement);
    }

    @Override
    public Address subtractNoWrap(Address addr, long displacement) throws AddressOverflowException {
        if (displacement < 0L) {
            if (displacement == Long.MIN_VALUE) {
                throw new AddressOverflowException("Address Overflow in subtract: " + addr + " - 0x" + Long.toHexString(displacement));
            }
            return this.addNoWrap(addr, -displacement);
        }
        this.testAddressSpace(addr);
        if (displacement > this.spaceSize && this.spaceSize != 0L) {
            throw new AddressOverflowException("Address Overflow in subtract: " + addr + " - 0x" + Long.toHexString(displacement));
        }
        long addrOff = addr.getOffset();
        long maxOff = this.maxAddress.getOffset();
        long minOff = this.minAddress.getOffset();
        long result = addrOff - displacement;
        if (maxOff < 0L) {
            if (addrOff >= 0L && result < 0L) {
                throw new AddressOverflowException("Address Overflow in subtract: " + addr + " - 0x" + Long.toHexString(displacement));
            }
            if ((addrOff < 0L && result < 0L || addrOff >= 0L && result >= 0L) && result > addrOff) {
                throw new AddressOverflowException("Address Overflow in subtract: " + addr + " - 0x" + Long.toHexString(displacement));
            }
        } else if (result > addrOff || result < minOff) {
            throw new AddressOverflowException("Address Overflow in subtract: " + addr + " - 0x" + Long.toHexString(displacement));
        }
        return this.getUncheckedAddress(result);
    }

    @Override
    public Address subtract(Address addr, long displacement) {
        try {
            return this.subtractNoWrap(addr, displacement);
        }
        catch (AddressOverflowException e) {
            throw new AddressOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public Address addWrap(Address addr, long displacement) {
        this.testAddressSpace(addr);
        return this.getUncheckedAddress(this.truncateOffset(addr.getOffset() + displacement));
    }

    @Override
    public Address addWrapSpace(Address addr, long displacement) {
        return this.addWrap(addr, displacement);
    }

    @Override
    public Address addNoWrap(Address addr, long displacement) throws AddressOverflowException {
        if (displacement == 0L) {
            return addr;
        }
        if (displacement < 0L) {
            return this.subtractNoWrap(addr, -displacement);
        }
        this.testAddressSpace(addr);
        if (displacement > this.spaceSize && this.spaceSize != 0L) {
            throw new AddressOverflowException("Address Overflow in add: " + addr + " + 0x" + Long.toHexString(displacement));
        }
        long addrOff = addr.getOffset();
        long maxOff = this.maxAddress.getOffset();
        long result = addrOff + displacement;
        if (maxOff < 0L) {
            if (addrOff < 0L && result >= 0L) {
                throw new AddressOverflowException("Address Overflow in add: " + addr + " + 0x" + Long.toHexString(displacement));
            }
            if ((addrOff < 0L && result < 0L || addrOff >= 0L && result >= 0L) && result < addrOff) {
                throw new AddressOverflowException("Address Overflow in add: " + addr + " + 0x" + Long.toHexString(displacement));
            }
        } else if (result < addrOff || result > maxOff) {
            throw new AddressOverflowException("Address Overflow in add: " + addr + " + 0x" + Long.toHexString(displacement));
        }
        return this.getUncheckedAddress(result);
    }

    @Override
    public Address addNoWrap(GenericAddress addr, BigInteger displacement) throws AddressOverflowException {
        if (displacement.equals(BigInteger.ZERO)) {
            return addr;
        }
        this.testAddressSpace(addr);
        BigInteger addrOff = addr.getOffsetAsBigInteger();
        BigInteger maxOff = this.maxAddress.getOffsetAsBigInteger();
        BigInteger minOff = this.minAddress.getOffsetAsBigInteger();
        BigInteger newOffset = addrOff.add(displacement);
        if (newOffset.compareTo(minOff) < 0 || newOffset.compareTo(maxOff) > 0) {
            throw new AddressOverflowException("Address Overflow in add: " + addr + " + " + displacement);
        }
        long resultOffset = NumericUtilities.bigIntegerToUnsignedLong((BigInteger)newOffset);
        return this.getUncheckedAddress(resultOffset);
    }

    @Override
    public Address add(Address addr, long displacement) throws AddressOutOfBoundsException {
        try {
            return this.addNoWrap(addr, displacement);
        }
        catch (AddressOverflowException e) {
            throw new AddressOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public boolean isValidRange(long byteOffset, long length) {
        Address start;
        try {
            start = this.getAddress(byteOffset);
        }
        catch (Exception e1) {
            return false;
        }
        if (length == 0L) {
            return false;
        }
        try {
            this.addNoWrap(start, length - 1L);
        }
        catch (AddressOverflowException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean isSuccessor(Address addr1, Address addr2) {
        if (!addr1.getAddressSpace().equals(addr2.getAddressSpace())) {
            return false;
        }
        if (this.maxAddress.getOffset() == addr1.getOffset()) {
            return false;
        }
        return addr1.getOffset() == addr2.getOffset() - 1L;
    }

    @Override
    public Address getMaxAddress() {
        return this.maxAddress;
    }

    @Override
    public Address getMinAddress() {
        return this.minAddress;
    }

    private int compareAsOverlaySpace(AddressSpace overlaySpace) {
        int baseCompare = ((OverlayAddressSpace)this).getBaseSpaceID() - ((OverlayAddressSpace)overlaySpace).getBaseSpaceID();
        if (baseCompare == 0) {
            long otherMinOffset = overlaySpace.getMinAddress().getOffset();
            if (this.minOffset == otherMinOffset) {
                return this.name.compareTo(overlaySpace.getName());
            }
            return this.minOffset < otherMinOffset ? -1 : 1;
        }
        return baseCompare;
    }

    @Override
    public int compareTo(AddressSpace space) {
        if (space == this) {
            return 0;
        }
        if (this.isOverlaySpace()) {
            if (space.isOverlaySpace()) {
                return this.compareAsOverlaySpace(space);
            }
            return 1;
        }
        if (space.isOverlaySpace()) {
            return -1;
        }
        if (this.hashcode == space.hashCode() && this.type == space.getType() && this.name.equals(space.getName()) && this.getClass().equals(space.getClass())) {
            return 0;
        }
        int c = this.getSpaceID() - space.getSpaceID();
        if (c == 0) {
            c = this.getClass().getName().compareTo(space.getClass().getName());
        }
        return c;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        if (this.hashcode != obj.hashCode()) {
            return false;
        }
        AddressSpace s = (AddressSpace)obj;
        return this.type == s.getType() && this.name.equals(s.getName()) && this.size == s.getSize();
    }

    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public int getSpaceID() {
        return this.spaceID;
    }

    protected void testAddressSpace(Address addr) {
        if (!this.equals(addr.getAddressSpace())) {
            throw new IllegalArgumentException("Address space for " + addr + " (" + addr.getAddressSpace().getName() + ") does not match " + this.name);
        }
    }

    public String toString() {
        return this.name + ":";
    }

    @Override
    public boolean showSpaceName() {
        return this.showSpaceName;
    }

    protected abstract Address getUncheckedAddress(long var1);

    @Override
    public Address getOverlayAddress(Address addr) {
        return addr;
    }

    @Override
    public long makeValidOffset(long offset) throws AddressOutOfBoundsException {
        if (offset >= this.minOffset && offset <= this.maxOffset || this.spaceSize == 0L) {
            return offset;
        }
        if (this.signed) {
            if (offset > this.maxOffset && offset < this.spaceSize) {
                return offset - this.spaceSize;
            }
        } else if (offset < 0L && offset >= -this.maxOffset - 1L) {
            return offset + this.spaceSize;
        }
        String max = Long.toHexString(this.maxOffset);
        String min = Long.toHexString(this.minOffset);
        throw new AddressOutOfBoundsException("Offset must be between 0x" + min + " and 0x" + max + ", got 0x" + Long.toHexString(offset) + " instead!");
    }

    private boolean isValidOffset(long offset) {
        if (this.signed) {
            return offset >= this.minOffset && offset <= this.maxOffset;
        }
        return UnsignedDataUtils.unsignedGreaterThanOrEqual((long)offset, (long)this.minOffset) && UnsignedDataUtils.unsignedLessThanOrEqual((long)offset, (long)this.maxOffset);
    }

    @Override
    public long truncateOffset(long offset) {
        if (offset >= this.minOffset && offset <= this.maxOffset || this.spaceSize == 0L) {
            return offset;
        }
        if (this.signed) {
            if ((offset = (offset + this.maxOffset + 1L) % this.spaceSize) < 0L) {
                offset += this.spaceSize;
            }
            return offset - this.maxOffset - 1L;
        }
        if ((offset %= this.spaceSize) < 0L) {
            offset += this.spaceSize;
        }
        return offset;
    }

    @Override
    public long truncateAddressableWordOffset(long wordOffset) {
        return wordOffset & this.wordAddressMask;
    }

    @Override
    public boolean isMemorySpace() {
        return this.type == 1 || this.type == 2 || this.type == 7;
    }

    @Override
    public boolean isLoadedMemorySpace() {
        return this.type == 1 || this.type == 2;
    }

    @Override
    public boolean isNonLoadedMemorySpace() {
        return this.type == 7;
    }

    @Override
    public boolean isHashSpace() {
        return this == HASH_SPACE;
    }

    @Override
    public boolean isRegisterSpace() {
        return this.type == 4;
    }

    @Override
    public boolean isStackSpace() {
        return this.type == 5;
    }

    @Override
    public boolean isUniqueSpace() {
        return this.type == 3;
    }

    @Override
    public boolean isConstantSpace() {
        return this.type == 0;
    }

    @Override
    public boolean isVariableSpace() {
        return this.type == 11;
    }

    @Override
    public boolean isExternalSpace() {
        return this.type == 10;
    }

    @Override
    public boolean isOverlaySpace() {
        return false;
    }

    public void setShowSpaceName(boolean b) {
        this.showSpaceName = b;
    }

    @Override
    public boolean hasMappedRegisters() {
        return this.hasMemoryMappedRegisters;
    }

    public void setHasMappedRegisters(boolean hasRegisters) {
        this.hasMemoryMappedRegisters = hasRegisters;
    }

    @Override
    public AddressSpace getPhysicalSpace() {
        return this;
    }
}

