/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.address;

import ghidra.program.model.address.AbstractAddressSpace;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.address.GenericAddress;

public class OverlayAddressSpace
extends AbstractAddressSpace {
    public static final String OV_SEPARATER = ":";
    private AddressSpace originalSpace;
    private long databaseKey;

    public OverlayAddressSpace(String name, AddressSpace originalSpace, int unique, long minOffset, long maxOffset) {
        super(name, originalSpace.getSize(), originalSpace.getAddressableUnitSize(), originalSpace.getType(), unique);
        this.originalSpace = originalSpace;
        this.setShowSpaceName(true);
        this.minOffset = minOffset;
        this.maxOffset = maxOffset;
        this.minAddress = new GenericAddress(this, minOffset);
        this.maxAddress = new GenericAddress(this, maxOffset);
    }

    @Override
    public Address getAddress(String addrString) throws AddressFormatException {
        String middleName;
        int lastColonPos;
        int firstColonPos = ((String)(addrString = ((String)addrString).replaceAll("::", OV_SEPARATER))).indexOf(OV_SEPARATER);
        if (firstColonPos != (lastColonPos = ((String)addrString).lastIndexOf(OV_SEPARATER)) && (middleName = ((String)addrString).substring(firstColonPos + 1, lastColonPos)).equals(this.originalSpace.getName())) {
            addrString = ((String)addrString).substring(0, firstColonPos) + ((String)addrString).substring(lastColonPos);
        }
        return super.getAddress((String)addrString);
    }

    @Override
    public long subtract(Address addr1, Address addr2) {
        AddressSpace space1 = addr1.getAddressSpace();
        AddressSpace space2 = addr2.getAddressSpace();
        if (space1.equals(this)) {
            space1 = this.originalSpace;
        }
        if (space2.equals(this)) {
            space2 = this.originalSpace;
        }
        if (!space1.equals(space2)) {
            throw new IllegalArgumentException("Address are in different spaces " + addr1.getAddressSpace().getName() + " != " + addr2.getAddressSpace().getName());
        }
        return addr1.getOffset() - addr2.getOffset();
    }

    @Override
    public boolean isOverlaySpace() {
        return this.originalSpace != null;
    }

    public AddressSpace getOverlayedSpace() {
        return this.originalSpace;
    }

    @Override
    public AddressSpace getPhysicalSpace() {
        return this.originalSpace.getPhysicalSpace();
    }

    @Override
    public boolean hasMappedRegisters() {
        return this.originalSpace.hasMappedRegisters();
    }

    public long getMinOffset() {
        return this.minOffset;
    }

    public long getMaxOffset() {
        return this.maxOffset;
    }

    public boolean contains(long offset) {
        return offset >= this.minOffset && offset <= this.maxOffset;
    }

    @Override
    public Address getAddressInThisSpaceOnly(long offset) {
        return new GenericAddress(offset, this);
    }

    @Override
    public Address getAddress(long offset) {
        if (this.contains(offset)) {
            return new GenericAddress(this, offset);
        }
        return this.originalSpace.getAddress(offset);
    }

    @Override
    protected Address getUncheckedAddress(long offset) {
        return new GenericAddress(offset, this);
    }

    @Override
    public Address getOverlayAddress(Address addr) {
        if (this.getOverlayedSpace().equals(addr.getAddressSpace()) && this.contains(addr.getOffset())) {
            return new GenericAddress(this, addr.getOffset());
        }
        return addr;
    }

    public Address translateAddress(Address addr) {
        return this.translateAddress(addr, false);
    }

    public Address translateAddress(Address addr, boolean forceTranslation) {
        if (addr == null) {
            return null;
        }
        if (!forceTranslation && this.contains(addr.getOffset())) {
            return addr;
        }
        return new GenericAddress(this.originalSpace, addr.getOffset());
    }

    public int getBaseSpaceID() {
        return this.originalSpace.getSpaceID();
    }

    @Override
    public String toString() {
        return super.toString() + OV_SEPARATER;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public void setDatabaseKey(long key) {
        this.databaseKey = key;
    }

    public long getDatabaseKey() {
        return this.databaseKey;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OverlayAddressSpace)) {
            return false;
        }
        OverlayAddressSpace s = (OverlayAddressSpace)obj;
        return this.originalSpace.equals(s.originalSpace) && this.name.equals(s.name) && this.minOffset == s.minOffset && this.maxOffset == s.maxOffset;
    }
}

