/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.Array;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.BitFieldPacking;
import ghidra.program.model.data.BitFieldPackingImpl;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.Language;
import ghidra.util.datastruct.IntIntHashtable;
import ghidra.util.exception.NoValueException;
import java.util.Arrays;

public class DataOrganizationImpl
implements DataOrganization {
    private int absoluteMaxAlignment = 0;
    private int machineAlignment = 8;
    private int defaultAlignment = 1;
    private int defaultPointerAlignment = 4;
    private int pointerShift = 0;
    private int pointerSize = 4;
    private int charSize = 1;
    private int wideCharSize = 2;
    private int shortSize = 2;
    private int integerSize = 4;
    private int longSize = 4;
    private int longLongSize = 8;
    private int floatSize = 4;
    private int doubleSize = 8;
    private int longDoubleSize = 8;
    private boolean bigEndian = false;
    private boolean isSignedChar = true;
    private BitFieldPacking bitFieldPacking = new BitFieldPackingImpl();
    private final IntIntHashtable sizeAlignmentMap = new IntIntHashtable();

    public static DataOrganization getDefaultOrganization() {
        return DataOrganizationImpl.getDefaultOrganization(null);
    }

    public static DataOrganizationImpl getDefaultOrganization(Language language) {
        DataOrganizationImpl dataOrganization = new DataOrganizationImpl();
        dataOrganization.setSizeAlignment(1, 1);
        dataOrganization.setSizeAlignment(2, 2);
        dataOrganization.setSizeAlignment(4, 4);
        dataOrganization.setSizeAlignment(8, 4);
        if (language != null) {
            dataOrganization.setPointerSize(language.getDefaultSpace().getPointerSize());
            dataOrganization.setBigEndian(language.isBigEndian());
        }
        return dataOrganization;
    }

    private DataOrganizationImpl() {
    }

    @Override
    public boolean isBigEndian() {
        return this.bigEndian;
    }

    @Override
    public int getPointerSize() {
        return this.pointerSize;
    }

    @Override
    public int getPointerShift() {
        return this.pointerShift;
    }

    @Override
    public boolean isSignedChar() {
        return this.isSignedChar;
    }

    @Override
    public int getCharSize() {
        return this.charSize;
    }

    @Override
    public int getWideCharSize() {
        return this.wideCharSize;
    }

    @Override
    public int getShortSize() {
        return this.shortSize;
    }

    @Override
    public int getIntegerSize() {
        return this.integerSize;
    }

    @Override
    public int getLongSize() {
        return this.longSize;
    }

    @Override
    public int getLongLongSize() {
        return this.longLongSize;
    }

    @Override
    public int getFloatSize() {
        return this.floatSize;
    }

    @Override
    public int getDoubleSize() {
        return this.doubleSize;
    }

    @Override
    public int getLongDoubleSize() {
        return this.longDoubleSize;
    }

    @Override
    public BitFieldPacking getBitFieldPacking() {
        return this.bitFieldPacking;
    }

    public void setBigEndian(boolean bigEndian) {
        this.bigEndian = bigEndian;
    }

    public void setPointerSize(int pointerSize) {
        this.pointerSize = pointerSize;
    }

    public void setPointerShift(int pointerShift) {
        this.pointerShift = pointerShift;
    }

    public void setCharIsSigned(boolean signed) {
        this.isSignedChar = signed;
    }

    public void setCharSize(int charSize) {
        this.charSize = charSize;
    }

    public void setWideCharSize(int wideCharSize) {
        this.wideCharSize = wideCharSize;
    }

    public void setShortSize(int shortSize) {
        this.shortSize = shortSize;
        if (this.integerSize < shortSize) {
            this.setIntegerSize(shortSize);
        }
    }

    public void setIntegerSize(int integerSize) {
        this.integerSize = integerSize;
        if (this.longSize < integerSize) {
            this.setLongSize(integerSize);
        }
        if (this.shortSize > integerSize) {
            this.setShortSize(integerSize);
        }
    }

    public void setLongSize(int longSize) {
        this.longSize = longSize;
        if (this.longLongSize < longSize) {
            this.setLongLongSize(longSize);
        }
        if (this.integerSize > longSize) {
            this.setIntegerSize(longSize);
        }
    }

    public void setLongLongSize(int longLongSize) {
        this.longLongSize = longLongSize;
        if (this.longSize > longLongSize) {
            this.setLongSize(longLongSize);
        }
    }

    public void setFloatSize(int floatSize) {
        this.floatSize = floatSize;
        if (this.doubleSize < floatSize) {
            this.setDoubleSize(floatSize);
        }
    }

    public void setDoubleSize(int doubleSize) {
        this.doubleSize = doubleSize;
        if (this.longDoubleSize < doubleSize) {
            this.setLongDoubleSize(doubleSize);
        }
        if (this.floatSize > doubleSize) {
            this.setFloatSize(doubleSize);
        }
    }

    public void setLongDoubleSize(int longDoubleSize) {
        this.longDoubleSize = longDoubleSize;
        if (this.doubleSize > longDoubleSize) {
            this.setDoubleSize(longDoubleSize);
        }
    }

    @Override
    public int getAbsoluteMaxAlignment() {
        return this.absoluteMaxAlignment;
    }

    @Override
    public int getMachineAlignment() {
        return this.machineAlignment;
    }

    @Override
    public int getDefaultAlignment() {
        return this.defaultAlignment;
    }

    @Override
    public int getDefaultPointerAlignment() {
        return this.defaultPointerAlignment;
    }

    public void setAbsoluteMaxAlignment(int absoluteMaxAlignment) {
        this.absoluteMaxAlignment = absoluteMaxAlignment;
    }

    public void setMachineAlignment(int machineAlignment) {
        this.machineAlignment = machineAlignment;
    }

    public void setDefaultAlignment(int defaultAlignment) {
        this.defaultAlignment = defaultAlignment;
    }

    public void setDefaultPointerAlignment(int defaultPointerAlignment) {
        this.defaultPointerAlignment = defaultPointerAlignment;
    }

    @Override
    public int getSizeAlignment(int size) throws NoValueException {
        return this.sizeAlignmentMap.get(size);
    }

    public void setSizeAlignment(int size, int alignment) {
        this.sizeAlignmentMap.put(size, alignment);
    }

    public void setBitFieldPacking(BitFieldPacking bitFieldPacking) {
        this.bitFieldPacking = bitFieldPacking;
    }

    @Override
    public void clearSizeAlignmentMap() {
        this.sizeAlignmentMap.removeAll();
    }

    @Override
    public int getSizeAlignmentCount() {
        return this.sizeAlignmentMap.size();
    }

    @Override
    public int[] getSizes() {
        int[] keys = this.sizeAlignmentMap.getKeys();
        Arrays.sort(keys);
        return keys;
    }

    @Override
    public String getIntegerCTypeApproximation(int size, boolean signed) {
        Object ctype = "long long";
        if (size <= 1) {
            ctype = "char";
        } else if (size <= this.getShortSize() && this.getShortSize() != this.getIntegerSize()) {
            ctype = "short";
        } else if (size <= this.getIntegerSize()) {
            ctype = "int";
        } else if (size <= this.getLongSize()) {
            ctype = "long";
        }
        if (!signed) {
            ctype = "unsigned " + (String)ctype;
        }
        return ctype;
    }

    @Override
    public int getAlignment(DataType dataType, int dtSize) {
        if (dataType instanceof Dynamic) {
            return 1;
        }
        if (dataType instanceof TypeDef) {
            return this.getAlignment(((TypeDef)dataType).getBaseDataType(), dtSize);
        }
        if (dataType instanceof Array) {
            DataType elementDt = ((Array)dataType).getDataType();
            int elementLength = ((Array)dataType).getElementLength();
            return this.getAlignment(elementDt, elementLength);
        }
        if (dataType instanceof Pointer && dtSize <= 0) {
            return this.getDefaultPointerAlignment();
        }
        if (dataType instanceof Composite) {
            return ((Composite)dataType).getAlignment();
        }
        if (dataType instanceof BitFieldDataType) {
            BitFieldDataType bitfieldDt = (BitFieldDataType)dataType;
            return this.getAlignment(bitfieldDt.getBaseDataType(), bitfieldDt.getBaseTypeSize());
        }
        if (this.sizeAlignmentMap.contains(dtSize)) {
            try {
                int sizeAlignment = this.sizeAlignmentMap.get(dtSize);
                return this.absoluteMaxAlignment == 0 || sizeAlignment < this.absoluteMaxAlignment ? sizeAlignment : this.absoluteMaxAlignment;
            }
            catch (NoValueException noValueException) {
                // empty catch block
            }
        }
        if (dataType instanceof Pointer) {
            return this.getDefaultPointerAlignment();
        }
        return this.getDefaultAlignment();
    }

    @Override
    public boolean isForcingAlignment(DataType dataType) {
        return this.getForcedAlignment(dataType) > 0;
    }

    @Override
    public int getForcedAlignment(DataType dataType) {
        if (dataType instanceof Dynamic) {
            return 0;
        }
        if (dataType instanceof TypeDef) {
            return this.getForcedAlignment(((TypeDef)dataType).getBaseDataType());
        }
        if (dataType instanceof Array) {
            DataType elementDt = ((Array)dataType).getDataType();
            return this.getForcedAlignment(elementDt);
        }
        if (dataType instanceof Pointer) {
            return 0;
        }
        if (dataType instanceof Composite) {
            int forcedLCM = 0;
            Composite composite = (Composite)dataType;
            if (!composite.isInternallyAligned()) {
                return 0;
            }
            if (!composite.isDefaultAligned()) {
                int minimumAlignment = composite.getMinimumAlignment();
                forcedLCM = minimumAlignment > 0 ? minimumAlignment : 0;
            }
            int componentForcedLCM = 0;
            for (DataTypeComponent dataTypeComponent : composite.getDefinedComponents()) {
                DataType componentDt;
                int forcedAlignment;
                if (dataTypeComponent.isBitFieldComponent() || (forcedAlignment = this.getForcedAlignment(componentDt = dataTypeComponent.getDataType())) <= 0) continue;
                componentForcedLCM = componentForcedLCM > 0 ? DataOrganizationImpl.getLeastCommonMultiple(componentForcedLCM, forcedAlignment) : forcedAlignment;
            }
            if (forcedLCM > 0) {
                if (componentForcedLCM > 0) {
                    return DataOrganizationImpl.getLeastCommonMultiple(forcedLCM, componentForcedLCM);
                }
                return forcedLCM;
            }
            return componentForcedLCM;
        }
        return 0;
    }

    @Override
    public int getAlignmentOffset(int minimumOffset, DataType dataType, int dtSize) {
        int alignment = this.getAlignment(dataType, dtSize);
        return DataOrganizationImpl.getOffset(alignment, minimumOffset);
    }

    public static int getOffset(int alignment, int minimumOffset) {
        return alignment + (minimumOffset - 1 & ~(alignment - 1));
    }

    public static int getPaddingSize(int alignment, int offset) {
        return (alignment - offset % alignment) % alignment;
    }

    public static int getLeastCommonMultiple(int value1, int value2) {
        int gcd = DataOrganizationImpl.getGreatestCommonDenominator(value1, value2);
        return gcd != 0 ? value1 / gcd * value2 : 0;
    }

    public static int getGreatestCommonDenominator(int value1, int value2) {
        return value2 != 0 ? DataOrganizationImpl.getGreatestCommonDenominator(value2, value1 % value2) : value1;
    }
}

