/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.ArchiveType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeManagerChangeListener;
import ghidra.program.model.data.DataTypePath;
import ghidra.program.model.data.InvalidatedListener;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.Structure;
import ghidra.util.InvalidNameException;
import ghidra.util.UniversalID;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public interface DataTypeManager {
    public static final long DEFAULT_DATATYPE_ID = 0L;
    public static final long NULL_DATATYPE_ID = -1L;
    public static final long BAD_DATATYPE_ID = -2L;
    public static final String BUILT_IN_DATA_TYPES_NAME = "BuiltInTypes";
    public static final long LOCAL_ARCHIVE_KEY = 0L;
    public static final long BUILT_IN_ARCHIVE_KEY = 1L;
    public static final UniversalID LOCAL_ARCHIVE_UNIVERSAL_ID = new UniversalID(0L);
    public static final UniversalID BUILT_IN_ARCHIVE_UNIVERSAL_ID = new UniversalID(1L);

    public UniversalID getUniversalID();

    public boolean containsCategory(CategoryPath var1);

    public String getUniqueName(CategoryPath var1, String var2);

    public DataType resolve(DataType var1, DataTypeConflictHandler var2);

    public DataType addDataType(DataType var1, DataTypeConflictHandler var2);

    public void addDataTypes(Collection<DataType> var1, DataTypeConflictHandler var2, TaskMonitor var3) throws CancelledException;

    public Iterator<DataType> getAllDataTypes();

    public void getAllDataTypes(List<DataType> var1);

    public Iterator<Structure> getAllStructures();

    public Iterator<Composite> getAllComposites();

    public void findDataTypes(String var1, List<DataType> var2);

    public void findDataTypes(String var1, List<DataType> var2, boolean var3, TaskMonitor var4);

    public DataType replaceDataType(DataType var1, DataType var2, boolean var3) throws DataTypeDependencyException;

    public DataType getDataType(String var1);

    @Deprecated
    public DataType findDataType(String var1);

    public DataType getDataType(DataTypePath var1);

    public long getResolvedID(DataType var1);

    public long getID(DataType var1);

    public DataType getDataType(long var1);

    public Category getCategory(long var1);

    public Category getCategory(CategoryPath var1);

    public void dataTypeChanged(DataType var1);

    public void addDataTypeManagerListener(DataTypeManagerChangeListener var1);

    public void removeDataTypeManagerListener(DataTypeManagerChangeListener var1);

    public void addInvalidatedListener(InvalidatedListener var1);

    public void removeInvalidatedListener(InvalidatedListener var1);

    public boolean remove(DataType var1, TaskMonitor var2);

    public boolean contains(DataType var1);

    public Category createCategory(CategoryPath var1);

    public DataType getDataType(CategoryPath var1, String var2);

    public String getName();

    public void setName(String var1) throws InvalidNameException;

    public int startTransaction(String var1);

    public boolean isUpdatable();

    public void endTransaction(int var1, boolean var2);

    public void flushEvents();

    public void close();

    public Pointer getPointer(DataType var1);

    public Pointer getPointer(DataType var1, int var2);

    public Category getRootCategory();

    public boolean isFavorite(DataType var1);

    public void setFavorite(DataType var1, boolean var2);

    public List<DataType> getFavorites();

    public int getCategoryCount();

    public int getDataTypeCount(boolean var1);

    public void findEnumValueNames(long var1, Set<String> var3);

    public DataType getDataType(SourceArchive var1, UniversalID var2);

    public DataType findDataTypeForID(UniversalID var1);

    public long getLastChangeTimeForMyManager();

    public SourceArchive getSourceArchive(UniversalID var1);

    public ArchiveType getType();

    public List<DataType> getDataTypes(SourceArchive var1);

    public SourceArchive getLocalSourceArchive();

    public void associateDataTypeWithArchive(DataType var1, SourceArchive var2);

    public void disassociate(DataType var1);

    public boolean updateSourceArchiveName(String var1, String var2);

    public boolean updateSourceArchiveName(UniversalID var1, String var2);

    public DataOrganization getDataOrganization();

    public List<SourceArchive> getSourceArchives();

    public void removeSourceArchive(SourceArchive var1);

    public SourceArchive resolveSourceArchive(SourceArchive var1);

    public Set<DataType> getDataTypesContaining(DataType var1);
}

