/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.MetaDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.data.VoidDataType;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class NoisyStructureBuilder {
    private TreeMap<Long, DataType> offsetToDataTypeMap = new TreeMap();
    private Structure structDT = null;
    private long sizeOfStruct = 0L;

    private void computeMax(long newOff, int length) {
        if (this.sizeOfStruct < newOff + (long)length) {
            this.sizeOfStruct = newOff + (long)length;
        }
    }

    private Map.Entry<Long, DataType> checkForOverlap(long offset, int size) {
        long last;
        Map.Entry<Long, DataType> res = this.offsetToDataTypeMap.floorEntry(offset);
        if (res != null && offset < (last = res.getKey() + (long)res.getValue().getLength())) {
            return res;
        }
        res = this.offsetToDataTypeMap.higherEntry(offset);
        if (res != null) {
            last = offset + (long)size;
            if (res.getKey() < last) {
                return res;
            }
        }
        return null;
    }

    public long getSize() {
        return this.sizeOfStruct;
    }

    public void addDataType(long offset, DataType dt) {
        if (dt == null || dt instanceof VoidDataType) {
            this.computeMax(offset, 1);
            return;
        }
        if (dt instanceof Pointer && ((Pointer)dt).getDataType().equals(this.structDT)) {
            DataTypeManager manager = dt.getDataTypeManager();
            dt = manager.getPointer(DataType.DEFAULT, dt.getLength());
        }
        this.computeMax(offset, dt.getLength());
        Map.Entry<Long, DataType> firstEntry = this.checkForOverlap(offset, dt.getLength());
        if (firstEntry != null) {
            if (firstEntry.getKey() == offset && firstEntry.getValue().getLength() == dt.getLength() ? dt != MetaDataType.getMostSpecificDataType(firstEntry.getValue(), dt) : (firstEntry.getKey() <= offset && offset + (long)dt.getLength() < firstEntry.getKey() + (long)firstEntry.getValue().getLength() ? !(firstEntry.getValue() instanceof Undefined) : dt instanceof Undefined)) {
                return;
            }
            this.offsetToDataTypeMap.subMap(firstEntry.getKey(), offset + (long)dt.getLength()).clear();
        }
        this.offsetToDataTypeMap.put(offset, dt);
    }

    public void addReference(long offset, DataType dt) {
        if (dt != null && dt instanceof Pointer) {
            if ((dt = ((Pointer)dt).getDataType()).equals(this.structDT)) {
                return;
            }
            if (dt instanceof Structure && ((Structure)dt).getNumDefinedComponents() == 0) {
                this.computeMax(offset, 1);
                return;
            }
            this.addDataType(offset, dt);
        } else {
            this.computeMax(offset, 1);
        }
    }

    public void setMinimumSize(long size) {
        if (size > this.sizeOfStruct) {
            this.sizeOfStruct = size;
        }
    }

    public Iterator<Map.Entry<Long, DataType>> iterator() {
        return this.offsetToDataTypeMap.entrySet().iterator();
    }

    public void populateOriginalStructure(Structure dt) {
        DataTypeComponent[] components;
        this.structDT = dt;
        for (DataTypeComponent component : components = this.structDT.getDefinedComponents()) {
            this.offsetToDataTypeMap.put(Long.valueOf(component.getOffset()), component.getDataType());
        }
        this.sizeOfStruct = this.structDT.getLength();
    }
}

