/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.symbol.SymbolUtilities;

public class ParameterDefinitionImpl
implements ParameterDefinition {
    private int ordinal;
    private String name;
    private DataType dataType;
    private String comment;

    public ParameterDefinitionImpl(String name, DataType dataType, String comment) {
        this(name, dataType, comment, -2);
    }

    protected ParameterDefinitionImpl(String name, DataType dataType, String comment, int ordinal) {
        this.dataType = ParameterDefinitionImpl.validateDataType(dataType, null, false);
        this.name = name;
        this.comment = comment;
        this.ordinal = ordinal;
    }

    public static DataType validateDataType(DataType dataType, DataTypeManager dtMgr, boolean isReturn) throws IllegalArgumentException {
        String kind;
        String string = kind = isReturn ? "Return" : "Parameter";
        if (dataType == null) {
            dataType = DataType.DEFAULT;
        } else if (dataType instanceof FunctionDefinition || dataType instanceof TypeDef && ((TypeDef)dataType).getBaseDataType() instanceof FunctionDefinition) {
            dataType = new PointerDataType(dataType, dtMgr);
        } else if (dataType instanceof Dynamic || dataType instanceof FactoryDataType) {
            throw new IllegalArgumentException(kind + " type may not be defined with Dynamic or Factory data-type: " + dataType.getName());
        }
        dataType = dataType.clone(dtMgr != null ? dtMgr : dataType.getDataTypeManager());
        if (!dataType.isDynamicallySized() && dataType.getLength() < 0) {
            throw new IllegalArgumentException(kind + " type must be specified with fixed-length data type: " + dataType.getName());
        }
        DataType baseType = dataType;
        if (baseType instanceof TypedefDataType) {
            baseType = ((TypedefDataType)baseType).getBaseDataType();
        }
        if (baseType instanceof VoidDataType) {
            if (!isReturn) {
                throw new IllegalArgumentException("Parameter type may not specify the void datatype - empty parameter list should be used");
            }
        } else if (!(dataType instanceof Composite) && dataType.getLength() == 0) {
            throw new IllegalArgumentException(kind + " type must be specified with fixed-length data type: " + dataType.getName());
        }
        return dataType;
    }

    @Override
    public final int compareTo(ParameterDefinition p) {
        return this.ordinal - p.getOrdinal();
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public int getLength() {
        return this.dataType.getLength();
    }

    @Override
    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    @Override
    public void setComment(String comment) {
        if (comment != null && comment.endsWith("\n")) {
            comment = comment.substring(0, comment.length() - 1);
        }
        this.comment = comment;
    }

    @Override
    public void setDataType(DataType type) {
        this.dataType = ParameterDefinitionImpl.validateDataType(type, this.dataType.getDataTypeManager(), false);
    }

    @Override
    public void setName(String name) {
        if (SymbolUtilities.isDefaultParameterName(name)) {
            name = null;
        }
        this.name = name;
    }

    @Override
    public boolean isEquivalent(Variable variable) {
        if (variable == null) {
            return false;
        }
        if (!(variable instanceof Parameter)) {
            return false;
        }
        if (this.ordinal != ((Parameter)variable).getOrdinal()) {
            return false;
        }
        return DataTypeUtilities.isSameOrEquivalentDataType(this.dataType, variable.getDataType());
    }

    @Override
    public boolean isEquivalent(ParameterDefinition parm) {
        if (parm == null) {
            return false;
        }
        if (this.ordinal != parm.getOrdinal()) {
            return false;
        }
        return DataTypeUtilities.isSameOrEquivalentDataType(this.dataType, parm.getDataType());
    }

    public String toString() {
        return this.dataType.getName() + " " + this.name;
    }
}

