/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.InvalidDataTypeException;
import java.util.Comparator;

public interface Structure
extends Composite {
    @Override
    public Structure clone(DataTypeManager var1);

    @Override
    public DataTypeComponent getComponent(int var1);

    public DataTypeComponent getComponentAt(int var1);

    public DataTypeComponent getDataTypeAt(int var1);

    public DataTypeComponent insertBitField(int var1, int var2, int var3, DataType var4, int var5, String var6, String var7) throws InvalidDataTypeException, ArrayIndexOutOfBoundsException;

    public DataTypeComponent insertBitFieldAt(int var1, int var2, int var3, DataType var4, int var5, String var6, String var7) throws InvalidDataTypeException;

    public DataTypeComponent insertAtOffset(int var1, DataType var2, int var3) throws IllegalArgumentException;

    public DataTypeComponent insertAtOffset(int var1, DataType var2, int var3, String var4, String var5) throws IllegalArgumentException;

    public void deleteAtOffset(int var1);

    public void deleteAll();

    public void clearComponent(int var1) throws ArrayIndexOutOfBoundsException;

    public DataTypeComponent replace(int var1, DataType var2, int var3) throws ArrayIndexOutOfBoundsException, IllegalArgumentException;

    public DataTypeComponent replace(int var1, DataType var2, int var3, String var4, String var5) throws ArrayIndexOutOfBoundsException, IllegalArgumentException;

    public DataTypeComponent replaceAtOffset(int var1, DataType var2, int var3, String var4, String var5) throws IllegalArgumentException;

    public boolean hasFlexibleArrayComponent();

    public DataTypeComponent getFlexibleArrayComponent();

    public DataTypeComponent setFlexibleArrayComponent(DataType var1, String var2, String var3) throws IllegalArgumentException;

    public void clearFlexibleArrayComponent();

    public void growStructure(int var1);

    public void pack(int var1);

    public static class OrdinalComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Integer) {
                return -this.compare(o2, o1);
            }
            DataTypeComponent dtc = (DataTypeComponent)o1;
            int ordinal = (Integer)o2;
            return dtc.getOrdinal() - ordinal;
        }
    }

    public static class OffsetComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            if (o1 instanceof Integer) {
                return -this.compare(o2, o1);
            }
            DataTypeComponent dtc = (DataTypeComponent)o1;
            int offset = (Integer)o2;
            if (offset < dtc.getOffset()) {
                return 1;
            }
            if (offset > dtc.getEndOffset()) {
                return -1;
            }
            return 0;
        }
    }

    public static class BitOffsetComparator
    implements Comparator<Object> {
        private boolean bigEndian;

        public BitOffsetComparator(boolean bigEndian) {
            this.bigEndian = bigEndian;
        }

        @Override
        public int compare(Object o1, Object o2) {
            int endBit;
            int startBit;
            if (o1 instanceof Integer) {
                return -this.compare(o2, o1);
            }
            DataTypeComponent dtc = (DataTypeComponent)o1;
            int bitOffset = (Integer)o2;
            if (dtc.isBitFieldComponent()) {
                BitFieldDataType bitfield = (BitFieldDataType)dtc.getDataType();
                startBit = BitOffsetComparator.getNormalizedBitfieldOffset(dtc.getOffset(), dtc.getLength(), bitfield.getBitSize(), bitfield.getBitOffset(), this.bigEndian);
                endBit = startBit + bitfield.getBitSize() - 1;
            } else {
                startBit = 8 * dtc.getOffset();
                endBit = startBit + 8 * dtc.getLength() - 1;
            }
            if (bitOffset < startBit) {
                return 1;
            }
            if (bitOffset > endBit) {
                return -1;
            }
            return 0;
        }

        public static int getNormalizedBitfieldOffset(int byteOffset, int storageSize, int effectiveBitSize, int bitOffset, boolean bigEndian) {
            int offset = 8 * byteOffset;
            if (effectiveBitSize == 0) {
                effectiveBitSize = 1;
                bitOffset = bigEndian ? (bitOffset |= 7) : (bitOffset &= 0xFFFFFFF8);
            }
            offset = bigEndian ? (offset += 8 * storageSize - effectiveBitSize - bitOffset) : (offset += bitOffset);
            return offset;
        }
    }
}

