/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DynamicDataType;
import ghidra.program.model.data.ReadOnlyDataTypeComponent;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.mem.MemoryBufferImpl;
import ghidra.util.Msg;
import java.util.ArrayList;
import java.util.List;

public abstract class StructuredDynamicDataType
extends DynamicDataType {
    protected String description;
    protected List<DataType> components = new ArrayList<DataType>();
    protected List<String> componentNames = new ArrayList<String>();
    protected List<String> componentDescs = new ArrayList<String>();

    public StructuredDynamicDataType(String name, String description, DataTypeManager dtm) {
        super(name, dtm);
        this.description = description;
    }

    public void add(DataType data, String componentName, String componentDescription) {
        this.components.add(this.components.size(), data);
        this.componentNames.add(this.componentNames.size(), componentName);
        this.componentDescs.add(this.componentDescs.size(), componentDescription);
    }

    public void setComponents(List<DataType> components, List<String> componentNames, List<String> componentDescs) {
        this.components = new ArrayList<DataType>(components);
        this.componentNames = new ArrayList<String>(componentNames);
        this.componentDescs = new ArrayList<String>(componentDescs);
    }

    @Override
    protected DataTypeComponent[] getAllComponents(MemBuffer buf) {
        Memory memory = buf.getMemory();
        DataTypeComponent[] comps = new DataTypeComponent[this.components.size()];
        int offset = 0;
        MemoryBufferImpl newBuf = new MemoryBufferImpl(memory, buf.getAddress());
        try {
            for (int i = 0; i < this.components.size(); ++i) {
                DataTypeInstance dti = DataTypeInstance.getDataTypeInstance(this.components.get(i), newBuf);
                if (dti == null) {
                    Msg.error((Object)this, (Object)("Invalid data at " + newBuf.getAddress()));
                    return null;
                }
                int len = dti.getLength();
                comps[i] = new ReadOnlyDataTypeComponent(dti.getDataType(), this, len, i, offset, this.componentNames.get(i) + "_" + newBuf.getAddress(), this.componentDescs.get(i));
                offset += len;
                newBuf.advance(len);
            }
        }
        catch (AddressOverflowException e) {
            Msg.error((Object)this, (Object)("Invalid data at " + newBuf.getAddress()));
            return null;
        }
        return comps;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return null;
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }
}

