/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.database.data.DataTypeUtilities;
import ghidra.program.model.data.BitFieldDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.GenericDataType;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.UniversalID;

public class TypedefDataType
extends GenericDataType
implements TypeDef {
    private static final long serialVersionUID = 1L;
    private DataType dataType;
    private boolean deleted = false;

    public TypedefDataType(String name, DataType dt) {
        this(CategoryPath.ROOT, name, dt, null);
    }

    public TypedefDataType(CategoryPath path, String name, DataType dt) {
        this(path, name, dt, null);
    }

    public TypedefDataType(CategoryPath path, String name, DataType dt, DataTypeManager dtm) {
        super(path, name, dtm);
        this.validate(dt);
        this.dataType = dt.clone(dtm);
        dt.addParent(this);
    }

    public TypedefDataType(CategoryPath path, String name, DataType dt, UniversalID universalID, SourceArchive sourceArchive, long lastChangeTime, long lastChangeTimeInSourceArchive, DataTypeManager dtm) {
        super(path, name, universalID, sourceArchive, lastChangeTime, lastChangeTimeInSourceArchive, dtm);
        this.validate(dt);
        this.dataType = dt.clone(dtm);
        dt.addParent(this);
    }

    private void validate(DataType dt) {
        if (dt instanceof BitFieldDataType) {
            throw new IllegalArgumentException("TypeDef data-type may not be a bitfield: " + dt.getName());
        }
        if (dt instanceof FactoryDataType) {
            throw new IllegalArgumentException("TypeDef data-type may not be a Factory data-type: " + dt.getName());
        }
        if (dt instanceof Dynamic) {
            throw new IllegalArgumentException("TypeDef data-type may not be a Dynamic data-type: " + dt.getName());
        }
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.getName();
    }

    @Override
    public boolean isNotYetDefined() {
        return this.dataType.isNotYetDefined();
    }

    @Override
    public boolean isDynamicallySized() {
        return this.dataType.isDynamicallySized();
    }

    @Override
    public boolean isEquivalent(DataType obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof TypeDef) {
            TypeDef td = (TypeDef)obj;
            if (!DataTypeUtilities.equalsIgnoreConflict(this.name, td.getName())) {
                return false;
            }
            return DataTypeUtilities.isSameOrEquivalentDataType(this.getDataType(), td.getDataType());
        }
        return false;
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public String getDescription() {
        return this.dataType.getDescription();
    }

    @Override
    public int getLength() {
        return this.dataType.getLength();
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return this.dataType.getRepresentation(buf, settings, length);
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        return this.dataType.getValue(buf, settings, length);
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return this.dataType.getValueClass(settings);
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (this.getDataTypeManager() == dtm) {
            return this;
        }
        return new TypedefDataType(this.categoryPath, this.name, this.dataType, this.getUniversalID(), this.getSourceArchive(), this.getLastChangeTime(), this.getLastChangeTimeInSourceArchive(), dtm);
    }

    @Override
    public DataType copy(DataTypeManager dtm) {
        return new TypedefDataType(this.categoryPath, this.name, this.dataType, dtm);
    }

    @Override
    public void dataTypeSizeChanged(DataType dt) {
        if (dt == this.dataType) {
            this.notifySizeChanged();
        }
    }

    @Override
    public DataType getBaseDataType() {
        if (this.dataType instanceof TypeDef) {
            return ((TypeDef)this.dataType).getBaseDataType();
        }
        return this.dataType;
    }

    @Override
    public void dataTypeDeleted(DataType dt) {
        if (this.dataType == dt) {
            this.notifyDeleted();
            this.deleted = true;
        }
    }

    @Override
    public boolean isDeleted() {
        return this.deleted;
    }

    @Override
    public SettingsDefinition[] getSettingsDefinitions() {
        return this.dataType.getSettingsDefinitions();
    }

    @Override
    public void dataTypeReplaced(DataType oldDt, DataType newDt) {
        this.validate(newDt);
        if (oldDt == this.dataType) {
            this.dataType = newDt;
            oldDt.removeParent(this);
            newDt.addParent(this);
            if (oldDt.getLength() != newDt.getLength()) {
                this.notifySizeChanged();
            }
        }
    }

    @Override
    public void dataTypeNameChanged(DataType dt, String oldName) {
    }

    @Override
    public boolean dependsOn(DataType dt) {
        DataType myDt = this.getDataType();
        return myDt == dt || myDt.dependsOn(dt);
    }

    @Override
    public String toString() {
        return "typedef " + this.getName() + " " + this.dataType.getName();
    }
}

