/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.SignedWordDataType;

public class WordDataType
extends AbstractIntegerDataType {
    private static final long serialVersionUID = 1L;
    public static final WordDataType dataType = new WordDataType();

    public WordDataType() {
        this(null);
    }

    public WordDataType(DataTypeManager dtm) {
        super("word", false, dtm);
    }

    @Override
    public String getDescription() {
        return "Unsigned Word (dw, 2-bytes)";
    }

    @Override
    public int getLength() {
        return 2;
    }

    @Override
    public String getAssemblyMnemonic() {
        return "dw";
    }

    @Override
    public SignedWordDataType getOppositeSignednessDataType() {
        return SignedWordDataType.dataType.clone(this.getDataTypeManager());
    }

    @Override
    public WordDataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new WordDataType(dtm);
    }
}

