/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.lang.UnknownInstructionException;
import ghidra.program.model.pcode.BlockGraph;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;

public class BlockCondition
extends BlockGraph {
    private int opcode;

    public BlockCondition() {
        this.blocktype = 7;
        this.opcode = 39;
    }

    public int getOpcode() {
        return this.opcode;
    }

    @Override
    public void saveXmlHeader(StringBuilder buffer) {
        super.saveXmlHeader(buffer);
        String opcodename = PcodeOp.getMnemonic(this.opcode);
        SpecXmlUtils.encodeStringAttribute((StringBuilder)buffer, (String)"opcode", (String)opcodename);
    }

    @Override
    public void restoreXmlHeader(XmlElement el) throws PcodeXMLException {
        super.restoreXmlHeader(el);
        String opcodename = el.getAttribute("opcode");
        try {
            this.opcode = PcodeOp.getOpcode(opcodename);
        }
        catch (UnknownInstructionException e) {
            this.opcode = 39;
        }
    }
}

