/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.GlobalSymbolMap;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.HighVariable;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class HighGlobal
extends HighVariable {
    private HighSymbol symbol;

    public HighGlobal(HighFunction high) {
        super(high);
    }

    public HighGlobal(HighSymbol sym, Varnode vn, Varnode[] inst) {
        super(sym.getName(), sym.getDataType(), vn, inst, sym.getHighFunction());
        this.symbol = sym;
    }

    @Override
    public HighSymbol getSymbol() {
        return this.symbol;
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"high"});
        long symref = SpecXmlUtils.decodeLong((String)el.getAttribute("symref"));
        String attrString = el.getAttribute("offset");
        this.offset = -1;
        if (attrString != null) {
            this.offset = SpecXmlUtils.decodeInt((String)attrString);
        }
        this.restoreInstances(parser, el);
        if (symref == 0L) {
            throw new PcodeXMLException("Missing symref attribute in <high> tag");
        }
        this.symbol = this.function.getGlobalSymbolMap().getSymbol(symref);
        if (this.symbol == null) {
            int symbolSize;
            DataType symbolType;
            if (this.offset < 0) {
                symbolType = this.type;
                symbolSize = this.getSize();
            } else {
                symbolType = null;
                symbolSize = -1;
            }
            GlobalSymbolMap globalMap = this.function.getGlobalSymbolMap();
            this.symbol = globalMap.populateSymbol(symref, symbolType, symbolSize);
            if (this.symbol == null) {
                Address addr = this.represent.getAddress();
                if (this.offset > 0) {
                    addr = addr.subtract(this.offset);
                }
                this.symbol = globalMap.newSymbol(symref, addr, symbolType, symbolSize);
                if (this.symbol == null) {
                    throw new PcodeXMLException("Bad global storage: " + addr.toString());
                }
            }
        }
        if (this.offset < 0) {
            this.name = this.symbol.getName();
        }
        this.symbol.setHighVariable(this);
        parser.end(el);
    }
}

