/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Parameter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.Variable;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.DynamicEntry;
import ghidra.program.model.pcode.DynamicHash;
import ghidra.program.model.pcode.EquateSymbol;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.HighParam;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.pcode.MappedEntry;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.pcode.SymbolEntry;
import ghidra.program.model.symbol.Equate;
import ghidra.program.model.symbol.EquateTable;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.SystemUtilities;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class LocalSymbolMap {
    private HighFunction func;
    private String spacename;
    private HashMap<MappedVarKey, HighSymbol> addrMappedSymbols;
    private HashMap<Long, HighSymbol> symbolMap;
    private HighSymbol[] paramSymbols;
    private long uniqueSymbolId;
    private static final Comparator<HighSymbol> PARAM_SYMBOL_SLOT_COMPARATOR = new Comparator<HighSymbol>(){

        @Override
        public int compare(HighSymbol sym1, HighSymbol sym2) {
            return sym1.getCategoryIndex() - sym2.getCategoryIndex();
        }
    };

    public LocalSymbolMap(HighFunction highFunc, String spcname) {
        this.func = highFunc;
        this.spacename = spcname;
        this.addrMappedSymbols = new HashMap();
        this.symbolMap = new HashMap();
        this.paramSymbols = new HighSymbol[0];
        this.uniqueSymbolId = 0L;
    }

    public HighFunction getHighFunction() {
        return this.func;
    }

    private long getNextId() {
        long key = 0x4000000000000000L + this.uniqueSymbolId;
        ++this.uniqueSymbolId;
        return key;
    }

    public Map<String, HighSymbol> getNameToSymbolMap() {
        TreeMap<String, HighSymbol> newMap = new TreeMap<String, HighSymbol>();
        for (HighSymbol highSymbol : this.symbolMap.values()) {
            newMap.put(highSymbol.getName(), highSymbol);
        }
        return newMap;
    }

    private void removeSymbol(HighSymbol highSymbol) {
        SymbolEntry mapEntry = highSymbol.getFirstWholeMap();
        if (mapEntry instanceof MappedEntry) {
            MappedVarKey key = new MappedVarKey(mapEntry.getStorage(), mapEntry.getPCAdress());
            this.addrMappedSymbols.remove(key);
        }
        this.symbolMap.remove(highSymbol.getId());
        if (highSymbol.isParameter()) {
            int i;
            int index = highSymbol.getCategoryIndex();
            HighSymbol[] newArray = new HighSymbol[this.paramSymbols.length - 1];
            for (i = 0; i < index; ++i) {
                newArray[i] = this.paramSymbols[i];
            }
            for (i = index + 1; i < this.paramSymbols.length; ++i) {
                HighSymbol paramSym;
                newArray[i - 1] = paramSym = this.paramSymbols[i];
                --paramSym.categoryIndex;
            }
        }
    }

    private void mergeNamedSymbols(String name, Map<String, HighSymbol> nameMap) {
        SymbolEntry mapEntry;
        String nextName;
        HighSymbol nextSymbol;
        String baseName = name.substring(0, name.length() - 2);
        HighSymbol baseSymbol = nameMap.get(baseName);
        if (baseSymbol == null || !baseSymbol.isTypeLocked() || baseSymbol instanceof EquateSymbol) {
            return;
        }
        DataType baseDataType = baseSymbol.getDataType();
        int index = 1;
        while ((nextSymbol = nameMap.get(nextName = baseName + "$" + Integer.toString(index))) != null && nextSymbol.isTypeLocked() && !nextSymbol.isParameter() && !(baseSymbol instanceof EquateSymbol) && nextSymbol.getDataType().equals(baseDataType) && (mapEntry = nextSymbol.getFirstWholeMap()).getPCAdress() != null) {
            baseSymbol.addMapEntry(mapEntry);
            this.removeSymbol(nextSymbol);
            ++index;
        }
    }

    public void grabFromFunction(boolean includeDefaultNames) {
        VariableStorage storage;
        String name;
        Variable[] locals;
        ArrayList<String> mergeNames = null;
        Function dbFunction = this.func.getFunction();
        for (Variable local : locals = dbFunction.getLocalVariables()) {
            HighSymbol sym;
            Address defAddr;
            if (!local.isValid()) continue;
            DataType dt = local.getDataType();
            boolean istypelock = true;
            boolean isnamelock = true;
            if (Undefined.isUndefined(dt)) {
                istypelock = false;
            }
            if ((name = local.getName()).length() > 2 && name.charAt(name.length() - 2) == '$' && name.charAt(name.length() - 1) == '1') {
                if (mergeNames == null) {
                    mergeNames = new ArrayList<String>();
                }
                mergeNames.add(name);
            }
            storage = local.getVariableStorage();
            long id = 0L;
            Symbol symbol = local.getSymbol();
            if (symbol != null) {
                id = symbol.getID();
            }
            if (storage.isHashStorage()) {
                defAddr = dbFunction.getEntryPoint().addWrap(local.getFirstUseOffset());
                sym = this.newDynamicSymbol(id, name, dt, storage.getFirstVarnode().getOffset(), defAddr);
            } else {
                defAddr = null;
                int addrType = storage.getFirstVarnode().getAddress().getAddressSpace().getType();
                if (addrType != 5 && addrType != 1) {
                    defAddr = dbFunction.getEntryPoint().addWrap(local.getFirstUseOffset());
                }
                sym = this.newMappedSymbol(id, name, dt, storage, defAddr, -1);
            }
            sym.setTypeLock(istypelock);
            sym.setNameLock(isnamelock);
        }
        Parameter[] p = dbFunction.getParameters();
        boolean lock = dbFunction.getSignatureSource() != SourceType.DEFAULT;
        Address pcaddr = dbFunction.getEntryPoint();
        pcaddr = pcaddr.subtractWrap(1L);
        ArrayList<HighSymbol> paramList = new ArrayList<HighSymbol>();
        for (int i = 0; i < p.length; ++i) {
            Parameter var = p[i];
            if (!var.isValid()) continue;
            DataType dt = var.getDataType();
            name = var.getName();
            if (name.length() > 2 && name.charAt(name.length() - 2) == '$' && name.charAt(name.length() - 1) == '1') {
                if (mergeNames == null) {
                    mergeNames = new ArrayList();
                }
                mergeNames.add(name);
            }
            Address resAddr = (storage = var.getVariableStorage()).isStackStorage() ? null : pcaddr;
            long id = 0L;
            Symbol symbol = var.getSymbol();
            if (symbol != null) {
                id = symbol.getID();
            }
            HighSymbol paramSymbol = this.newMappedSymbol(id, name, dt, storage, resAddr, i);
            paramList.add(paramSymbol);
            boolean namelock = true;
            if (!includeDefaultNames) {
                namelock = this.isUserDefinedName(name);
            }
            paramSymbol.setNameLock(namelock);
            paramSymbol.setTypeLock(lock);
        }
        this.paramSymbols = new HighSymbol[paramList.size()];
        paramList.toArray(this.paramSymbols);
        Arrays.sort(this.paramSymbols, PARAM_SYMBOL_SLOT_COMPARATOR);
        this.grabEquates(dbFunction);
        this.grabMerges(mergeNames);
    }

    private boolean isUserDefinedName(String name) {
        if (name.startsWith("local_")) {
            return false;
        }
        return !name.startsWith("param_");
    }

    private HighSymbol parseSymbolXML(XmlPullParser parser) throws PcodeXMLException {
        HighSymbol res = HighSymbol.restoreMapSymXML(parser, false, this.func);
        this.insertSymbol(res);
        return res;
    }

    public void parseScopeXML(XmlPullParser parser) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"localdb"});
        this.spacename = el.getAttribute("main");
        XmlElement scopeel = parser.start(new String[]{"scope"});
        parser.discardSubTree();
        parser.discardSubTree();
        this.addrMappedSymbols.clear();
        this.symbolMap.clear();
        XmlElement nextEl = parser.peek();
        if (nextEl != null && nextEl.isStart() && "symbollist".equals(nextEl.getName())) {
            this.parseSymbolList(parser);
        }
        parser.end(scopeel);
        parser.end(el);
    }

    public void parseSymbolList(XmlPullParser parser) throws PcodeXMLException {
        XmlElement el = parser.start(new String[]{"symbollist"});
        ArrayList<HighSymbol> parms = new ArrayList<HighSymbol>();
        while (parser.peek().isStart()) {
            HighSymbol sym = this.parseSymbolXML(parser);
            if (!sym.isParameter()) continue;
            parms.add(sym);
        }
        this.paramSymbols = new HighSymbol[parms.size()];
        parms.toArray(this.paramSymbols);
        Arrays.sort(this.paramSymbols, PARAM_SYMBOL_SLOT_COMPARATOR);
        parser.end(el);
    }

    public void buildLocalDbXML(StringBuilder resBuf, Namespace namespace) {
        resBuf.append("<localdb");
        SpecXmlUtils.encodeBooleanAttribute((StringBuilder)resBuf, (String)"lock", (boolean)false);
        SpecXmlUtils.encodeStringAttribute((StringBuilder)resBuf, (String)"main", (String)this.spacename);
        resBuf.append(">\n");
        resBuf.append("<scope");
        SpecXmlUtils.xmlEscapeAttribute((StringBuilder)resBuf, (String)"name", (String)this.func.getFunction().getName());
        resBuf.append(">\n");
        resBuf.append("<parent");
        long parentid = 0L;
        if (!HighFunction.collapseToGlobal(namespace)) {
            parentid = namespace.getID();
        }
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)resBuf, (String)"id", (long)parentid);
        resBuf.append("/>\n");
        resBuf.append("<rangelist/>\n");
        resBuf.append("<symbollist>\n");
        for (HighSymbol sym : this.symbolMap.values()) {
            HighSymbol.buildMapSymXML(resBuf, sym);
        }
        resBuf.append("</symbollist>\n");
        resBuf.append("</scope>\n");
        resBuf.append("</localdb>\n");
    }

    public Iterator<HighSymbol> getSymbols() {
        return this.symbolMap.values().iterator();
    }

    public HighSymbol findLocal(VariableStorage store, Address pc) {
        MappedVarKey key = new MappedVarKey(store, pc);
        return this.addrMappedSymbols.get(key);
    }

    public HighSymbol findLocal(Address addr, Address pc) {
        MappedVarKey key = new MappedVarKey(addr, pc);
        return this.addrMappedSymbols.get(key);
    }

    public HighSymbol getSymbol(long id) {
        return this.symbolMap.get(id);
    }

    public int getNumParams() {
        return this.paramSymbols.length;
    }

    public HighSymbol getParamSymbol(int i) {
        return this.paramSymbols[i];
    }

    public HighParam getParam(int i) {
        return (HighParam)this.paramSymbols[i].getHighVariable();
    }

    public boolean containsVariableWithName(String name) {
        Collection<HighSymbol> values = this.symbolMap.values();
        for (HighSymbol sym : values) {
            if (!sym.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    protected HighSymbol newMappedSymbol(long id, String nm, DataType dt, VariableStorage store, Address pcaddr, int slot) {
        if (id == 0L) {
            id = this.getNextId();
        }
        HighSymbol sym = new HighSymbol(id, nm, dt, this.func);
        if (slot >= 0) {
            sym.setCategory(0, slot);
        }
        MappedEntry entry = new MappedEntry(sym, store, pcaddr);
        sym.addMapEntry(entry);
        this.insertSymbol(sym);
        return sym;
    }

    protected HighSymbol newDynamicSymbol(long id, String nm, DataType dt, long hash, Address pcaddr) {
        if (id == 0L) {
            id = this.getNextId();
        }
        HighSymbol sym = new HighSymbol(id, nm, dt, this.func);
        DynamicEntry entry = new DynamicEntry(sym, pcaddr, hash);
        sym.addMapEntry(entry);
        this.insertSymbol(sym);
        return sym;
    }

    private void insertSymbol(HighSymbol sym) {
        long val;
        long uniqueId = sym.getId();
        if (uniqueId >> 56 == 64L && (val = uniqueId & Integer.MAX_VALUE) > this.uniqueSymbolId) {
            this.uniqueSymbolId = val;
        }
        if (sym.entryList[0] instanceof MappedEntry) {
            MappedVarKey key = new MappedVarKey(sym.getStorage(), sym.getPCAddress());
            this.addrMappedSymbols.put(key, sym);
        }
        this.symbolMap.put(uniqueId, sym);
    }

    private EquateSymbol newEquateSymbol(long uniqueId, String nm, long val, long hash, Address addr) {
        EquateSymbol eqSymbol;
        int conv;
        if (uniqueId == 0L) {
            uniqueId = this.getNextId();
        }
        if ((conv = EquateSymbol.convertName(nm, val)) < 0) {
            eqSymbol = new EquateSymbol(uniqueId, nm, val, this.func, addr, hash);
            eqSymbol.setNameLock(true);
        } else {
            eqSymbol = new EquateSymbol(uniqueId, conv, val, this.func, addr, hash);
        }
        return eqSymbol;
    }

    private void grabEquates(Function dbFunction) {
        Program program = dbFunction.getProgram();
        EquateTable equateTable = program.getEquateTable();
        Listing listing = program.getListing();
        AddressIterator equateAddresses = equateTable.getEquateAddresses(dbFunction.getBody());
        while (equateAddresses.hasNext()) {
            Address defAddr = equateAddresses.next();
            for (Equate eq : equateTable.getEquates(defAddr)) {
                long[] hash;
                Instruction instr = listing.getInstructionAt(defAddr);
                if (instr == null || (hash = DynamicHash.calcConstantHash(instr, eq.getValue())).length == 0) continue;
                Arrays.sort(hash);
                String displayName = eq.getDisplayName();
                long eqValue = eq.getValue();
                for (int i = 0; i < hash.length; ++i) {
                    if (i != 0 && hash[i - 1] == hash[i]) continue;
                    EquateSymbol eqSymbol = this.newEquateSymbol(0L, displayName, eqValue, hash[i], defAddr);
                    this.symbolMap.put(eqSymbol.getId(), eqSymbol);
                }
            }
        }
    }

    private void grabMerges(ArrayList<String> mergeNames) {
        if (mergeNames == null) {
            return;
        }
        Map<String, HighSymbol> nameToSymbolMap = this.getNameToSymbolMap();
        for (String name : mergeNames) {
            this.mergeNamedSymbols(name, nameToSymbolMap);
        }
    }

    class MappedVarKey {
        private Address addr;
        private Address pcaddr;

        public MappedVarKey(Address addr, Address pcad) {
            this.addr = addr;
            if (!addr.isStackAddress()) {
                this.pcaddr = pcad;
            }
        }

        public MappedVarKey(VariableStorage store, Address pcad) {
            this.addr = store.getFirstVarnode().getAddress();
            if (!this.addr.isStackAddress()) {
                this.pcaddr = pcad;
            }
        }

        public boolean equals(Object op2) {
            MappedVarKey op = (MappedVarKey)op2;
            if (!SystemUtilities.isEqual((Object)this.pcaddr, (Object)op.pcaddr)) {
                return false;
            }
            return this.addr.equals(op.addr);
        }

        public int hashCode() {
            int hash1 = this.addr.hashCode();
            int hash2 = this.pcaddr != null ? this.pcaddr.hashCode() : 0;
            return hash1 << 4 ^ hash2;
        }
    }
}

