/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.data.DataType;
import ghidra.program.model.pcode.PcodeFactory;
import ghidra.program.model.pcode.PcodeXMLException;
import ghidra.program.model.pcode.Varnode;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

public class ParamMeasure {
    private Varnode vn = null;
    private DataType dt = null;
    private Integer rank = null;

    public boolean isEmpty() {
        return this.vn == null;
    }

    public void readXml(XmlPullParser parser, PcodeFactory factory) throws PcodeXMLException {
        this.vn = Varnode.readXML(parser, factory);
        this.dt = factory.getDataTypeManager().readXMLDataType(parser);
        XmlElement rankel = parser.start(new String[]{"rank"});
        String strVal = rankel.getAttribute("val");
        this.rank = SpecXmlUtils.decodeInt((String)strVal);
        parser.end(rankel);
    }

    public Varnode getVarnode() {
        return this.vn;
    }

    public DataType getDataType() {
        return this.dt;
    }

    public Integer getRank() {
        return this.rank;
    }
}

