/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.util.DefaultPropertyMap;
import ghidra.program.model.util.LongPropertyMap;
import ghidra.util.exception.NoValueException;
import ghidra.util.prop.LongPropertySet;
import ghidra.util.prop.PropertySet;

public class DefaultLongPropertyMap
extends DefaultPropertyMap
implements LongPropertyMap {
    private static final long serialVersionUID = 1L;
    private LongPropertySet lps;

    public DefaultLongPropertyMap(String name) {
        super((PropertySet)new LongPropertySet(name));
        this.lps = (LongPropertySet)this.propertyMgr;
    }

    @Override
    public void add(Address addr, long value) {
        this.lps.putLong(this.addrMap.getKey(addr), value);
    }

    @Override
    public long getLong(Address addr) throws NoValueException {
        return this.lps.getLong(this.addrMap.getKey(addr));
    }

    @Override
    public Object getObject(Address addr) {
        try {
            return new Long(this.getLong(addr));
        }
        catch (NoValueException e) {
            return null;
        }
    }
}

