/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.util;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressMapImpl;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.util.PropertyMap;
import ghidra.util.LongIterator;
import ghidra.util.datastruct.NoSuchIndexException;
import ghidra.util.prop.PropertySet;
import ghidra.util.prop.PropertyVisitor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class DefaultPropertyMap
implements PropertyMap {
    protected PropertySet propertyMgr;
    protected AddressMapImpl addrMap;
    protected String description;

    public DefaultPropertyMap(PropertySet propertyMgr) {
        this.propertyMgr = propertyMgr;
        this.addrMap = new AddressMapImpl();
    }

    @Override
    public String getName() {
        return this.propertyMgr.getName();
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public boolean intersects(Address start, Address end) {
        return this.propertyMgr.intersects(this.addrMap.getKey(start), this.addrMap.getKey(end));
    }

    @Override
    public boolean intersects(AddressSetView set) {
        AddressRangeIterator ranges = set.getAddressRanges();
        while (ranges.hasNext()) {
            AddressRange range = (AddressRange)ranges.next();
            if (!this.intersects(range.getMinAddress(), range.getMaxAddress())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeRange(Address start, Address end) {
        return this.propertyMgr.removeRange(this.addrMap.getKey(start), this.addrMap.getKey(end));
    }

    @Override
    public boolean remove(Address addr) {
        return this.propertyMgr.remove(this.addrMap.getKey(addr));
    }

    @Override
    public boolean hasProperty(Address addr) {
        return this.propertyMgr.hasProperty(this.addrMap.getKey(addr));
    }

    @Override
    public Address getNextPropertyAddress(Address addr) {
        try {
            long index = this.propertyMgr.getNextPropertyIndex(this.addrMap.getKey(addr));
            return this.addrMap.decodeAddress(index);
        }
        catch (NoSuchIndexException noSuchIndexException) {
            return null;
        }
    }

    @Override
    public Address getPreviousPropertyAddress(Address addr) {
        try {
            long index = this.propertyMgr.getPreviousPropertyIndex(this.addrMap.getKey(addr));
            return this.addrMap.decodeAddress(index);
        }
        catch (NoSuchIndexException noSuchIndexException) {
            return null;
        }
    }

    @Override
    public Address getFirstPropertyAddress() {
        try {
            long index = this.propertyMgr.getFirstPropertyIndex();
            return this.addrMap.decodeAddress(index);
        }
        catch (NoSuchIndexException noSuchIndexException) {
            return null;
        }
    }

    @Override
    public Address getLastPropertyAddress() {
        try {
            long index = this.propertyMgr.getLastPropertyIndex();
            return this.addrMap.decodeAddress(index);
        }
        catch (NoSuchIndexException noSuchIndexException) {
            return null;
        }
    }

    @Override
    public int getSize() {
        return this.propertyMgr.getSize();
    }

    @Override
    public AddressIterator getPropertyIterator(Address start, Address end) {
        return new AddressPropertyIterator(start, end);
    }

    @Override
    public AddressIterator getPropertyIterator(Address start, Address end, boolean forward) {
        return new AddressPropertyIterator(start, end, forward);
    }

    @Override
    public AddressIterator getPropertyIterator() {
        return new AddressPropertyIterator();
    }

    @Override
    public AddressIterator getPropertyIterator(AddressSetView asv) {
        return new AddressSetPropertyIterator(asv, true);
    }

    @Override
    public AddressIterator getPropertyIterator(AddressSetView asv, boolean forward) {
        return new AddressSetPropertyIterator(asv, forward);
    }

    @Override
    public AddressIterator getPropertyIterator(Address start, boolean forward) {
        return new AddressPropertyIterator(start, forward);
    }

    @Override
    public void applyValue(PropertyVisitor visitor, Address addr) {
        this.propertyMgr.applyValue(visitor, this.addrMap.getKey(addr));
    }

    @Override
    public void moveRange(Address start, Address end, Address newStart) {
        this.propertyMgr.moveRange(this.addrMap.getKey(start), this.addrMap.getKey(end), this.addrMap.getKey(newStart));
    }

    public void saveProperties(ObjectOutputStream oos, Address start, Address end) throws IOException {
        this.propertyMgr.saveProperties(oos, this.addrMap.getKey(start), this.addrMap.getKey(end));
    }

    public void restoreProperties(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.propertyMgr.restoreProperties(ois);
    }

    private class AddressSetPropertyIterator
    implements AddressIterator {
        private AddressPropertyIterator iter;
        private AddressRangeIterator ranges;
        private Address nextAddr;
        private AddressRange curRange;
        private boolean atStart;

        AddressSetPropertyIterator(AddressSetView addrSet, boolean atStart) {
            this.ranges = addrSet.getAddressRanges(atStart);
            this.atStart = atStart;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this.nextAddr == null) {
                this.nextAddr = this.findNext();
            }
            return this.nextAddr != null;
        }

        public boolean hasPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address next() {
            if (this.hasNext()) {
                Address addr = this.nextAddr;
                this.nextAddr = null;
                return addr;
            }
            return null;
        }

        public Address previous() {
            throw new UnsupportedOperationException();
        }

        private Address findNext() {
            if (this.iter != null && this.iter.hasNext()) {
                return this.iter.next();
            }
            while (this.ranges.hasNext()) {
                AddressRange range = (AddressRange)this.ranges.next();
                if (range == this.curRange) continue;
                this.curRange = range;
                this.iter = new AddressPropertyIterator(range.getMinAddress(), range.getMaxAddress(), this.atStart);
                if (!this.iter.hasNext()) continue;
                return this.iter.next();
            }
            return null;
        }

        @Override
        public Iterator<Address> iterator() {
            return this;
        }
    }

    private class AddressPropertyIterator
    implements AddressIterator {
        private LongIterator iter;
        private boolean forward = true;

        AddressPropertyIterator() {
            this.iter = DefaultPropertyMap.this.propertyMgr.getPropertyIterator();
        }

        AddressPropertyIterator(Address start, boolean forward) {
            this.iter = DefaultPropertyMap.this.propertyMgr.getPropertyIterator(DefaultPropertyMap.this.addrMap.getKey(start), forward);
            this.forward = forward;
        }

        AddressPropertyIterator(Address start, Address end) {
            this.iter = DefaultPropertyMap.this.propertyMgr.getPropertyIterator(DefaultPropertyMap.this.addrMap.getKey(start), DefaultPropertyMap.this.addrMap.getKey(end));
        }

        AddressPropertyIterator(Address start, Address end, boolean forward) {
            this.iter = DefaultPropertyMap.this.propertyMgr.getPropertyIterator(DefaultPropertyMap.this.addrMap.getKey(start), DefaultPropertyMap.this.addrMap.getKey(end), forward);
            this.forward = forward;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            if (this.forward) {
                return this.iter.hasNext();
            }
            return this.iter.hasPrevious();
        }

        @Override
        public Address next() {
            try {
                if (this.forward) {
                    return DefaultPropertyMap.this.addrMap.decodeAddress(this.iter.next());
                }
                return DefaultPropertyMap.this.addrMap.decodeAddress(this.iter.previous());
            }
            catch (NoSuchElementException noSuchElementException) {
                return null;
            }
        }

        @Override
        public Iterator<Address> iterator() {
            return this;
        }
    }
}

