/*
 * Decompiled with CFR 0.152.
 */
package docking;

import docking.SplitNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class SplitPanel
extends JPanel {
    private static int DIVIDER_SIZE = 4;
    private Component leftComp;
    private Component rightComp;
    private Component divider;
    private boolean isHorizontal;
    private float dividerPosition = 0.0f;

    public SplitPanel(SplitNode splitNode, Component leftComp, Component rightComp, boolean isHorizontal) {
        this.setLayout(new SplitPanelLayout(isHorizontal));
        this.leftComp = leftComp;
        this.rightComp = rightComp;
        this.isHorizontal = isHorizontal;
        this.divider = new Divider();
        this.divider.setBackground(Color.LIGHT_GRAY);
        this.add(leftComp);
        this.add(this.divider);
        this.add(rightComp);
    }

    public boolean isLeft(Component c) {
        return SwingUtilities.isDescendingFrom(c, this.leftComp);
    }

    float getDividerPosition() {
        return this.dividerPosition;
    }

    public void setDividerPosition(float newPosition) {
        this.dividerPosition = newPosition;
        this.validate();
    }

    class Divider
    extends JPanel {
        Divider() {
            if (SplitPanel.this.isHorizontal) {
                this.setCursor(Cursor.getPredefinedCursor(10));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(8));
            }
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    SplitPanel.this.dividerPosition = SplitPanel.this.isHorizontal ? (SplitPanel.this.dividerPosition += (float)e.getX() / (float)SplitPanel.this.getWidth()) : (SplitPanel.this.dividerPosition += (float)e.getY() / (float)SplitPanel.this.getHeight());
                    SplitPanel.this.doLayout();
                    SplitPanel.this.validate();
                }
            });
        }
    }

    class SplitPanelLayout
    implements LayoutManager {
        boolean horizontal;

        SplitPanelLayout(boolean isHorizontal) {
            this.horizontal = isHorizontal;
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension size = parent.getSize();
            if (size.width <= 0 || size.height <= 0) {
                return;
            }
            Dimension minSize1 = SplitPanel.this.leftComp.getMinimumSize();
            Dimension minSize2 = SplitPanel.this.rightComp.getMinimumSize();
            Insets insets = parent.getInsets();
            int width = size.width - insets.left - insets.right;
            int height = size.height - insets.top - insets.bottom;
            if (SplitPanel.this.dividerPosition == 0.0f) {
                Dimension d1 = SplitPanel.this.leftComp.getPreferredSize();
                Dimension d2 = SplitPanel.this.rightComp.getPreferredSize();
                Dimension d3 = SplitPanel.this.leftComp.getSize();
                Dimension d4 = SplitPanel.this.rightComp.getSize();
                if (this.horizontal) {
                    if (d3.width > 0 && d4.width > 0) {
                        d1 = d3;
                        d2 = d4;
                    }
                    int prefWidth = d1.width + d2.width;
                    SplitPanel.this.dividerPosition = (float)d1.width / (float)prefWidth;
                } else {
                    if (d3.height > 0 && d4.height > 0) {
                        d1 = d3;
                        d2 = d4;
                    }
                    int prefHeight = d1.height + d2.height;
                    SplitPanel.this.dividerPosition = (float)d1.height / (float)prefHeight;
                }
            }
            if (this.horizontal) {
                int minWidth = minSize1.width + minSize2.width;
                int dividerPixelPosition = Math.round((float)(width -= DIVIDER_SIZE) * SplitPanel.this.dividerPosition);
                if (width <= minWidth) {
                    SplitPanel.this.dividerPosition = (float)minSize1.width / (float)minWidth;
                } else if (dividerPixelPosition <= minSize1.width) {
                    SplitPanel.this.dividerPosition = (float)minSize1.width / (float)width;
                } else if (dividerPixelPosition >= width - minSize2.width) {
                    SplitPanel.this.dividerPosition = (float)(width - minSize2.width) / (float)width;
                }
                dividerPixelPosition = Math.round((float)width * SplitPanel.this.dividerPosition);
                SplitPanel.this.leftComp.setBounds(insets.left, insets.top, dividerPixelPosition, height);
                SplitPanel.this.divider.setBounds(insets.left + dividerPixelPosition, insets.top, DIVIDER_SIZE, height);
                SplitPanel.this.rightComp.setBounds(insets.left + dividerPixelPosition + DIVIDER_SIZE, insets.top, width - dividerPixelPosition, height);
            } else {
                int minHeight = minSize1.height + minSize2.height;
                int dividerPixelPosition = Math.round((float)(height -= DIVIDER_SIZE) * SplitPanel.this.dividerPosition);
                if (height <= minHeight) {
                    SplitPanel.this.dividerPosition = (float)minSize1.height / (float)minHeight;
                } else if (dividerPixelPosition <= minSize1.height) {
                    SplitPanel.this.dividerPosition = (float)minSize1.height / (float)height;
                } else if (dividerPixelPosition >= height - minSize2.height) {
                    SplitPanel.this.dividerPosition = (float)(height - minSize2.height) / (float)height;
                }
                dividerPixelPosition = Math.round((float)height * SplitPanel.this.dividerPosition);
                SplitPanel.this.leftComp.setBounds(insets.left, insets.top, width, dividerPixelPosition);
                SplitPanel.this.divider.setBounds(insets.left, insets.top + dividerPixelPosition, width, DIVIDER_SIZE);
                SplitPanel.this.rightComp.setBounds(insets.left, dividerPixelPosition + DIVIDER_SIZE + insets.top, width, height - dividerPixelPosition);
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Dimension d1 = SplitPanel.this.leftComp.getMinimumSize();
            Dimension d2 = SplitPanel.this.rightComp.getMinimumSize();
            Insets insets = parent.getInsets();
            if (this.horizontal) {
                return new Dimension(d1.width + d2.width + DIVIDER_SIZE + insets.left + insets.right, Math.max(d1.height, d2.height) + insets.top + insets.bottom);
            }
            return new Dimension(Math.max(d1.width, d2.width) + insets.left + insets.right, d1.height + d2.height + DIVIDER_SIZE + insets.top + insets.bottom);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Dimension d1 = SplitPanel.this.leftComp.getPreferredSize();
            Dimension d2 = SplitPanel.this.rightComp.getPreferredSize();
            Insets insets = parent.getInsets();
            if (this.horizontal) {
                return new Dimension(d1.width + d2.width + DIVIDER_SIZE + insets.left + insets.right, Math.max(d1.height, d2.height) + insets.top + insets.bottom);
            }
            return new Dimension(Math.max(d1.width, d2.width) + insets.left + insets.right, d1.height + d2.height + DIVIDER_SIZE + insets.top + insets.bottom);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

