/*
 * Decompiled with CFR 0.152.
 */
package docking.actions;

import com.google.common.collect.Iterators;
import docking.ActionToGuiHelper;
import docking.ComponentProvider;
import docking.Tool;
import docking.action.DockingActionIf;
import docking.action.HelpAction;
import docking.action.KeyBindingData;
import docking.action.KeyBindingType;
import docking.action.KeyBindingsManager;
import docking.action.ShowFocusCycleAction;
import docking.action.ShowFocusInfoAction;
import docking.actions.AutoGeneratedDockingAction;
import docking.actions.DockingToolActions;
import docking.actions.KeyBindingAction;
import docking.actions.KeyBindingUtils;
import docking.actions.SharedActionRegistry;
import docking.actions.SharedDockingActionPlaceholder;
import docking.actions.SharedStubKeyBindingAction;
import ghidra.framework.options.OptionType;
import ghidra.framework.options.OptionsChangeListener;
import ghidra.framework.options.ToolOptions;
import ghidra.util.Msg;
import ghidra.util.ReservedKeyBindings;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.AssertException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.KeyStroke;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.collections4.Predicate;
import org.apache.commons.collections4.map.LazyMap;
import util.CollectionUtils;

public class ToolActions
implements DockingToolActions,
PropertyChangeListener {
    private Pattern ACTION_NAME_PATTERN = Pattern.compile("(.+) \\((.+)\\)");
    private ActionToGuiHelper actionGuiHelper;
    private Map<String, Map<String, Set<DockingActionIf>>> actionsByNameByOwner = LazyMap.lazyMap(new HashMap(), () -> LazyMap.lazyMap(new HashMap(), () -> new HashSet()));
    private Map<String, SharedStubKeyBindingAction> sharedActionMap = new HashMap<String, SharedStubKeyBindingAction>();
    private ToolOptions keyBindingOptions;
    private Tool dockingTool;
    private KeyBindingsManager keyBindingsManager;
    private OptionsChangeListener optionChangeListener = (options, optionName, oldValue, newValue) -> this.updateKeyBindingsFromOptions(options, optionName, (KeyStroke)newValue);

    public ToolActions(Tool tool, ActionToGuiHelper actionToGuiHelper) {
        this.dockingTool = tool;
        this.actionGuiHelper = actionToGuiHelper;
        this.keyBindingsManager = new KeyBindingsManager(tool);
        this.keyBindingOptions = tool.getOptions("Key Bindings");
        this.keyBindingOptions.addOptionsChangeListener(this.optionChangeListener);
        this.createReservedKeyBindings();
        SharedActionRegistry.installSharedActions(tool, this);
    }

    private void createReservedKeyBindings() {
        KeyBindingAction keyBindingAction = new KeyBindingAction(this);
        this.keyBindingsManager.addReservedAction(keyBindingAction, ReservedKeyBindings.UPDATE_KEY_BINDINGS_KEY);
        this.keyBindingsManager.addReservedAction(new HelpAction(false, ReservedKeyBindings.HELP_KEY1));
        this.keyBindingsManager.addReservedAction(new HelpAction(false, ReservedKeyBindings.HELP_KEY2));
        this.keyBindingsManager.addReservedAction(new HelpAction(true, ReservedKeyBindings.HELP_INFO_KEY));
        if (SystemUtilities.isInDevelopmentMode()) {
            this.keyBindingsManager.addReservedAction(new ShowFocusInfoAction());
            this.keyBindingsManager.addReservedAction(new ShowFocusCycleAction());
        }
    }

    public void dispose() {
        this.actionsByNameByOwner.clear();
        this.sharedActionMap.clear();
        this.keyBindingsManager.dispose();
    }

    private void addActionToMap(DockingActionIf action) {
        Set<DockingActionIf> actions = this.getActionStorage(action);
        KeyBindingUtils.assertSameDefaultKeyBindings(action, actions);
        actions.add(action);
    }

    @Override
    public synchronized void addLocalAction(ComponentProvider provider, DockingActionIf action) {
        this.checkForAlreadyAddedAction(provider, action);
        action.addPropertyChangeListener(this);
        this.addActionToMap(action);
        this.initializeKeyBinding(provider, action);
        this.actionGuiHelper.addLocalAction(provider, action);
    }

    @Override
    public synchronized void addGlobalAction(DockingActionIf action) {
        this.checkForAlreadyAddedAction(null, action);
        action.addPropertyChangeListener(this);
        this.addActionToMap(action);
        this.initializeKeyBinding(null, action);
        this.actionGuiHelper.addToolAction(action);
    }

    private void initializeKeyBinding(ComponentProvider provider, DockingActionIf action) {
        KeyBindingType type = action.getKeyBindingType();
        if (!type.supportsKeyBindings()) {
            return;
        }
        if (type.isShared()) {
            this.installSharedKeyBinding(provider, action);
            return;
        }
        KeyStroke ks = action.getKeyBinding();
        this.loadKeyBindingFromOptions(action, ks);
        this.keyBindingsManager.addAction(provider, action);
    }

    private void loadKeyBindingFromOptions(DockingActionIf action, KeyStroke ks) {
        String description = "Keybinding for " + action.getFullName();
        this.keyBindingOptions.registerOption(action.getFullName(), OptionType.KEYSTROKE_TYPE, (Object)ks, null, description);
        KeyStroke newKs = this.keyBindingOptions.getKeyStroke(action.getFullName(), ks);
        if (!Objects.equals(ks, newKs)) {
            action.setUnvalidatedKeyBindingData(new KeyBindingData(newKs));
        }
    }

    private void installSharedKeyBinding(ComponentProvider provider, DockingActionIf action) {
        String name = action.getName();
        KeyStroke defaultKeyStroke = action.getKeyBinding();
        SharedStubKeyBindingAction stub = this.sharedActionMap.computeIfAbsent(name, key -> {
            SharedStubKeyBindingAction newStub = new SharedStubKeyBindingAction(name, defaultKeyStroke, this.keyBindingOptions);
            this.registerStub(newStub, defaultKeyStroke);
            return newStub;
        });
        String owner = action.getOwner();
        stub.addActionOwner(owner);
        stub.addClientAction(action);
        if (!(action instanceof AutoGeneratedDockingAction)) {
            this.keyBindingsManager.addAction(provider, action);
        }
    }

    private void registerStub(SharedStubKeyBindingAction stub, KeyStroke defaultKeyStroke) {
        stub.addPropertyChangeListener(this);
        this.loadKeyBindingFromOptions(stub, defaultKeyStroke);
        this.keyBindingsManager.addAction(null, stub);
    }

    @Override
    public synchronized void removeGlobalAction(DockingActionIf action) {
        action.removePropertyChangeListener(this);
        this.removeAction(action);
        this.actionGuiHelper.removeToolAction(action);
        this.dispose(action);
    }

    private void dispose(DockingActionIf action) {
        try {
            action.dispose();
        }
        catch (Throwable t) {
            Msg.error((Object)this, (Object)("Exception disposing action '" + action.getFullName() + "'"), (Throwable)t);
        }
    }

    @Override
    public synchronized void removeActions(String owner) {
        Map<String, Set<DockingActionIf>> toCleanup = this.actionsByNameByOwner.remove(owner);
        if (toCleanup == null) {
            return;
        }
        toCleanup.values().stream().flatMap(set -> set.stream()).forEach(action -> this.removeGlobalAction((DockingActionIf)action));
    }

    private void checkForAlreadyAddedAction(ComponentProvider provider, DockingActionIf action) {
        if (this.getActionStorage(action).contains(action)) {
            String providerString = provider == null ? "Action: " : "Provider " + provider.getName() + " - action: ";
            throw new AssertException("Cannot add the same action more than once. " + providerString + action.getFullName());
        }
    }

    @Override
    public synchronized Set<DockingActionIf> getActions(String owner) {
        HashSet<DockingActionIf> result = new HashSet<DockingActionIf>();
        Map<String, Set<DockingActionIf>> actionsByName = this.actionsByNameByOwner.get(owner);
        for (Set<DockingActionIf> actions : actionsByName.values()) {
            result.addAll(actions);
        }
        Collection<SharedStubKeyBindingAction> values = this.sharedActionMap.values();
        for (SharedStubKeyBindingAction stub : values) {
            String stubOwner = stub.getOwner();
            if (!stubOwner.equals(owner)) continue;
            result.add(stub);
        }
        return result;
    }

    @Override
    public synchronized Set<DockingActionIf> getAllActions() {
        HashSet<DockingActionIf> result = new HashSet<DockingActionIf>();
        Collection<Map<String, Set<DockingActionIf>>> maps = this.actionsByNameByOwner.values();
        for (Map<String, Set<DockingActionIf>> actionsByName : maps) {
            for (Set<DockingActionIf> actions : actionsByName.values()) {
                result.addAll(actions);
            }
        }
        result.addAll(this.sharedActionMap.values());
        return result;
    }

    private Iterator<DockingActionIf> getAllActionsIterator() {
        Object iterator = IteratorUtils.emptyIterator();
        Collection<Map<String, Set<DockingActionIf>>> maps = this.actionsByNameByOwner.values();
        for (Map<String, Set<DockingActionIf>> actionsByName : maps) {
            for (Set<DockingActionIf> actions : actionsByName.values()) {
                Iterator<DockingActionIf> next = actions.iterator();
                iterator = Iterators.concat((Iterator)iterator, next);
            }
        }
        return Iterators.concat((Iterator)iterator, this.sharedActionMap.values().iterator());
    }

    public synchronized void restoreKeyBindings() {
        this.keyBindingOptions = this.dockingTool.getOptions("Key Bindings");
        Iterator<DockingActionIf> it = this.getKeyBindingActionsIterator();
        for (DockingActionIf action : CollectionUtils.asIterable(it)) {
            KeyStroke newKs;
            KeyStroke ks = action.getKeyBinding();
            if (Objects.equals(ks, newKs = this.keyBindingOptions.getKeyStroke(action.getFullName(), ks))) continue;
            action.setUnvalidatedKeyBindingData(new KeyBindingData(newKs));
        }
    }

    private Iterator<DockingActionIf> getKeyBindingActionsIterator() {
        Predicate filter = a -> a.getKeyBindingType() == KeyBindingType.INDIVIDUAL;
        return IteratorUtils.filteredIterator(this.getAllActionsIterator(), (Predicate)filter);
    }

    @Override
    public synchronized void removeLocalAction(ComponentProvider provider, DockingActionIf action) {
        action.removePropertyChangeListener(this);
        this.removeAction(action);
        this.keyBindingsManager.removeAction(action);
        this.actionGuiHelper.removeProviderAction(provider, action);
        this.dispose(action);
    }

    @Override
    public synchronized void removeActions(ComponentProvider provider) {
        Iterator<DockingActionIf> it = this.actionGuiHelper.getComponentActions(provider);
        Set set = CollectionUtils.asSet(it);
        for (DockingActionIf action : set) {
            this.removeLocalAction(provider, action);
        }
    }

    private void removeAction(DockingActionIf action) {
        this.keyBindingsManager.removeAction(action);
        this.getActionStorage(action).remove(action);
        if (!action.getKeyBindingType().isShared()) {
            return;
        }
        SharedStubKeyBindingAction stub = this.sharedActionMap.get(action.getName());
        if (stub != null) {
            stub.removeClientAction(action);
        }
    }

    private Set<DockingActionIf> getActionStorage(DockingActionIf action) {
        String owner = action.getOwner();
        String name = action.getName();
        return this.actionsByNameByOwner.get(owner).get(name);
    }

    private void updateKeyBindingsFromOptions(ToolOptions options, String optionName, KeyStroke newKs) {
        Matcher matcher = this.ACTION_NAME_PATTERN.matcher(optionName);
        matcher.find();
        String name = matcher.group(1);
        String owner = matcher.group(2);
        Set<DockingActionIf> actions = this.actionsByNameByOwner.get(owner).get(name);
        for (DockingActionIf action : actions) {
            KeyStroke oldKs = action.getKeyBinding();
            if (Objects.equals(oldKs, newKs)) continue;
            action.setUnvalidatedKeyBindingData(new KeyBindingData(newKs));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        KeyStroke currentKs;
        if (!evt.getPropertyName().equals("KeyBindings")) {
            return;
        }
        DockingActionIf action = (DockingActionIf)evt.getSource();
        if (!action.getKeyBindingType().isManaged()) {
            this.keyBindingsChanged();
            return;
        }
        KeyBindingData newKeyBindingData = (KeyBindingData)evt.getNewValue();
        KeyStroke newKs = null;
        if (newKeyBindingData != null) {
            newKs = newKeyBindingData.getKeyBinding();
        }
        if (!Objects.equals(currentKs = this.keyBindingOptions.getKeyStroke(action.getFullName(), null), newKs)) {
            this.keyBindingOptions.setKeyStroke(action.getFullName(), newKs);
            this.keyBindingsChanged();
        }
    }

    private void keyBindingsChanged() {
        this.dockingTool.setConfigChanged(true);
        this.actionGuiHelper.keyBindingsChanged();
    }

    @Override
    public DockingActionIf getLocalAction(ComponentProvider provider, String actionName) {
        Iterator<DockingActionIf> it = this.actionGuiHelper.getComponentActions(provider);
        while (it.hasNext()) {
            DockingActionIf action = it.next();
            if (!action.getName().equals(actionName)) continue;
            return action;
        }
        return null;
    }

    public Action getAction(KeyStroke ks) {
        return this.keyBindingsManager.getDockingKeyAction(ks);
    }

    DockingActionIf getSharedStubKeyBindingAction(String name) {
        return this.sharedActionMap.get(name);
    }

    @Override
    public void registerSharedActionPlaceholder(SharedDockingActionPlaceholder placeholder) {
        String name = placeholder.getName();
        KeyStroke defaultKeyStroke = placeholder.getKeyBinding();
        SharedStubKeyBindingAction stub = this.sharedActionMap.computeIfAbsent(name, key -> {
            SharedStubKeyBindingAction newStub = new SharedStubKeyBindingAction(name, defaultKeyStroke, this.keyBindingOptions);
            this.registerStub(newStub, defaultKeyStroke);
            return newStub;
        });
        String owner = placeholder.getOwner();
        stub.addActionOwner(owner);
    }
}

