/*
 * Decompiled with CFR 0.152.
 */
package docking.framework;

import docking.DockingFrame;
import docking.DockingWindowManager;
import docking.HiddenDockingFrame;
import docking.framework.ApplicationInformationDisplayFactory;
import docking.framework.DockingApplicationConfiguration;
import docking.framework.DockingApplicationLayout;
import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import generic.util.WindowUtilities;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.util.Msg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.Timer;
import javax.swing.UIManager;
import utility.application.ApplicationLayout;

public class SplashScreen
extends JWindow {
    private static final Color DEFAULT_BACKGROUND_COLOR = new Color(243, 250, 255);
    private static SplashScreen splashWindow;
    private static JFrame hiddenFrame;
    private static JLabel statusLabel;
    private static Timer hideSplashWindowTimer;

    public static SplashScreen showSplashScreen() {
        if (splashWindow != null) {
            return splashWindow;
        }
        JFrame parentFrame = SplashScreen.getParentFrame();
        splashWindow = new SplashScreen(parentFrame);
        SplashScreen.initializeSplashWindowAndParent(parentFrame);
        SplashScreen.createSplashScreenCloseListeners(parentFrame);
        parentFrame.setVisible(true);
        splashWindow.setVisible(true);
        splashWindow.repaint();
        return splashWindow;
    }

    private static void initializeSplashWindowAndParent(final JFrame parentFrame) {
        Dimension wd = splashWindow.getPreferredSize();
        Point point = WindowUtilities.centerOnScreen((Dimension)wd);
        splashWindow.setLocation(point);
        parentFrame.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                if (splashWindow == null) {
                    return;
                }
                Point newPoint = WindowUtilities.centerOnComponent((Component)parentFrame, (Component)splashWindow);
                splashWindow.setLocation(newPoint);
            }
        });
        Point framePoint = WindowUtilities.centerOnComponent((Component)splashWindow, (Component)parentFrame);
        parentFrame.setBounds(new Rectangle(framePoint.x, framePoint.y, 0, 0));
        parentFrame.setResizable(false);
    }

    private static void createSplashScreenCloseListeners(final JFrame parentFrame) {
        hideSplashWindowTimer = new Timer(500, null);
        ActionListener timerListener = e -> {
            Msg.trace(SplashScreen.class, (Object)"Splash Screen - hide timer activated");
            if (SplashScreen.isApplicationVisible()) {
                Msg.trace(SplashScreen.class, (Object)"Splash Screen closed due to application launch");
                SplashScreen.disposeSplashScreen();
                hideSplashWindowTimer.stop();
            }
            if (SplashScreen.hiddenWindowHasModalChildren()) {
                Msg.trace(SplashScreen.class, (Object)"Splash Screen has modal children--not closing");
                return;
            }
            if (SplashScreen.nonHiddenFrameExists()) {
                Msg.trace(SplashScreen.class, (Object)"Splash Screen closed due to non-docking application launch");
                SplashScreen.disposeSplashScreen();
                hideSplashWindowTimer.stop();
            }
        };
        hideSplashWindowTimer.addActionListener(timerListener);
        hideSplashWindowTimer.setRepeats(true);
        hideSplashWindowTimer.start();
        parentFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent e) {
                Msg.trace(SplashScreen.class, (Object)("Splash Screen - parent window deactivated.  Parent: " + SplashScreen.getTitle(parentFrame)));
                if (SplashScreen.hiddenWindowHasModalChildren()) {
                    Msg.trace(SplashScreen.class, (Object)"Splash Screen has modal children--not closing");
                    return;
                }
                Window window = e.getOppositeWindow();
                if (window != null) {
                    Msg.trace(SplashScreen.class, (Object)("Splash Screen new non-splash window showing--closing. Window: " + SplashScreen.getTitle(window)));
                    SplashScreen.disposeSplashScreen();
                }
            }
        });
    }

    private static String getTitle(Window window) {
        if (window instanceof JDialog) {
            return ((JDialog)window).getTitle() + " - id: " + System.identityHashCode(window);
        }
        if (window instanceof JFrame) {
            return ((JFrame)window).getTitle() + " - id: " + System.identityHashCode(window);
        }
        return "<No Title> - id: " + System.identityHashCode(window);
    }

    private static boolean isApplicationVisible() {
        List<DockingWindowManager> windowManagers = DockingWindowManager.getAllDockingWindowManagers();
        for (DockingWindowManager manager : windowManagers) {
            JFrame frame = manager.getRootFrame();
            if (!frame.isShowing()) continue;
            return true;
        }
        return false;
    }

    private static boolean nonHiddenFrameExists() {
        Frame[] frames;
        for (Frame frame : frames = Frame.getFrames()) {
            if (frame instanceof HiddenDockingFrame || frame == hiddenFrame || !frame.isShowing()) continue;
            Msg.trace(SplashScreen.class, (Object)("Splash Screen found non-hidden frame: : " + SplashScreen.getTitle(frame)));
            return true;
        }
        return false;
    }

    private static boolean hiddenWindowHasModalChildren() {
        if (hiddenFrame == null) {
            return false;
        }
        List modals = WindowUtilities.getOpenModalDialogsFor((Frame)hiddenFrame);
        if (modals.isEmpty()) {
            return false;
        }
        modals.forEach(d -> d.setAlwaysOnTop(true));
        return true;
    }

    private static void closeSplashScreen() {
        if (splashWindow != null) {
            splashWindow.setVisible(false);
            splashWindow.dispose();
            splashWindow = null;
        }
    }

    private SplashScreen(JFrame parent) {
        super(parent);
        this.getContentPane().add(this.createMainPanel());
        this.pack();
    }

    private static synchronized JFrame getParentFrame() {
        if (hiddenFrame == null) {
            hiddenFrame = new DockingFrame(Application.getName());
            List<Image> list = ApplicationInformationDisplayFactory.getWindowIcons();
            hiddenFrame.setIconImages(list);
            hiddenFrame.setUndecorated(true);
        }
        return hiddenFrame;
    }

    public static void disposeSplashScreen() {
        hideSplashWindowTimer.stop();
        SplashScreen.closeSplashScreen();
        if (hiddenFrame != null) {
            hiddenFrame.setVisible(false);
            hiddenFrame.dispose();
            hiddenFrame = null;
        }
    }

    public static void updateSplashScreenStatus(String status) {
        if (splashWindow == null) {
            return;
        }
        SplashScreen.updateStatus(status);
    }

    private static void updateStatus(String status) {
        statusLabel.setText(status);
    }

    private JPanel createMainPanel() {
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setBackground(DEFAULT_BACKGROUND_COLOR);
        mainPanel.add(this.createTitlePanel(), "North");
        mainPanel.add(this.createContentPanel(), "Center");
        return mainPanel;
    }

    private Component createContentPanel() {
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createBevelBorder(0));
        contentPanel.add((Component)this.createInfoComponent(), "Center");
        contentPanel.add(this.createStatusComponent(), "South");
        return contentPanel;
    }

    private Component createTitlePanel() {
        Color backgroundColor = UIManager.getColor("InternalFrame.activeTitleBackground");
        Color foregroundColor = UIManager.getColor("InternalFrame.activeTitleForeground");
        JPanel titlePanel = new JPanel();
        if (backgroundColor == null) {
            backgroundColor = new Color(0, 0, 255);
        }
        titlePanel.setBackground(backgroundColor);
        titlePanel.setLayout(new BorderLayout());
        GLabel titleLabel = new GLabel(ApplicationInformationDisplayFactory.createSplashScreenTitle());
        Font font = titleLabel.getFont();
        font = new Font(font.getName(), 1, 11);
        titleLabel.setFont(font);
        if (foregroundColor == null) {
            foregroundColor = Color.white;
        }
        titleLabel.setForeground(foregroundColor);
        titlePanel.add((Component)titleLabel, "Center");
        titlePanel.setBorder(BorderFactory.createEmptyBorder(2, 10, 2, 10));
        return titlePanel;
    }

    private Component createStatusComponent() {
        Font f = new Font("serif", 1, 12);
        statusLabel = new GDLabel(" Loading...");
        statusLabel.setFont(f);
        statusLabel.setBorder(BorderFactory.createEmptyBorder(0, 10, 2, 10));
        statusLabel.setBackground(DEFAULT_BACKGROUND_COLOR);
        statusLabel.setOpaque(true);
        return statusLabel;
    }

    private JComponent createInfoComponent() {
        return ApplicationInformationDisplayFactory.createSplashScreenComponent();
    }

    public static void main(String[] args) throws Exception {
        DockingApplicationLayout layout = new DockingApplicationLayout("Splash Screen Main", "1.0");
        DockingApplicationConfiguration config = new DockingApplicationConfiguration();
        config.setShowSplashScreen(false);
        Application.initializeApplication((ApplicationLayout)layout, (ApplicationConfiguration)config);
        SplashScreen.showSplashScreen();
        new Thread(new Runnable(){
            String[] messages = new String[]{"Hi mom...", "This is a much longer message to test that we get resized correctly", "I!", "Here we go again..."};

            @Override
            public void run() {
                for (int i = 0; i < 100; ++i) {
                    int index = i % this.messages.length;
                    SplashScreen.updateStatus(this.messages[index]);
                    try {
                        Thread.sleep(100 * index);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }).start();
    }
}

