/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.dialogs;

import docking.DialogComponentProvider;
import docking.widgets.table.GFilterTable;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;

public class TableChooserDialog<T>
extends DialogComponentProvider {
    private RowObjectTableModel<T> model;
    private GFilterTable<T> gFilterTable;
    private List<T> selectedItems;

    public TableChooserDialog(String title, RowObjectTableModel<T> model, boolean allowMultipleSelection) {
        super(title);
        this.model = model;
        this.addWorkPanel(this.buildTable(allowMultipleSelection));
        this.addOKButton();
        this.addCancelButton();
    }

    public List<T> getSelectionItems() {
        return this.selectedItems;
    }

    private void initializeTable(boolean allowMultipleSelection) {
        GTable table = this.gFilterTable.getTable();
        table.setAutoResizeMode(3);
        int selectionMode = allowMultipleSelection ? 2 : 0;
        table.getSelectionModel().setSelectionMode(selectionMode);
    }

    protected void processMouseClicked(MouseEvent e) {
        if (e.getClickCount() != 2) {
            return;
        }
        int rowAtPoint = this.gFilterTable.getTable().rowAtPoint(e.getPoint());
        if (rowAtPoint < 0) {
            return;
        }
        T selectedRowObject = this.gFilterTable.getSelectedRowObject();
        this.selectedItems = Arrays.asList(selectedRowObject);
        this.close();
    }

    @Override
    protected void okCallback() {
        this.selectedItems = this.gFilterTable.getSelectedRowObjects();
        this.close();
    }

    @Override
    protected void cancelCallback() {
        this.selectedItems = null;
        this.close();
    }

    @Override
    protected void dialogShown() {
        this.gFilterTable.focusFilter();
    }

    private JComponent buildTable(boolean allowMultipleSelection) {
        this.gFilterTable = new GFilterTable<T>(this.model);
        this.initializeTable(allowMultipleSelection);
        this.gFilterTable.getTable().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!e.isShiftDown()) {
                    TableChooserDialog.this.processMouseClicked(e);
                }
                TableChooserDialog.this.updateOkEnabled();
            }
        });
        this.setOkEnabled(false);
        return this.gFilterTable;
    }

    protected void updateOkEnabled() {
        this.setOkEnabled(this.gFilterTable.getSelectedRowObject() != null);
    }
}

