/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table.threaded;

import docking.widgets.table.threaded.IncrementalJobListener;
import docking.widgets.table.threaded.ThreadedTableModel;
import docking.widgets.table.threaded.ThreadedTableModelListener;
import docking.widgets.table.threaded.ThreadedTableModelUpdateMgr;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.datastruct.SynchronizedListAccumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.SwingUpdateManager;
import ghidra.util.task.TaskMonitor;
import ghidra.util.worker.Job;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class IncrementalLoadJob<ROW_OBJECT>
extends Job
implements ThreadedTableModelListener {
    private final IncrementalJobListener listener;
    private final ThreadedTableModel<ROW_OBJECT, ?> threadedModel;
    private final ThreadedTableModelUpdateMgr<ROW_OBJECT> updateManager;
    private final CountDownLatch completedCallbackLatch = new CountDownLatch(1);
    private volatile IncrementalUpdatingAccumulator incrementalAccumulator;

    IncrementalLoadJob(ThreadedTableModel<ROW_OBJECT, ?> threadedModel, IncrementalJobListener listener) {
        this.threadedModel = threadedModel;
        this.listener = listener;
        this.updateManager = threadedModel.getUpdateManager();
        this.incrementalAccumulator = new IncrementalUpdatingAccumulator();
    }

    public void run(TaskMonitor monitor) {
        block2: {
            this.notifyStarted(monitor);
            try {
                this.doExecute(monitor);
            }
            catch (Exception e) {
                if (ExceptionUtils.hasCause((Throwable)e, InterruptedException.class)) break block2;
                String name = this.threadedModel.getName();
                Msg.showError((Object)this, null, (String)"Unexpected Exception", (Object)("Unexpected exception loading table model \"" + name + "\""), (Throwable)e);
            }
        }
        boolean interrupted = Thread.currentThread().isInterrupted();
        this.notifyCompleted(monitor.isCancelled() || interrupted);
    }

    private void doExecute(TaskMonitor monitor) {
        try {
            this.threadedModel.doLoad((Accumulator<ROW_OBJECT>)this.incrementalAccumulator, monitor);
            if (!monitor.isCancelled()) {
                this.flush(this.incrementalAccumulator);
            }
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
        if (monitor.isCancelled()) {
            return;
        }
        this.waitForThreadedTableUpdateManager();
    }

    private void waitForThreadedTableUpdateManager() {
        try {
            this.completedCallbackLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(IncrementalUpdatingAccumulator accumulator) {
        Object object = this.updateManager.getSynchronizingLock();
        synchronized (object) {
            accumulator.flushData();
            SwingUtilities.invokeLater(() -> this.updateManager.addThreadedTableListener(this));
        }
    }

    private void notifyStarted(TaskMonitor monitor) {
        if (this.listener != null) {
            SystemUtilities.runIfSwingOrPostSwingLater(() -> this.listener.loadingStarted());
        }
    }

    private void notifyCompleted(boolean wasCancelled) {
        if (this.listener != null) {
            SystemUtilities.runIfSwingOrPostSwingLater(() -> this.listener.loadingFinished(wasCancelled));
        }
        this.updateManager.removeThreadedTableListener(this);
    }

    public void cancel() {
        this.updateManager.getTaskMonitor().cancel();
        this.incrementalAccumulator.cancel();
    }

    @Override
    public void loadPending() {
    }

    @Override
    public void loadingStarted() {
    }

    @Override
    public void loadingFinished(boolean wasCancelled) {
        this.completedCallbackLatch.countDown();
    }

    private class IncrementalUpdatingAccumulator
    extends SynchronizedListAccumulator<ROW_OBJECT> {
        private volatile boolean cancelledOrDone;
        private Runnable runnable = () -> {
            if (this.cancelledOrDone) {
                return;
            }
            IncrementalLoadJob.this.updateManager.reloadSpecificData(this.asList());
        };
        private SwingUpdateManager swingUpdateManager;

        private IncrementalUpdatingAccumulator() {
            this.swingUpdateManager = new SwingUpdateManager((int)IncrementalLoadJob.this.threadedModel.getMinDelay(), (int)IncrementalLoadJob.this.threadedModel.getMaxDelay(), "Incremental Table Load Update", this.runnable);
        }

        public synchronized void add(ROW_OBJECT t) {
            super.add(t);
            this.swingUpdateManager.update();
        }

        void cancel() {
            this.cancelledOrDone = true;
            this.swingUpdateManager.dispose();
        }

        public synchronized void addAll(Collection<ROW_OBJECT> collection) {
            super.addAll(collection);
            if (collection.size() > 0) {
                this.swingUpdateManager.update();
            }
        }

        void flushData() {
            this.cancelledOrDone = true;
            this.swingUpdateManager.dispose();
            IncrementalLoadJob.this.updateManager.reloadSpecificData(this.asList());
        }
    }
}

