/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.textfield;

import docking.widgets.textfield.IntegerFormatter;
import ghidra.util.NumericUtilities;
import java.text.Format;
import java.text.ParseException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.DocumentFilter;

public class HexIntegerFormatter
extends IntegerFormatter {
    public HexIntegerFormatter() {
        this.setValueClass(Long.class);
    }

    @Override
    protected DocumentFilter createDocumentFilter() {
        return new HexAllowedPositiveValueIntgerDocumentFilterWrapper(this.getFormat(), this.getOriginalDocumentFilter());
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        Long asLong = null;
        try {
            asLong = NumericUtilities.parseHexLong((String)text);
        }
        catch (NumberFormatException nfe) {
            ParseException parseException = new ParseException("Cannot parse string to a long: \"" + text + "\"", 0);
            parseException.initCause(nfe);
            throw parseException;
        }
        return super.stringToValue(asLong.toString());
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        String valueString = super.valueToString(value);
        if ("".equals(valueString)) {
            return valueString;
        }
        return Long.toHexString(Long.valueOf(valueString));
    }

    protected static class HexAllowedPositiveValueIntgerDocumentFilterWrapper
    extends IntegerFormatter.PosiviteValueIntegerDocumentFilterWrapper {
        private Set<Character> hexCharacterSet = new HashSet<Character>();

        HexAllowedPositiveValueIntgerDocumentFilterWrapper(Format format, DocumentFilter wrappedFilter) {
            super(format, wrappedFilter);
            this.hexCharacterSet.add(Character.valueOf('a'));
            this.hexCharacterSet.add(Character.valueOf('A'));
            this.hexCharacterSet.add(Character.valueOf('b'));
            this.hexCharacterSet.add(Character.valueOf('B'));
            this.hexCharacterSet.add(Character.valueOf('c'));
            this.hexCharacterSet.add(Character.valueOf('C'));
            this.hexCharacterSet.add(Character.valueOf('d'));
            this.hexCharacterSet.add(Character.valueOf('D'));
            this.hexCharacterSet.add(Character.valueOf('e'));
            this.hexCharacterSet.add(Character.valueOf('E'));
            this.hexCharacterSet.add(Character.valueOf('f'));
            this.hexCharacterSet.add(Character.valueOf('F'));
        }

        @Override
        protected boolean isDigit(char character) {
            if (super.isDigit(character)) {
                return true;
            }
            return this.hexCharacterSet.contains(Character.valueOf(character));
        }

        @Override
        protected Number parseText(String text) {
            try {
                return Long.parseLong(text, 16);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
    }
}

