/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.Field;
import db.LongField;
import db.OpenMode;
import db.Record;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import ghidra.feature.vt.api.db.VTMatchTagDBAdapterV0;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.LinkedList;

public abstract class VTMatchTagDBAdapter {
    static String TABLE_NAME = "MatchTagTable";
    static Schema TABLE_SCHEMA = new Schema(0, LongField.class, "Key", (Class[])ColumnDescription.getColumnClasses(), ColumnDescription.getColumnNames());

    static VTMatchTagDBAdapter createAdapter(DBHandle dbHandle) throws IOException {
        return new VTMatchTagDBAdapterV0(dbHandle);
    }

    static VTMatchTagDBAdapter getAdapter(DBHandle dbHandle, OpenMode openMode, TaskMonitor monitor) throws VersionException {
        return new VTMatchTagDBAdapterV0(dbHandle, openMode, monitor);
    }

    public abstract Record insertRecord(String var1) throws IOException;

    public abstract RecordIterator getRecords() throws IOException;

    abstract Record getRecord(long var1) throws IOException;

    abstract int getRecordCount();

    abstract void updateRecord(Record var1) throws IOException;

    abstract boolean deleteRecord(long var1) throws IOException;

    public static enum ColumnDescription {
        TAG_NAME_COL(StringField.class);

        private final Class<? extends Field> columnClass;

        private ColumnDescription(Class<? extends Field> columnClass) {
            this.columnClass = columnClass;
        }

        public Class<? extends Field> getColumnClass() {
            return this.columnClass;
        }

        public int column() {
            return this.ordinal();
        }

        private static String[] getColumnNames() {
            ColumnDescription[] columns = ColumnDescription.values();
            LinkedList<String> list = new LinkedList<String>();
            for (ColumnDescription column : columns) {
                list.add(column.name());
            }
            return list.toArray(new String[columns.length]);
        }

        private static Class<? extends Field>[] getColumnClasses() {
            ColumnDescription[] columns = ColumnDescription.values();
            LinkedList<Class<? extends Field>> list = new LinkedList<Class<? extends Field>>();
            for (ColumnDescription column : columns) {
                list.add(column.getColumnClass());
            }
            return list.toArray(new Class[columns.length]);
        }
    }
}

