/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.WString;

public class StringBlock
extends Memory {
    private boolean wide;

    public StringBlock(String[] strings) {
        this(strings, false);
    }

    public StringBlock(String[] strings, boolean wide) {
        this((Object[])strings, wide);
    }

    public StringBlock(WString[] strings) {
        this(strings, true);
    }

    private StringBlock(Object[] strings, boolean wide) {
        super(StringBlock.calculateLength(strings, wide));
        this.wide = wide;
        int offset = 0;
        for (int i = 0; i < strings.length; ++i) {
            if (strings[i] == null) continue;
            this.setString(offset, strings[i].toString(), wide);
            offset = wide ? (offset += strings[i].toString().length() * Native.WCHAR_SIZE) : (offset += strings[i].toString().getBytes().length);
            this.setString(offset, "\u0000", wide);
            if (wide) {
                offset += Native.WCHAR_SIZE;
                continue;
            }
            ++offset;
        }
        this.setByte(offset, (byte)0);
        if (wide) {
            this.setByte(offset + 1, (byte)0);
        }
    }

    private static long calculateLength(Object[] strings, boolean wide) {
        int result = 0;
        if (wide) {
            for (Object string : strings) {
                result += (string.toString().length() + 1) * Native.WCHAR_SIZE;
            }
            result += Native.WCHAR_SIZE;
        } else {
            for (Object string : strings) {
                result += string.toString().getBytes().length + 1;
            }
            ++result;
        }
        return result;
    }
}

