/*
 * Decompiled with CFR 0.152.
 */
package functioncalls.plugin;

import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import docking.ActionContext;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.action.ToggleDockingAction;
import docking.action.ToolBarData;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import docking.widgets.OptionDialog;
import functioncalls.graph.FcgDirection;
import functioncalls.graph.FcgEdge;
import functioncalls.graph.FcgLevel;
import functioncalls.graph.FcgVertex;
import functioncalls.graph.FcgVertexExpansionListener;
import functioncalls.graph.FunctionCallGraph;
import functioncalls.graph.job.BowTieExpandVerticesJob;
import functioncalls.graph.job.FcgEmphasizeEdgesJob;
import functioncalls.graph.job.FcgExpandingVertexCollection;
import functioncalls.graph.layout.BowTieLayoutProvider;
import functioncalls.graph.renderer.FcgTooltipProvider;
import functioncalls.graph.view.FcgComponent;
import functioncalls.graph.view.FcgView;
import functioncalls.plugin.FcgData;
import functioncalls.plugin.FcgDataFactory;
import functioncalls.plugin.FunctionCallGraphPlugin;
import functioncalls.plugin.FunctionEdge;
import functioncalls.plugin.FunctionEdgeCache;
import ghidra.app.context.NavigationActionContext;
import ghidra.graph.VisualGraph;
import ghidra.graph.VisualGraphComponentProvider;
import ghidra.graph.job.GraphJob;
import ghidra.graph.viewer.GraphPerspectiveInfo;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualGraphViewUpdater;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.actions.VgVertexContext;
import ghidra.graph.viewer.event.mouse.VertexMouseInfo;
import ghidra.graph.viewer.layout.JungLayoutProviderFactory;
import ghidra.graph.viewer.layout.LayoutProvider;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.graph.viewer.vertex.VertexClickListener;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionManager;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.apache.commons.collections4.IterableUtils;
import resources.Icons;
import util.CollectionUtils;

public class FcgProvider
extends VisualGraphComponentProvider<FcgVertex, FcgEdge, FunctionCallGraph> {
    public static final int MAX_REFERENCES = 100;
    private static final String TOOLBAR_GROUP_A = "A";
    private static final String TOOLBAR_GROUP_B = "B";
    private static final String MENU_GROUP_EXPAND = "A";
    private static final String MENU_GROUP_GRAPH = "B";
    private static final String NAME = "Function Call Graph";
    private JComponent component;
    private FunctionCallGraphPlugin plugin;
    private FcgView view;
    private LayoutProvider<FcgVertex, FcgEdge, FunctionCallGraph> defaultLayoutProvider = new BowTieLayoutProvider();
    private LayoutProvider<FcgVertex, FcgEdge, FunctionCallGraph> layoutProvider;
    private Set<LayoutProvider<FcgVertex, FcgEdge, FunctionCallGraph>> layouts = new HashSet<LayoutProvider<FcgVertex, FcgEdge, FunctionCallGraph>>();
    private FcgDataFactory dataFactory;
    private FcgData graphData;
    private FcgVertexExpansionListener expansionListener = new ExpansionListener();
    private Predicate<FcgEdge> unfiltered = v -> true;
    private Predicate<FcgEdge> edgeNotInGraphFilter = e -> !this.graphData.getGraph().containsEdge(e);
    private Predicate<FcgVertex> vertexInGraphFilter = v -> this.graphData.getGraph().containsVertex(v);
    private ToggleDockingAction navigateIncomingToggleAction;
    static final String RELAYOUT_GRAPH_ACTION_NAME = "Relayout Graph";

    public FcgProvider(Tool tool, FunctionCallGraphPlugin plugin) {
        super(tool, NAME, plugin.getName());
        this.plugin = plugin;
        this.dataFactory = new FcgDataFactory((RemovalListener<Function, FcgData>)((RemovalListener)this::graphDataCacheRemoved));
        this.graphData = this.dataFactory.create(null);
        this.buildComponent();
        this.setWindowMenuGroup(NAME);
        this.setWindowGroup(NAME);
        this.setDefaultWindowPosition(WindowPosition.WINDOW);
        this.setHelpLocation(FunctionCallGraphPlugin.DEFAULT_HELP);
        this.addToTool();
        this.addSatelliteFeature();
        this.createLayouts();
        this.createActions();
    }

    public FcgView getView() {
        return this.view;
    }

    public void componentShown() {
        this.installGraph();
    }

    void locationChanged(ProgramLocation loc) {
        if (!this.navigateIncomingToggleAction.isSelected()) {
            return;
        }
        if (loc == null) {
            this.setFunction(null);
            return;
        }
        Program p = loc.getProgram();
        FunctionManager fm = p.getFunctionManager();
        Function f = fm.getFunctionContaining(loc.getAddress());
        this.setFunction(f);
    }

    void setFunction(Function f) {
        if (this.graphData.isFunction(f)) {
            return;
        }
        this.saveCurrentGraphPerspective();
        this.createAndInstallGraph(f);
        this.updateTitle();
    }

    private void saveCurrentGraphPerspective() {
        if (!this.isVisible()) {
            return;
        }
        if (!this.graphData.hasResults()) {
            return;
        }
        GraphPerspectiveInfo info = this.view.generateGraphPerspective();
        this.graphData.setGraphPerspective((GraphPerspectiveInfo<FcgVertex, FcgEdge>)info);
    }

    private void updateTitle() {
        this.setTitle(NAME);
        String subTitle = null;
        if (this.graphData.hasResults()) {
            FunctionCallGraph graph = this.graphData.getGraph();
            subTitle = this.graphData.getFunction().getName() + " (" + graph.getVertexCount() + " functions; " + graph.getEdgeCount() + " edges)";
        }
        this.setSubTitle(subTitle);
    }

    private void rebuildCurrentGraph() {
        if (!this.graphData.hasResults()) {
            return;
        }
        Function function = this.graphData.getFunction();
        this.dataFactory.remove(function);
        this.createAndInstallGraph(function);
    }

    private void createAndInstallGraph(Function function) {
        this.graphData = this.dataFactory.create(function);
        if (!this.isVisible()) {
            return;
        }
        this.installGraph();
    }

    private void installGraph() {
        if (!this.graphData.hasResults()) {
            Address address = this.plugin.getCurrentAddress();
            if (address == null) {
                this.view.showErrorView("No function selected ");
            } else {
                this.view.showErrorView("No function containing " + address);
            }
            return;
        }
        if (this.graphData.isInitialized()) {
            this.view.setGraph((VisualGraph)this.graphData.getGraph());
            this.view.setGraphPerspective(this.graphData.getGraphPerspective());
            return;
        }
        FunctionCallGraph graph = this.graphData.getGraph();
        this.setLayout(graph);
        FcgLevel source = FcgLevel.sourceLevel();
        FcgVertex sourceVertex = new FcgVertex(this.graphData.getFunction(), source, this.expansionListener);
        graph.setSource(sourceVertex);
        this.trackFunctionEdges(sourceVertex);
        this.view.setGraph((VisualGraph)graph);
        FcgComponent gc = this.view.getGraphComponent();
        gc.setVertexFocused((VisualVertex)sourceVertex);
        if (sourceVertex.canExpandIncomingReferences()) {
            this.expand(sourceVertex, FcgDirection.IN);
        }
        if (sourceVertex.canExpandOutgoingReferences()) {
            this.expand(sourceVertex, FcgDirection.OUT);
        }
    }

    private FcgVertex getOrCreateVertex(Function f, FcgLevel level) {
        FunctionCallGraph graph = this.graphData.getGraph();
        FcgVertex v = graph.getVertex(f);
        if (v != null) {
            return v;
        }
        v = new FcgVertex(f, level, this.expansionListener);
        this.trackFunctionEdges(v);
        return v;
    }

    private void graphDataCacheRemoved(RemovalNotification<Function, FcgData> notification) {
        FcgData data = (FcgData)notification.getValue();
        data.dispose();
    }

    private void setLayout(FunctionCallGraph g) {
        try {
            VisualGraphLayout layout = this.layoutProvider.getLayout((VisualGraph)g, TaskMonitor.DUMMY);
            g.setLayout((VisualGraphLayout<FcgVertex, FcgEdge>)layout);
            this.view.setLayoutProvider(this.layoutProvider);
        }
        catch (CancelledException cancelledException) {
            // empty catch block
        }
    }

    private void buildComponent() {
        this.view = new FcgView();
        this.view.setVertexClickListener((v, info) -> {
            if (!this.isNavigatbleArea((VertexMouseInfo<FcgVertex, FcgEdge>)info)) {
                return false;
            }
            Function f = v.getFunction();
            Address entry = f.getEntryPoint();
            Program p = f.getProgram();
            this.plugin.handleProviderLocationChanged(new ProgramLocation(p, entry));
            return true;
        });
        this.view.setTooltipProvider(new FcgTooltipProvider());
        JComponent viewComponent = this.view.getViewComponent();
        this.component = new JPanel(new BorderLayout());
        this.component.add((Component)viewComponent, "Center");
    }

    private boolean isNavigatbleArea(VertexMouseInfo<FcgVertex, FcgEdge> info) {
        Component clickedComponent = info.getClickedComponent();
        if (clickedComponent instanceof JButton) {
            return false;
        }
        int buffer = 10;
        MouseEvent e = info.getTranslatedMouseEvent();
        Point p = e.getPoint();
        if (p.x < buffer || p.y < buffer) {
            return false;
        }
        Rectangle bounds = clickedComponent.getBounds();
        return bounds.width - p.x >= buffer && bounds.height - p.y >= buffer;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public void dispose() {
        this.dataFactory.dispose();
        this.graphData.dispose();
        super.dispose();
    }

    public Class<?> getContextType() {
        return NavigationActionContext.class;
    }

    FunctionCallGraph getGraph() {
        if (this.graphData.hasResults()) {
            return this.graphData.getGraph();
        }
        return null;
    }

    void setVertexClickListener(VertexClickListener<FcgVertex, FcgEdge> l) {
        this.view.setVertexClickListener(l);
    }

    private void createLayouts() {
        this.layouts.addAll(JungLayoutProviderFactory.createLayouts());
        this.layouts.add(this.defaultLayoutProvider);
        this.layoutProvider = this.defaultLayoutProvider;
    }

    private void createActions() {
        this.addLayoutAction();
        CollapseAction collapseIn = new CollapseAction("Hide Incoming Edges", FcgDirection.IN);
        CollapseAction collapseOut = new CollapseAction("Hide Outgoing Edges", FcgDirection.OUT);
        ExpandAction expandIn = new ExpandAction("Show Incoming Edges", FcgDirection.IN);
        ExpandAction expandOut = new ExpandAction("Show Outgoing Edges", FcgDirection.OUT);
        CollapseLevelAction collapseLevelIn = new CollapseLevelAction("Hide Incoming Level Edges", FcgDirection.IN);
        CollapseLevelAction collapseLevelOut = new CollapseLevelAction("Hide Outgoing Level Edges", FcgDirection.OUT);
        ExpandLevelAction expandLevelIn = new ExpandLevelAction("Show Incoming Level Edges", FcgDirection.IN);
        ExpandLevelAction expandLevelOut = new ExpandLevelAction("Show Outgoing Level Edges", FcgDirection.OUT);
        this.addLocalAction((DockingActionIf)collapseIn);
        this.addLocalAction((DockingActionIf)collapseOut);
        this.addLocalAction((DockingActionIf)collapseLevelIn);
        this.addLocalAction((DockingActionIf)collapseLevelOut);
        this.addLocalAction((DockingActionIf)expandIn);
        this.addLocalAction((DockingActionIf)expandOut);
        this.addLocalAction((DockingActionIf)expandLevelIn);
        this.addLocalAction((DockingActionIf)expandLevelOut);
        this.navigateIncomingToggleAction = new ToggleDockingAction("Navigate on Incoming Location Changes", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
            }

            public void setSelected(boolean newValue) {
                super.setSelected(newValue);
                if (this.isSelected()) {
                    FcgProvider.this.locationChanged(FcgProvider.this.plugin.getCurrentLocation());
                }
            }
        };
        this.navigateIncomingToggleAction.setSelected(true);
        this.navigateIncomingToggleAction.setToolBarData(new ToolBarData((Icon)Icons.NAVIGATE_ON_INCOMING_EVENT_ICON, "A"));
        this.navigateIncomingToggleAction.setDescription(HTMLUtilities.toHTML((String)"Incoming Navigation<br><br>Toggle <b>On</b>  - change the graphed function on Listing navigation events<br>Toggled <b>Off</b> - don't change the graph on Listing navigation events"));
        this.navigateIncomingToggleAction.setHelpLocation(new HelpLocation(this.plugin.getName(), "Navigation_Incoming"));
        this.addLocalAction((DockingActionIf)this.navigateIncomingToggleAction);
        DockingAction graphFunctionAction = new DockingAction("Graph Node Function Calls", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                VgVertexContext<FcgVertex> vContext = FcgProvider.this.getVertexContext(context);
                FcgVertex v = (FcgVertex)vContext.getVertex();
                FcgProvider.this.setFunction(v.getFunction());
            }

            public boolean isEnabledForContext(ActionContext context) {
                Function graphedFunction;
                boolean isEnabled;
                VgVertexContext<FcgVertex> vContext = FcgProvider.this.getVertexContext(context);
                if (vContext == null) {
                    return false;
                }
                FcgVertex v = (FcgVertex)vContext.getVertex();
                Function function = v.getFunction();
                boolean bl = isEnabled = !function.equals(graphedFunction = FcgProvider.this.graphData.getFunction());
                if (isEnabled) {
                    this.setPopupMenuData(new MenuData(new String[]{"Graph '" + function.getName() + "'"}, "B"));
                }
                return isEnabled;
            }
        };
        graphFunctionAction.setPopupMenuData(new MenuData(new String[]{"Graph Function"}, "B"));
        this.addLocalAction((DockingActionIf)graphFunctionAction);
    }

    private Collection<FcgEdge> getGraphEdges(FcgVertex v, FcgDirection direction) {
        FunctionCallGraph graph = this.graphData.getGraph();
        if (direction == FcgDirection.IN) {
            return graph.getInEdges((Object)v);
        }
        return graph.getOutEdges((Object)v);
    }

    private Set<FcgEdge> getModelEdges(Iterable<FcgVertex> vertices, FcgLevel level, Predicate<FcgEdge> filter) {
        FcgDirection direction = level.getDirection();
        if (direction == FcgDirection.IN) {
            return this.getIncomingEdges(vertices, level, filter);
        }
        return this.getOutgoingEdges(vertices, level, filter);
    }

    private VgVertexContext<FcgVertex> getVertexContext(ActionContext c) {
        if (!(c instanceof VgVertexContext)) {
            return null;
        }
        VgVertexContext vContext = (VgVertexContext)c;
        return vContext;
    }

    private void addLayoutAction() {
        DockingAction resetGraphAction = new DockingAction("Reset Graph", this.plugin.getName()){

            public void actionPerformed(ActionContext context) {
                int choice = OptionDialog.showYesNoDialog((Component)FcgProvider.this.getComponent(), (String)"Reset Graph?", (String)"<html>Erase all vertex position information?");
                if (choice != 1) {
                    return;
                }
                FcgProvider.this.rebuildCurrentGraph();
            }
        };
        resetGraphAction.setToolBarData(new ToolBarData((Icon)Icons.REFRESH_ICON));
        resetGraphAction.setDescription("<html>Resets the graph--All positioning will be <b>lost</b>");
        resetGraphAction.setHelpLocation(new HelpLocation("FunctionCallGraphPlugin", "Relayout_Graph"));
        this.addLocalAction((DockingActionIf)resetGraphAction);
        MultiStateDockingAction<LayoutProvider<FcgVertex, FcgEdge, FunctionCallGraph>> layoutAction = new MultiStateDockingAction<LayoutProvider<FcgVertex, FcgEdge, FunctionCallGraph>>(RELAYOUT_GRAPH_ACTION_NAME, this.plugin.getName()){

            protected void doActionPerformed(ActionContext context) {
                LayoutProvider currentUserData = (LayoutProvider)this.getCurrentUserData();
                FcgProvider.this.changeLayout((LayoutProvider<FcgVertex, FcgEdge, FunctionCallGraph>)currentUserData);
            }

            public void actionStateChanged(ActionState<LayoutProvider<FcgVertex, FcgEdge, FunctionCallGraph>> newActionState, EventTrigger trigger) {
                FcgProvider.this.changeLayout((LayoutProvider<FcgVertex, FcgEdge, FunctionCallGraph>)((LayoutProvider)newActionState.getUserData()));
            }
        };
        layoutAction.setGroup("B");
        this.addLayoutProviders(layoutAction);
    }

    private void addLayoutProviders(MultiStateDockingAction<LayoutProvider<FcgVertex, FcgEdge, FunctionCallGraph>> layoutAction) {
        for (LayoutProvider<FcgVertex, FcgEdge, FunctionCallGraph> l : this.layouts) {
            layoutAction.addActionState(new ActionState(l.getLayoutName(), l.getActionIcon(), l));
        }
        layoutAction.setCurrentActionStateByUserData(this.defaultLayoutProvider);
    }

    private void changeLayout(LayoutProvider<FcgVertex, FcgEdge, FunctionCallGraph> provider) {
        this.layoutProvider = provider;
        if (this.isVisible()) {
            this.rebuildCurrentGraph();
        }
    }

    private Iterable<FcgVertex> getVerticesByLevel(FcgLevel level) {
        FunctionCallGraph graph = this.graphData.getGraph();
        return graph.getVerticesByLevel(level);
    }

    private void trackFunctionEdges(FcgVertex v) {
        Function f = v.getFunction();
        FunctionEdgeCache edgeCache = this.graphData.getFunctionEdgeCache();
        if (edgeCache.isTracked(f)) {
            return;
        }
        edgeCache.setTracked(f);
        Set calling = f.getCallingFunctions(TaskMonitor.DUMMY);
        int count = calling.size();
        if (count > 100) {
            v.setTooManyIncomingReferences(true);
            v.setHasIncomingReferences(true);
        } else {
            this.trackFunctionIncomingEdges(v, calling);
            v.setHasIncomingReferences(!calling.isEmpty());
        }
        Set called = f.getCalledFunctions(TaskMonitor.DUMMY);
        count = called.size();
        if (count > 100) {
            v.setTooManyOutgoingReferences(true);
            v.setHasOutgoingReferences(true);
        } else {
            this.trackFunctionOutgoingEdges(v, called);
            v.setHasOutgoingReferences(!called.isEmpty());
        }
    }

    private void trackFunctionOutgoingEdges(FcgVertex v, Set<Function> calledFunctions) {
        FunctionEdgeCache edgeCache = this.graphData.getFunctionEdgeCache();
        Function f = v.getFunction();
        for (Function callee : calledFunctions) {
            edgeCache.get(f).add(new FunctionEdge(f, callee));
        }
    }

    private void trackFunctionIncomingEdges(FcgVertex v, Set<Function> callingFunctions) {
        FunctionEdgeCache edgeCache = this.graphData.getFunctionEdgeCache();
        Function f = v.getFunction();
        for (Function caller : callingFunctions) {
            edgeCache.get(f).add(new FunctionEdge(caller, f));
        }
    }

    private void expand(FcgVertex source, FcgDirection direction) {
        FcgLevel level = source.getLevel();
        this.expand(CollectionUtils.asIterable((Object)((Object)source)), level, direction);
    }

    private void expand(Iterable<FcgVertex> sources, FcgLevel sourceLevel, FcgDirection direction) {
        if (IterableUtils.isEmpty((Iterable)(sources = IterableUtils.filteredIterable(sources, v -> v.canExpand())))) {
            return;
        }
        FcgLevel expandingLevel = sourceLevel.child(direction);
        Set<FcgEdge> newEdges = this.getModelEdges(sources, expandingLevel, this.edgeNotInGraphFilter);
        Iterable<FcgVertex> sourceSiblings = this.getVerticesByLevel(sourceLevel);
        Set<FcgEdge> parentLevelEdges = this.getModelEdges(sourceSiblings, expandingLevel, this.unfiltered);
        Set<FcgVertex> newVertices = this.toVertices(newEdges, direction, this.vertexInGraphFilter.negate());
        boolean isIncoming = direction == FcgDirection.IN;
        FcgExpandingVertexCollection collection = new FcgExpandingVertexCollection(sources, sourceLevel, expandingLevel, newVertices, newEdges, parentLevelEdges, isIncoming, (GraphViewer<FcgVertex, FcgEdge>)this.view.getPrimaryGraphViewer());
        this.doExpand(collection);
        this.markExpanded(sources, direction, true);
    }

    private void markExpanded(Iterable<FcgVertex> vertices, FcgDirection direction, boolean expanded) {
        if (direction == FcgDirection.IN) {
            this.markInsExpanded(vertices, expanded);
        } else {
            this.markOutsExpanded(vertices, expanded);
        }
        this.component.repaint();
    }

    private void markInsExpanded(Iterable<FcgVertex> vertices, boolean expanded) {
        for (FcgVertex v : vertices) {
            if (expanded == v.isIncomingExpanded()) continue;
            v.setIncomingExpanded(expanded);
        }
    }

    private void markOutsExpanded(Iterable<FcgVertex> vertices, boolean expanded) {
        for (FcgVertex v : vertices) {
            if (expanded == v.isOutgoingExpanded()) continue;
            v.setOutgoingExpanded(expanded);
        }
    }

    private void collapseLevel(FcgLevel level, FcgDirection direction) {
        FcgLevel collapseLevel = level.child(direction);
        Iterable<FcgVertex> toRemove = this.getVerticesAtOrGreaterThan(collapseLevel);
        Set set = CollectionUtils.asSet(toRemove.iterator());
        FunctionCallGraph graph = this.graphData.getGraph();
        graph.removeVertices(set);
        this.component.repaint();
        this.updateTitle();
        Iterable<FcgVertex> sources = graph.getVerticesByLevel(level);
        this.markExpanded(sources, direction, false);
    }

    private void collapse(FcgVertex v, FcgDirection direction) {
        HashSet<FcgEdge> edges = new HashSet<FcgEdge>(this.getGraphEdges(v, direction));
        FunctionCallGraph graph = this.graphData.getGraph();
        for (FcgEdge e : edges) {
            FcgVertex other = this.getOtherEnd(v, e);
            if (!this.isDependent(v, other, e)) continue;
            graph.removeEdge((VisualEdge)e);
            this.collapse(other, direction);
            this.removeFromGraph(other);
        }
        this.markExpanded(CollectionUtils.asIterable((Object)((Object)v)), direction, false);
    }

    private FcgVertex getOtherEnd(FcgVertex v, FcgEdge e) {
        FcgVertex start = (FcgVertex)e.getStart();
        if (v.equals((Object)start)) {
            return (FcgVertex)e.getEnd();
        }
        return start;
    }

    private boolean isDependent(FcgVertex parent, FcgVertex other, FcgEdge e) {
        FcgLevel otherLevel;
        FcgLevel parentLevel = parent.getLevel();
        if (!parentLevel.isParentOf(otherLevel = other.getLevel())) {
            return false;
        }
        FunctionCallGraph g = this.graphData.getGraph();
        Collection ins = g.getInEdges((Object)other);
        for (FcgEdge inEdge : ins) {
            FcgLevel inLevel;
            FcgVertex start = (FcgVertex)inEdge.getStart();
            if (start.equals((Object)parent) || !(inLevel = start.getLevel()).equals(parentLevel) || !start.isExpanded()) continue;
            return false;
        }
        return true;
    }

    private void removeFromGraph(FcgVertex v) {
        FunctionCallGraph g = this.graphData.getGraph();
        g.removeVertex((VisualVertex)v);
        this.component.repaint();
    }

    private Set<FcgEdge> getIncomingEdges(Iterable<FcgVertex> vertices, FcgLevel level, Predicate<FcgEdge> filter) {
        HashMap<Function, FcgVertex> newVertexCache = new HashMap<Function, FcgVertex>();
        HashSet<FcgEdge> result = new HashSet<FcgEdge>();
        for (FcgVertex source : vertices) {
            Function f = source.getFunction();
            Iterable<Function> functions = this.getCallingFunctions(f);
            Set<FcgVertex> callers = this.toVertices(functions, level, newVertexCache);
            for (FcgVertex caller : callers) {
                FcgEdge e = this.getOrCreateEdge(caller, source);
                if (!filter.test(e)) continue;
                result.add(e);
            }
        }
        return result;
    }

    private FcgEdge getOrCreateEdge(FcgVertex start, FcgVertex end) {
        FunctionCallGraph graph = this.graphData.getGraph();
        Iterable edges = graph.getEdges((VisualVertex)start, (VisualVertex)end);
        FcgEdge e = (FcgEdge)((Object)CollectionUtils.any((Iterable)edges));
        if (e != null) {
            return e;
        }
        return new FcgEdge(start, end);
    }

    private Iterable<Function> getCallingFunctions(Function f) {
        FunctionEdgeCache edgeCache = this.graphData.getFunctionEdgeCache();
        SystemUtilities.assertTrue((boolean)edgeCache.isTracked(f), (String)"Function not tracked in cache");
        Set<FunctionEdge> edges = edgeCache.get(f);
        Iterable filtered = IterableUtils.filteredIterable(edges, e -> this.isCalledFunction(f, (FunctionEdge)e));
        Iterable functions = IterableUtils.transformedIterable((Iterable)filtered, e -> e.getStart());
        return functions;
    }

    private Iterable<Function> getCallerFunctions(Function f) {
        FunctionEdgeCache edgeCache = this.graphData.getFunctionEdgeCache();
        SystemUtilities.assertTrue((boolean)edgeCache.isTracked(f), (String)"Function not tracked in cache");
        Set<FunctionEdge> edges = edgeCache.get(f);
        Iterable filtered = IterableUtils.filteredIterable(edges, e -> this.isCallingFunction(f, (FunctionEdge)e));
        Iterable functions = IterableUtils.transformedIterable((Iterable)filtered, e -> e.getEnd());
        return functions;
    }

    private boolean isCallingFunction(Function f, FunctionEdge e) {
        Function start = e.getStart();
        return start.equals(f);
    }

    private boolean isCalledFunction(Function f, FunctionEdge e) {
        Function end = e.getEnd();
        return end.equals(f);
    }

    private Set<FcgVertex> toStartVertices(Iterable<FcgEdge> edges, Predicate<FcgVertex> filter) {
        return CollectionUtils.asStream((Iterable[])new Iterable[]{edges}).map(e -> (FcgVertex)e.getStart()).filter(filter).collect(Collectors.toSet());
    }

    private Set<FcgVertex> toVertices(Iterable<FcgEdge> edges, FcgDirection direction, Predicate<FcgVertex> filter) {
        return direction == FcgDirection.IN ? this.toStartVertices(edges, filter) : this.toEndVertices(edges, filter);
    }

    private Set<FcgVertex> toEndVertices(Iterable<FcgEdge> edges, Predicate<FcgVertex> filter) {
        return CollectionUtils.asStream((Iterable[])new Iterable[]{edges}).map(e -> (FcgVertex)e.getEnd()).filter(filter).collect(Collectors.toSet());
    }

    private Set<FcgEdge> getOutgoingEdges(Iterable<FcgVertex> vertices, FcgLevel level, Predicate<FcgEdge> filter) {
        HashMap<Function, FcgVertex> newVertexCache = new HashMap<Function, FcgVertex>();
        HashSet<FcgEdge> result = new HashSet<FcgEdge>();
        for (FcgVertex source : vertices) {
            Function f = source.getFunction();
            Iterable<Function> functions = this.getCallerFunctions(f);
            Set<FcgVertex> callees = this.toVertices(functions, level, newVertexCache);
            for (FcgVertex callee : callees) {
                FcgEdge e = this.getOrCreateEdge(source, callee);
                if (!filter.test(e)) continue;
                result.add(e);
            }
        }
        return result;
    }

    private Iterable<FcgVertex> getVerticesAtOrGreaterThan(FcgLevel level) {
        ArrayList<Iterable<FcgVertex>> result = new ArrayList<Iterable<FcgVertex>>();
        FunctionCallGraph graph = this.graphData.getGraph();
        FcgLevel greatestLevel = graph.getLargestLevel(level.getDirection());
        FcgLevel currentLevel = level;
        while (currentLevel.getRow() <= greatestLevel.getRow()) {
            Iterable<FcgVertex> vertices = this.getVerticesByLevel(currentLevel);
            result.add(vertices);
            currentLevel = currentLevel.child();
        }
        Collections.reverse(result);
        Iterable[] array = result.toArray(new Iterable[result.size()]);
        return IterableUtils.chainedIterable((Iterable[])array);
    }

    private void doExpand(FcgExpandingVertexCollection collection) {
        Set<FcgVertex> newVertices = collection.getNewVertices();
        FunctionCallGraph graph = this.graphData.getGraph();
        for (FcgVertex fcgVertex : newVertices) {
            graph.addVertex((VisualVertex)fcgVertex);
        }
        Iterable<FcgEdge> newEdges = collection.getNewEdges();
        for (FcgEdge e : newEdges) {
            graph.addEdge((VisualEdge)e);
        }
        HashSet<FcgEdge> hashSet = new HashSet<FcgEdge>();
        this.addEdgesToExistingVertices(newVertices, hashSet);
        collection.setIndirectEdges(hashSet);
        int newEdgeCount = collection.getNewEdgeCount();
        if (newEdgeCount == 0) {
            this.highlightExistingEdges(collection);
            return;
        }
        GraphViewer viewer = this.view.getPrimaryGraphViewer();
        BowTieExpandVerticesJob job = new BowTieExpandVerticesJob((GraphViewer<FcgVertex, FcgEdge>)viewer, collection, true);
        VisualGraphViewUpdater updater = this.view.getViewUpdater();
        updater.scheduleViewChangeJob((GraphJob)job);
        this.updateTitle();
    }

    private void highlightExistingEdges(FcgExpandingVertexCollection collection) {
        GraphViewer viewer = this.view.getPrimaryGraphViewer();
        VisualGraphViewUpdater updater = this.view.getViewUpdater();
        Iterable<FcgVertex> sources = collection.getSources();
        FcgVertex source = (FcgVertex)((Object)CollectionUtils.any(sources));
        FcgLevel level = source.getLevel();
        Set<FcgEdge> existingEdges = this.getModelEdges(sources, level, this.unfiltered);
        FcgEmphasizeEdgesJob job = new FcgEmphasizeEdgesJob((GraphViewer<FcgVertex, FcgEdge>)viewer, existingEdges);
        updater.scheduleViewChangeJob((GraphJob)job);
    }

    private void addEdgesToExistingVertices(Iterable<FcgVertex> newVertices, Set<FcgEdge> newEdges) {
        FunctionCallGraph graph = this.graphData.getGraph();
        FunctionEdgeCache cache = this.graphData.getFunctionEdgeCache();
        for (FcgVertex v : newVertices) {
            Function f = v.getFunction();
            Set<FunctionEdge> edges = cache.get(f);
            for (FunctionEdge e : edges) {
                Function start = e.getStart();
                Function end = e.getEnd();
                FcgVertex v1 = graph.getVertex(start);
                FcgVertex v2 = graph.getVertex(end);
                if (v1 == null || v2 == null || graph.containsEdge((Object)v1, (Object)v2)) continue;
                FcgEdge newEdge = new FcgEdge(v1, v2);
                graph.addEdge((VisualEdge)newEdge);
                newEdges.add(newEdge);
            }
        }
    }

    private Set<FcgVertex> toVertices(Iterable<Function> callees, FcgLevel level, Map<Function, FcgVertex> newVertexCache) {
        return CollectionUtils.asStream((Iterable[])new Iterable[]{callees}).map(f -> {
            if (newVertexCache.containsKey(f)) {
                return (FcgVertex)((Object)((Object)newVertexCache.get(f)));
            }
            FcgVertex v = this.getOrCreateVertex((Function)f, level);
            newVertexCache.put((Function)f, v);
            return v;
        }).collect(Collectors.toSet());
    }

    private class ExpandLevelAction
    extends AbstractExpandAction {
        ExpandLevelAction(String actionName, FcgDirection direction) {
            super(actionName, direction);
        }

        @Override
        void expandFromContext(VgVertexContext<FcgVertex> context) {
            FcgVertex v = (FcgVertex)context.getVertex();
            FcgLevel level = v.getLevel();
            Iterable<FcgVertex> vertices = FcgProvider.this.getVerticesByLevel(v.getLevel());
            FcgProvider.this.expand(vertices, level, this.direction);
        }

        @Override
        boolean isMyDirection(FcgLevel level) {
            if (level.getDirection() == FcgDirection.IN_AND_OUT) {
                return true;
            }
            return level.getDirection() == this.direction;
        }

        @Override
        boolean isExpandable(FcgVertex vertex) {
            Iterable<FcgVertex> vertices = FcgProvider.this.getVerticesByLevel(vertex.getLevel());
            return CollectionUtils.asStream((Iterable[])new Iterable[]{vertices}).anyMatch(v -> v.canExpand());
        }
    }

    private class ExpandAction
    extends AbstractExpandAction {
        ExpandAction(String actionName, FcgDirection direction) {
            super(actionName, direction);
        }

        @Override
        void expandFromContext(VgVertexContext<FcgVertex> context) {
            FcgVertex v = (FcgVertex)context.getVertex();
            FcgProvider.this.expand(v, this.direction);
        }

        @Override
        boolean isExpandable(FcgVertex v) {
            return v.canExpand();
        }
    }

    private abstract class AbstractExpandAction
    extends DockingAction {
        protected FcgDirection direction;

        AbstractExpandAction(String actionName, FcgDirection direction) {
            super(actionName, FcgProvider.this.plugin.getName());
            this.direction = direction;
            this.setPopupMenuData(new MenuData(new String[]{actionName}, "A"));
            this.setHelpLocation(new HelpLocation("FunctionCallGraphPlugin", "Expand_Collapse"));
        }

        abstract void expandFromContext(VgVertexContext<FcgVertex> var1);

        abstract boolean isExpandable(FcgVertex var1);

        public void actionPerformed(ActionContext context) {
            VgVertexContext<FcgVertex> vContext = FcgProvider.this.getVertexContext(context);
            this.expandFromContext(vContext);
        }

        public boolean isEnabledForContext(ActionContext context) {
            VgVertexContext<FcgVertex> vContext = FcgProvider.this.getVertexContext(context);
            if (vContext == null) {
                return false;
            }
            FcgVertex v = (FcgVertex)vContext.getVertex();
            boolean isExpandable = this.isExpandable(v);
            if (!isExpandable) {
                return false;
            }
            return this.isMyDirection(v.getLevel());
        }

        boolean isMyDirection(FcgLevel level) {
            return level.getDirection() == this.direction;
        }
    }

    private class CollapseLevelAction
    extends AbstractCollapseAction {
        CollapseLevelAction(String actionName, FcgDirection direction) {
            super(actionName, direction);
        }

        @Override
        void collapseFromContext(VgVertexContext<FcgVertex> context) {
            FcgVertex v = (FcgVertex)context.getVertex();
            FcgLevel level = v.getLevel();
            FcgProvider.this.collapseLevel(level, this.direction);
        }

        @Override
        boolean isMyDirection(FcgLevel level) {
            if (level.getDirection() == FcgDirection.IN_AND_OUT) {
                return true;
            }
            return level.getDirection() == this.direction;
        }
    }

    private class CollapseAction
    extends AbstractCollapseAction {
        CollapseAction(String actionName, FcgDirection direction) {
            super(actionName, direction);
        }

        @Override
        void collapseFromContext(VgVertexContext<FcgVertex> context) {
            FcgVertex v = (FcgVertex)context.getVertex();
            FcgProvider.this.collapse(v, this.direction);
        }
    }

    private abstract class AbstractCollapseAction
    extends DockingAction {
        protected FcgDirection direction;

        AbstractCollapseAction(String actionName, FcgDirection direction) {
            super(actionName, FcgProvider.this.plugin.getName());
            this.direction = direction;
            this.setPopupMenuData(new MenuData(new String[]{actionName}, "A"));
            this.setHelpLocation(new HelpLocation("FunctionCallGraphPlugin", "Expand_Collapse"));
        }

        abstract void collapseFromContext(VgVertexContext<FcgVertex> var1);

        public void actionPerformed(ActionContext context) {
            VgVertexContext<FcgVertex> vContext = FcgProvider.this.getVertexContext(context);
            this.collapseFromContext(vContext);
        }

        public boolean isEnabledForContext(ActionContext context) {
            boolean expanded;
            VgVertexContext<FcgVertex> vContext = FcgProvider.this.getVertexContext(context);
            if (vContext == null) {
                return false;
            }
            FcgVertex v = (FcgVertex)vContext.getVertex();
            boolean bl = expanded = this.direction == FcgDirection.IN ? v.isIncomingExpanded() : v.isOutgoingExpanded();
            if (!expanded) {
                return false;
            }
            return this.isMyDirection(v.getLevel());
        }

        boolean isMyDirection(FcgLevel level) {
            return level.getDirection() == this.direction;
        }
    }

    private class ExpansionListener
    implements FcgVertexExpansionListener {
        private ExpansionListener() {
        }

        @Override
        public void toggleIncomingVertices(FcgVertex v) {
            boolean expanded = v.isIncomingExpanded();
            if (expanded) {
                FcgProvider.this.collapse(v, FcgDirection.IN);
            } else {
                FcgProvider.this.expand(v, FcgDirection.IN);
            }
        }

        @Override
        public void toggleOutgoingVertices(FcgVertex v) {
            boolean expanded = v.isOutgoingExpanded();
            if (expanded) {
                FcgProvider.this.collapse(v, FcgDirection.OUT);
            } else {
                FcgProvider.this.expand(v, FcgDirection.OUT);
            }
        }
    }
}

