/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Code;

import java.util.HashMap;
import org.jf.dexlib.Code.Format.Format;
import org.jf.dexlib.Code.ReferenceType;

public final class Opcode
extends Enum<Opcode> {
    public static final /* enum */ Opcode NOP = new Opcode(0, "nop", ReferenceType.none, Format.Format10x, 4);
    public static final /* enum */ Opcode MOVE = new Opcode(1, "move", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode MOVE_FROM16 = new Opcode(2, "move/from16", ReferenceType.none, Format.Format22x, 20);
    public static final /* enum */ Opcode MOVE_16 = new Opcode(3, "move/16", ReferenceType.none, Format.Format32x, 20);
    public static final /* enum */ Opcode MOVE_WIDE = new Opcode(4, "move-wide", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode MOVE_WIDE_FROM16 = new Opcode(5, "move-wide/from16", ReferenceType.none, Format.Format22x, 52);
    public static final /* enum */ Opcode MOVE_WIDE_16 = new Opcode(6, "move-wide/16", ReferenceType.none, Format.Format32x, 52);
    public static final /* enum */ Opcode MOVE_OBJECT = new Opcode(7, "move-object", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode MOVE_OBJECT_FROM16 = new Opcode(8, "move-object/from16", ReferenceType.none, Format.Format22x, 20);
    public static final /* enum */ Opcode MOVE_OBJECT_16 = new Opcode(9, "move-object/16", ReferenceType.none, Format.Format32x, 20);
    public static final /* enum */ Opcode MOVE_RESULT = new Opcode(10, "move-result", ReferenceType.none, Format.Format11x, 20);
    public static final /* enum */ Opcode MOVE_RESULT_WIDE = new Opcode(11, "move-result-wide", ReferenceType.none, Format.Format11x, 52);
    public static final /* enum */ Opcode MOVE_RESULT_OBJECT = new Opcode(12, "move-result-object", ReferenceType.none, Format.Format11x, 20);
    public static final /* enum */ Opcode MOVE_EXCEPTION = new Opcode(13, "move-exception", ReferenceType.none, Format.Format11x, 20);
    public static final /* enum */ Opcode RETURN_VOID = new Opcode(14, "return-void", ReferenceType.none, Format.Format10x);
    public static final /* enum */ Opcode RETURN = new Opcode(15, "return", ReferenceType.none, Format.Format11x);
    public static final /* enum */ Opcode RETURN_WIDE = new Opcode(16, "return-wide", ReferenceType.none, Format.Format11x);
    public static final /* enum */ Opcode RETURN_OBJECT = new Opcode(17, "return-object", ReferenceType.none, Format.Format11x);
    public static final /* enum */ Opcode CONST_4 = new Opcode(18, "const/4", ReferenceType.none, Format.Format11n, 20);
    public static final /* enum */ Opcode CONST_16 = new Opcode(19, "const/16", ReferenceType.none, Format.Format21s, 20);
    public static final /* enum */ Opcode CONST = new Opcode(20, "const", ReferenceType.none, Format.Format31i, 20);
    public static final /* enum */ Opcode CONST_HIGH16 = new Opcode(21, "const/high16", ReferenceType.none, Format.Format21h, 20);
    public static final /* enum */ Opcode CONST_WIDE_16 = new Opcode(22, "const-wide/16", ReferenceType.none, Format.Format21s, 52);
    public static final /* enum */ Opcode CONST_WIDE_32 = new Opcode(23, "const-wide/32", ReferenceType.none, Format.Format31i, 52);
    public static final /* enum */ Opcode CONST_WIDE = new Opcode(24, "const-wide", ReferenceType.none, Format.Format51l, 52);
    public static final /* enum */ Opcode CONST_WIDE_HIGH16 = new Opcode(25, "const-wide/high16", ReferenceType.none, Format.Format21h, 52);
    public static final /* enum */ Opcode CONST_STRING = new Opcode(26, "const-string", ReferenceType.string, Format.Format21c, 21, 27);
    public static final /* enum */ Opcode CONST_STRING_JUMBO = new Opcode(27, "const-string/jumbo", ReferenceType.string, Format.Format31c, 21);
    public static final /* enum */ Opcode CONST_CLASS = new Opcode(28, "const-class", ReferenceType.type, Format.Format21c, 21, -256);
    public static final /* enum */ Opcode MONITOR_ENTER = new Opcode(29, "monitor-enter", ReferenceType.none, Format.Format11x, 5);
    public static final /* enum */ Opcode MONITOR_EXIT = new Opcode(30, "monitor-exit", ReferenceType.none, Format.Format11x, 5);
    public static final /* enum */ Opcode CHECK_CAST = new Opcode(31, "check-cast", ReferenceType.type, Format.Format21c, 21, -255);
    public static final /* enum */ Opcode INSTANCE_OF = new Opcode(32, "instance-of", ReferenceType.type, Format.Format22c, 21, -254);
    public static final /* enum */ Opcode ARRAY_LENGTH = new Opcode(33, "array-length", ReferenceType.none, Format.Format12x, 21);
    public static final /* enum */ Opcode NEW_INSTANCE = new Opcode(34, "new-instance", ReferenceType.type, Format.Format21c, 21, -253);
    public static final /* enum */ Opcode NEW_ARRAY = new Opcode(35, "new-array", ReferenceType.type, Format.Format22c, 21, -252);
    public static final /* enum */ Opcode FILLED_NEW_ARRAY = new Opcode(36, "filled-new-array", ReferenceType.type, Format.Format35c, 13);
    public static final /* enum */ Opcode FILLED_NEW_ARRAY_RANGE = new Opcode(37, "filled-new-array/range", ReferenceType.type, Format.Format3rc, 13, -251);
    public static final /* enum */ Opcode FILL_ARRAY_DATA = new Opcode(38, "fill-array-data", ReferenceType.none, Format.Format31t, 4);
    public static final /* enum */ Opcode THROW = new Opcode(39, "throw", ReferenceType.none, Format.Format11x, 1);
    public static final /* enum */ Opcode GOTO = new Opcode(40, "goto", ReferenceType.none, Format.Format10t);
    public static final /* enum */ Opcode GOTO_16 = new Opcode(41, "goto/16", ReferenceType.none, Format.Format20t);
    public static final /* enum */ Opcode GOTO_32 = new Opcode(42, "goto/32", ReferenceType.none, Format.Format30t);
    public static final /* enum */ Opcode PACKED_SWITCH = new Opcode(43, "packed-switch", ReferenceType.none, Format.Format31t, 4);
    public static final /* enum */ Opcode SPARSE_SWITCH = new Opcode(44, "sparse-switch", ReferenceType.none, Format.Format31t, 4);
    public static final /* enum */ Opcode CMPL_FLOAT = new Opcode(45, "cmpl-float", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode CMPG_FLOAT = new Opcode(46, "cmpg-float", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode CMPL_DOUBLE = new Opcode(47, "cmpl-double", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode CMPG_DOUBLE = new Opcode(48, "cmpg-double", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode CMP_LONG = new Opcode(49, "cmp-long", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode IF_EQ = new Opcode(50, "if-eq", ReferenceType.none, Format.Format22t, 4);
    public static final /* enum */ Opcode IF_NE = new Opcode(51, "if-ne", ReferenceType.none, Format.Format22t, 4);
    public static final /* enum */ Opcode IF_LT = new Opcode(52, "if-lt", ReferenceType.none, Format.Format22t, 4);
    public static final /* enum */ Opcode IF_GE = new Opcode(53, "if-ge", ReferenceType.none, Format.Format22t, 4);
    public static final /* enum */ Opcode IF_GT = new Opcode(54, "if-gt", ReferenceType.none, Format.Format22t, 4);
    public static final /* enum */ Opcode IF_LE = new Opcode(55, "if-le", ReferenceType.none, Format.Format22t, 4);
    public static final /* enum */ Opcode IF_EQZ = new Opcode(56, "if-eqz", ReferenceType.none, Format.Format21t, 4);
    public static final /* enum */ Opcode IF_NEZ = new Opcode(57, "if-nez", ReferenceType.none, Format.Format21t, 4);
    public static final /* enum */ Opcode IF_LTZ = new Opcode(58, "if-ltz", ReferenceType.none, Format.Format21t, 4);
    public static final /* enum */ Opcode IF_GEZ = new Opcode(59, "if-gez", ReferenceType.none, Format.Format21t, 4);
    public static final /* enum */ Opcode IF_GTZ = new Opcode(60, "if-gtz", ReferenceType.none, Format.Format21t, 4);
    public static final /* enum */ Opcode IF_LEZ = new Opcode(61, "if-lez", ReferenceType.none, Format.Format21t, 4);
    public static final /* enum */ Opcode AGET = new Opcode(68, "aget", ReferenceType.none, Format.Format23x, 21);
    public static final /* enum */ Opcode AGET_WIDE = new Opcode(69, "aget-wide", ReferenceType.none, Format.Format23x, 53);
    public static final /* enum */ Opcode AGET_OBJECT = new Opcode(70, "aget-object", ReferenceType.none, Format.Format23x, 21);
    public static final /* enum */ Opcode AGET_BOOLEAN = new Opcode(71, "aget-boolean", ReferenceType.none, Format.Format23x, 21);
    public static final /* enum */ Opcode AGET_BYTE = new Opcode(72, "aget-byte", ReferenceType.none, Format.Format23x, 21);
    public static final /* enum */ Opcode AGET_CHAR = new Opcode(73, "aget-char", ReferenceType.none, Format.Format23x, 21);
    public static final /* enum */ Opcode AGET_SHORT = new Opcode(74, "aget-short", ReferenceType.none, Format.Format23x, 21);
    public static final /* enum */ Opcode APUT = new Opcode(75, "aput", ReferenceType.none, Format.Format23x, 5);
    public static final /* enum */ Opcode APUT_WIDE = new Opcode(76, "aput-wide", ReferenceType.none, Format.Format23x, 5);
    public static final /* enum */ Opcode APUT_OBJECT = new Opcode(77, "aput-object", ReferenceType.none, Format.Format23x, 5);
    public static final /* enum */ Opcode APUT_BOOLEAN = new Opcode(78, "aput-boolean", ReferenceType.none, Format.Format23x, 5);
    public static final /* enum */ Opcode APUT_BYTE = new Opcode(79, "aput-byte", ReferenceType.none, Format.Format23x, 5);
    public static final /* enum */ Opcode APUT_CHAR = new Opcode(80, "aput-char", ReferenceType.none, Format.Format23x, 5);
    public static final /* enum */ Opcode APUT_SHORT = new Opcode(81, "aput-short", ReferenceType.none, Format.Format23x, 5);
    public static final /* enum */ Opcode IGET = new Opcode(82, "iget", ReferenceType.field, Format.Format22c, 21, -250);
    public static final /* enum */ Opcode IGET_WIDE = new Opcode(83, "iget-wide", ReferenceType.field, Format.Format22c, 53, -249);
    public static final /* enum */ Opcode IGET_OBJECT = new Opcode(84, "iget-object", ReferenceType.field, Format.Format22c, 21, -248);
    public static final /* enum */ Opcode IGET_BOOLEAN = new Opcode(85, "iget-boolean", ReferenceType.field, Format.Format22c, 21, -247);
    public static final /* enum */ Opcode IGET_BYTE = new Opcode(86, "iget-byte", ReferenceType.field, Format.Format22c, 21, -246);
    public static final /* enum */ Opcode IGET_CHAR = new Opcode(87, "iget-char", ReferenceType.field, Format.Format22c, 21, -245);
    public static final /* enum */ Opcode IGET_SHORT = new Opcode(88, "iget-short", ReferenceType.field, Format.Format22c, 21, -244);
    public static final /* enum */ Opcode IPUT = new Opcode(89, "iput", ReferenceType.field, Format.Format22c, 5, -243);
    public static final /* enum */ Opcode IPUT_WIDE = new Opcode(90, "iput-wide", ReferenceType.field, Format.Format22c, 5, -242);
    public static final /* enum */ Opcode IPUT_OBJECT = new Opcode(91, "iput-object", ReferenceType.field, Format.Format22c, 5, -241);
    public static final /* enum */ Opcode IPUT_BOOLEAN = new Opcode(92, "iput-boolean", ReferenceType.field, Format.Format22c, 5, -240);
    public static final /* enum */ Opcode IPUT_BYTE = new Opcode(93, "iput-byte", ReferenceType.field, Format.Format22c, 5, -239);
    public static final /* enum */ Opcode IPUT_CHAR = new Opcode(94, "iput-char", ReferenceType.field, Format.Format22c, 5, -238);
    public static final /* enum */ Opcode IPUT_SHORT = new Opcode(95, "iput-short", ReferenceType.field, Format.Format22c, 5, -237);
    public static final /* enum */ Opcode SGET = new Opcode(96, "sget", ReferenceType.field, Format.Format21c, 21, -236);
    public static final /* enum */ Opcode SGET_WIDE = new Opcode(97, "sget-wide", ReferenceType.field, Format.Format21c, 53, -235);
    public static final /* enum */ Opcode SGET_OBJECT = new Opcode(98, "sget-object", ReferenceType.field, Format.Format21c, 21, -234);
    public static final /* enum */ Opcode SGET_BOOLEAN = new Opcode(99, "sget-boolean", ReferenceType.field, Format.Format21c, 21, -233);
    public static final /* enum */ Opcode SGET_BYTE = new Opcode(100, "sget-byte", ReferenceType.field, Format.Format21c, 21, -232);
    public static final /* enum */ Opcode SGET_CHAR = new Opcode(101, "sget-char", ReferenceType.field, Format.Format21c, 21, -231);
    public static final /* enum */ Opcode SGET_SHORT = new Opcode(102, "sget-short", ReferenceType.field, Format.Format21c, 21, -230);
    public static final /* enum */ Opcode SPUT = new Opcode(103, "sput", ReferenceType.field, Format.Format21c, 5, -229);
    public static final /* enum */ Opcode SPUT_WIDE = new Opcode(104, "sput-wide", ReferenceType.field, Format.Format21c, 5, -228);
    public static final /* enum */ Opcode SPUT_OBJECT = new Opcode(105, "sput-object", ReferenceType.field, Format.Format21c, 5, -227);
    public static final /* enum */ Opcode SPUT_BOOLEAN = new Opcode(106, "sput-boolean", ReferenceType.field, Format.Format21c, 5, -226);
    public static final /* enum */ Opcode SPUT_BYTE = new Opcode(107, "sput-byte", ReferenceType.field, Format.Format21c, 5, -225);
    public static final /* enum */ Opcode SPUT_CHAR = new Opcode(108, "sput-char", ReferenceType.field, Format.Format21c, 5, -224);
    public static final /* enum */ Opcode SPUT_SHORT = new Opcode(109, "sput-short", ReferenceType.field, Format.Format21c, 5, -223);
    public static final /* enum */ Opcode INVOKE_VIRTUAL = new Opcode(110, "invoke-virtual", ReferenceType.method, Format.Format35c, 13);
    public static final /* enum */ Opcode INVOKE_SUPER = new Opcode(111, "invoke-super", ReferenceType.method, Format.Format35c, 13);
    public static final /* enum */ Opcode INVOKE_DIRECT = new Opcode(112, "invoke-direct", ReferenceType.method, Format.Format35c, 1037);
    public static final /* enum */ Opcode INVOKE_STATIC = new Opcode(113, "invoke-static", ReferenceType.method, Format.Format35c, 13);
    public static final /* enum */ Opcode INVOKE_INTERFACE = new Opcode(114, "invoke-interface", ReferenceType.method, Format.Format35c, 13);
    public static final /* enum */ Opcode INVOKE_VIRTUAL_RANGE = new Opcode(116, "invoke-virtual/range", ReferenceType.method, Format.Format3rc, 13, -222);
    public static final /* enum */ Opcode INVOKE_SUPER_RANGE = new Opcode(117, "invoke-super/range", ReferenceType.method, Format.Format3rc, 13, -221);
    public static final /* enum */ Opcode INVOKE_DIRECT_RANGE = new Opcode(118, "invoke-direct/range", ReferenceType.method, Format.Format3rc, 1037, -220);
    public static final /* enum */ Opcode INVOKE_STATIC_RANGE = new Opcode(119, "invoke-static/range", ReferenceType.method, Format.Format3rc, 13, -219);
    public static final /* enum */ Opcode INVOKE_INTERFACE_RANGE = new Opcode(120, "invoke-interface/range", ReferenceType.method, Format.Format3rc, 13, -218);
    public static final /* enum */ Opcode NEG_INT = new Opcode(123, "neg-int", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode NOT_INT = new Opcode(124, "not-int", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode NEG_LONG = new Opcode(125, "neg-long", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode NOT_LONG = new Opcode(126, "not-long", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode NEG_FLOAT = new Opcode(127, "neg-float", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode NEG_DOUBLE = new Opcode(128, "neg-double", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode INT_TO_LONG = new Opcode(129, "int-to-long", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode INT_TO_FLOAT = new Opcode(130, "int-to-float", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode INT_TO_DOUBLE = new Opcode(131, "int-to-double", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode LONG_TO_INT = new Opcode(132, "long-to-int", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode LONG_TO_FLOAT = new Opcode(133, "long-to-float", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode LONG_TO_DOUBLE = new Opcode(134, "long-to-double", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode FLOAT_TO_INT = new Opcode(135, "float-to-int", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode FLOAT_TO_LONG = new Opcode(136, "float-to-long", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode FLOAT_TO_DOUBLE = new Opcode(137, "float-to-double", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode DOUBLE_TO_INT = new Opcode(138, "double-to-int", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode DOUBLE_TO_LONG = new Opcode(139, "double-to-long", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode DOUBLE_TO_FLOAT = new Opcode(140, "double-to-float", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode INT_TO_BYTE = new Opcode(141, "int-to-byte", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode INT_TO_CHAR = new Opcode(142, "int-to-char", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode INT_TO_SHORT = new Opcode(143, "int-to-short", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode ADD_INT = new Opcode(144, "add-int", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode SUB_INT = new Opcode(145, "sub-int", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode MUL_INT = new Opcode(146, "mul-int", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode DIV_INT = new Opcode(147, "div-int", ReferenceType.none, Format.Format23x, 21);
    public static final /* enum */ Opcode REM_INT = new Opcode(148, "rem-int", ReferenceType.none, Format.Format23x, 21);
    public static final /* enum */ Opcode AND_INT = new Opcode(149, "and-int", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode OR_INT = new Opcode(150, "or-int", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode XOR_INT = new Opcode(151, "xor-int", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode SHL_INT = new Opcode(152, "shl-int", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode SHR_INT = new Opcode(153, "shr-int", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode USHR_INT = new Opcode(154, "ushr-int", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode ADD_LONG = new Opcode(155, "add-long", ReferenceType.none, Format.Format23x, 52);
    public static final /* enum */ Opcode SUB_LONG = new Opcode(156, "sub-long", ReferenceType.none, Format.Format23x, 52);
    public static final /* enum */ Opcode MUL_LONG = new Opcode(157, "mul-long", ReferenceType.none, Format.Format23x, 52);
    public static final /* enum */ Opcode DIV_LONG = new Opcode(158, "div-long", ReferenceType.none, Format.Format23x, 53);
    public static final /* enum */ Opcode REM_LONG = new Opcode(159, "rem-long", ReferenceType.none, Format.Format23x, 53);
    public static final /* enum */ Opcode AND_LONG = new Opcode(160, "and-long", ReferenceType.none, Format.Format23x, 52);
    public static final /* enum */ Opcode OR_LONG = new Opcode(161, "or-long", ReferenceType.none, Format.Format23x, 52);
    public static final /* enum */ Opcode XOR_LONG = new Opcode(162, "xor-long", ReferenceType.none, Format.Format23x, 52);
    public static final /* enum */ Opcode SHL_LONG = new Opcode(163, "shl-long", ReferenceType.none, Format.Format23x, 52);
    public static final /* enum */ Opcode SHR_LONG = new Opcode(164, "shr-long", ReferenceType.none, Format.Format23x, 52);
    public static final /* enum */ Opcode USHR_LONG = new Opcode(165, "ushr-long", ReferenceType.none, Format.Format23x, 52);
    public static final /* enum */ Opcode ADD_FLOAT = new Opcode(166, "add-float", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode SUB_FLOAT = new Opcode(167, "sub-float", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode MUL_FLOAT = new Opcode(168, "mul-float", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode DIV_FLOAT = new Opcode(169, "div-float", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode REM_FLOAT = new Opcode(170, "rem-float", ReferenceType.none, Format.Format23x, 20);
    public static final /* enum */ Opcode ADD_DOUBLE = new Opcode(171, "add-double", ReferenceType.none, Format.Format23x, 52);
    public static final /* enum */ Opcode SUB_DOUBLE = new Opcode(172, "sub-double", ReferenceType.none, Format.Format23x, 52);
    public static final /* enum */ Opcode MUL_DOUBLE = new Opcode(173, "mul-double", ReferenceType.none, Format.Format23x, 52);
    public static final /* enum */ Opcode DIV_DOUBLE = new Opcode(174, "div-double", ReferenceType.none, Format.Format23x, 52);
    public static final /* enum */ Opcode REM_DOUBLE = new Opcode(175, "rem-double", ReferenceType.none, Format.Format23x, 52);
    public static final /* enum */ Opcode ADD_INT_2ADDR = new Opcode(176, "add-int/2addr", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode SUB_INT_2ADDR = new Opcode(177, "sub-int/2addr", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode MUL_INT_2ADDR = new Opcode(178, "mul-int/2addr", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode DIV_INT_2ADDR = new Opcode(179, "div-int/2addr", ReferenceType.none, Format.Format12x, 21);
    public static final /* enum */ Opcode REM_INT_2ADDR = new Opcode(180, "rem-int/2addr", ReferenceType.none, Format.Format12x, 21);
    public static final /* enum */ Opcode AND_INT_2ADDR = new Opcode(181, "and-int/2addr", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode OR_INT_2ADDR = new Opcode(182, "or-int/2addr", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode XOR_INT_2ADDR = new Opcode(183, "xor-int/2addr", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode SHL_INT_2ADDR = new Opcode(184, "shl-int/2addr", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode SHR_INT_2ADDR = new Opcode(185, "shr-int/2addr", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode USHR_INT_2ADDR = new Opcode(186, "ushr-int/2addr", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode ADD_LONG_2ADDR = new Opcode(187, "add-long/2addr", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode SUB_LONG_2ADDR = new Opcode(188, "sub-long/2addr", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode MUL_LONG_2ADDR = new Opcode(189, "mul-long/2addr", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode DIV_LONG_2ADDR = new Opcode(190, "div-long/2addr", ReferenceType.none, Format.Format12x, 53);
    public static final /* enum */ Opcode REM_LONG_2ADDR = new Opcode(191, "rem-long/2addr", ReferenceType.none, Format.Format12x, 53);
    public static final /* enum */ Opcode AND_LONG_2ADDR = new Opcode(192, "and-long/2addr", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode OR_LONG_2ADDR = new Opcode(193, "or-long/2addr", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode XOR_LONG_2ADDR = new Opcode(194, "xor-long/2addr", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode SHL_LONG_2ADDR = new Opcode(195, "shl-long/2addr", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode SHR_LONG_2ADDR = new Opcode(196, "shr-long/2addr", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode USHR_LONG_2ADDR = new Opcode(197, "ushr-long/2addr", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode ADD_FLOAT_2ADDR = new Opcode(198, "add-float/2addr", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode SUB_FLOAT_2ADDR = new Opcode(199, "sub-float/2addr", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode MUL_FLOAT_2ADDR = new Opcode(200, "mul-float/2addr", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode DIV_FLOAT_2ADDR = new Opcode(201, "div-float/2addr", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode REM_FLOAT_2ADDR = new Opcode(202, "rem-float/2addr", ReferenceType.none, Format.Format12x, 20);
    public static final /* enum */ Opcode ADD_DOUBLE_2ADDR = new Opcode(203, "add-double/2addr", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode SUB_DOUBLE_2ADDR = new Opcode(204, "sub-double/2addr", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode MUL_DOUBLE_2ADDR = new Opcode(205, "mul-double/2addr", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode DIV_DOUBLE_2ADDR = new Opcode(206, "div-double/2addr", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode REM_DOUBLE_2ADDR = new Opcode(207, "rem-double/2addr", ReferenceType.none, Format.Format12x, 52);
    public static final /* enum */ Opcode ADD_INT_LIT16 = new Opcode(208, "add-int/lit16", ReferenceType.none, Format.Format22s, 20);
    public static final /* enum */ Opcode RSUB_INT = new Opcode(209, "rsub-int", ReferenceType.none, Format.Format22s, 20);
    public static final /* enum */ Opcode MUL_INT_LIT16 = new Opcode(210, "mul-int/lit16", ReferenceType.none, Format.Format22s, 20);
    public static final /* enum */ Opcode DIV_INT_LIT16 = new Opcode(211, "div-int/lit16", ReferenceType.none, Format.Format22s, 21);
    public static final /* enum */ Opcode REM_INT_LIT16 = new Opcode(212, "rem-int/lit16", ReferenceType.none, Format.Format22s, 21);
    public static final /* enum */ Opcode AND_INT_LIT16 = new Opcode(213, "and-int/lit16", ReferenceType.none, Format.Format22s, 20);
    public static final /* enum */ Opcode OR_INT_LIT16 = new Opcode(214, "or-int/lit16", ReferenceType.none, Format.Format22s, 20);
    public static final /* enum */ Opcode XOR_INT_LIT16 = new Opcode(215, "xor-int/lit16", ReferenceType.none, Format.Format22s, 20);
    public static final /* enum */ Opcode ADD_INT_LIT8 = new Opcode(216, "add-int/lit8", ReferenceType.none, Format.Format22b, 20);
    public static final /* enum */ Opcode RSUB_INT_LIT8 = new Opcode(217, "rsub-int/lit8", ReferenceType.none, Format.Format22b, 20);
    public static final /* enum */ Opcode MUL_INT_LIT8 = new Opcode(218, "mul-int/lit8", ReferenceType.none, Format.Format22b, 20);
    public static final /* enum */ Opcode DIV_INT_LIT8 = new Opcode(219, "div-int/lit8", ReferenceType.none, Format.Format22b, 21);
    public static final /* enum */ Opcode REM_INT_LIT8 = new Opcode(220, "rem-int/lit8", ReferenceType.none, Format.Format22b, 21);
    public static final /* enum */ Opcode AND_INT_LIT8 = new Opcode(221, "and-int/lit8", ReferenceType.none, Format.Format22b, 20);
    public static final /* enum */ Opcode OR_INT_LIT8 = new Opcode(222, "or-int/lit8", ReferenceType.none, Format.Format22b, 20);
    public static final /* enum */ Opcode XOR_INT_LIT8 = new Opcode(223, "xor-int/lit8", ReferenceType.none, Format.Format22b, 20);
    public static final /* enum */ Opcode SHL_INT_LIT8 = new Opcode(224, "shl-int/lit8", ReferenceType.none, Format.Format22b, 20);
    public static final /* enum */ Opcode SHR_INT_LIT8 = new Opcode(225, "shr-int/lit8", ReferenceType.none, Format.Format22b, 20);
    public static final /* enum */ Opcode USHR_INT_LIT8 = new Opcode(226, "ushr-int/lit8", ReferenceType.none, Format.Format22b, 20);
    public static final /* enum */ Opcode IGET_VOLATILE = new Opcode(227, "iget-volatile", ReferenceType.field, Format.Format22c, 151);
    public static final /* enum */ Opcode IPUT_VOLATILE = new Opcode(228, "iput-volatile", ReferenceType.field, Format.Format22c, 135);
    public static final /* enum */ Opcode SGET_VOLATILE = new Opcode(229, "sget-volatile", ReferenceType.field, Format.Format21c, 279);
    public static final /* enum */ Opcode SPUT_VOLATILE = new Opcode(230, "sput-volatile", ReferenceType.field, Format.Format21c, 263);
    public static final /* enum */ Opcode IGET_OBJECT_VOLATILE = new Opcode(231, "iget-object-volatile", ReferenceType.field, Format.Format22c, 151);
    public static final /* enum */ Opcode IGET_WIDE_VOLATILE = new Opcode(232, "iget-wide-volatile", ReferenceType.field, Format.Format22c, 183);
    public static final /* enum */ Opcode IPUT_WIDE_VOLATILE = new Opcode(233, "iput-wide-volatile", ReferenceType.field, Format.Format22c, 135);
    public static final /* enum */ Opcode SGET_WIDE_VOLATILE = new Opcode(234, "sget-wide-volatile", ReferenceType.field, Format.Format21c, 311);
    public static final /* enum */ Opcode SPUT_WIDE_VOLATILE = new Opcode(235, "sput-wide-volatile", ReferenceType.field, Format.Format21c, 263);
    public static final /* enum */ Opcode THROW_VERIFICATION_ERROR = new Opcode(237, "throw-verification-error", ReferenceType.none, Format.Format20bc, 3);
    public static final /* enum */ Opcode EXECUTE_INLINE = new Opcode(238, "execute-inline", ReferenceType.none, Format.Format35mi, 15);
    public static final /* enum */ Opcode EXECUTE_INLINE_RANGE = new Opcode(239, "execute-inline/range", ReferenceType.none, Format.Format3rmi, 15);
    public static final /* enum */ Opcode INVOKE_DIRECT_EMPTY = new Opcode(240, "invoke-direct-empty", ReferenceType.method, Format.Format35c, 1039);
    public static final /* enum */ Opcode INVOKE_OBJECT_INIT_RANGE = new Opcode(240, "invoke-object-init/range", ReferenceType.method, Format.Format3rc, 1039);
    public static final /* enum */ Opcode RETURN_VOID_BARRIER = new Opcode(241, "return-void-barrier", ReferenceType.none, Format.Format10x, 2);
    public static final /* enum */ Opcode IGET_QUICK = new Opcode(242, "iget-quick", ReferenceType.none, Format.Format22cs, 87);
    public static final /* enum */ Opcode IGET_WIDE_QUICK = new Opcode(243, "iget-wide-quick", ReferenceType.none, Format.Format22cs, 119);
    public static final /* enum */ Opcode IGET_OBJECT_QUICK = new Opcode(244, "iget-object-quick", ReferenceType.none, Format.Format22cs, 87);
    public static final /* enum */ Opcode IPUT_QUICK = new Opcode(245, "iput-quick", ReferenceType.none, Format.Format22cs, 71);
    public static final /* enum */ Opcode IPUT_WIDE_QUICK = new Opcode(246, "iput-wide-quick", ReferenceType.none, Format.Format22cs, 71);
    public static final /* enum */ Opcode IPUT_OBJECT_QUICK = new Opcode(247, "iput-object-quick", ReferenceType.none, Format.Format22cs, 71);
    public static final /* enum */ Opcode INVOKE_VIRTUAL_QUICK = new Opcode(248, "invoke-virtual-quick", ReferenceType.none, Format.Format35ms, 15);
    public static final /* enum */ Opcode INVOKE_VIRTUAL_QUICK_RANGE = new Opcode(249, "invoke-virtual-quick/range", ReferenceType.none, Format.Format3rms, 15);
    public static final /* enum */ Opcode INVOKE_SUPER_QUICK = new Opcode(250, "invoke-super-quick", ReferenceType.none, Format.Format35ms, 15);
    public static final /* enum */ Opcode INVOKE_SUPER_QUICK_RANGE = new Opcode(251, "invoke-super-quick/range", ReferenceType.none, Format.Format3rms, 15);
    public static final /* enum */ Opcode IPUT_OBJECT_VOLATILE = new Opcode(252, "iput-object-volatile", ReferenceType.field, Format.Format22c, 135);
    public static final /* enum */ Opcode SGET_OBJECT_VOLATILE = new Opcode(253, "sget-object-volatile", ReferenceType.field, Format.Format21c, 279);
    public static final /* enum */ Opcode SPUT_OBJECT_VOLATILE = new Opcode(254, "sput-object-volatile", ReferenceType.field, Format.Format21c, 263);
    public static final /* enum */ Opcode CONST_CLASS_JUMBO = new Opcode(-256, "const-class/jumbo", ReferenceType.type, Format.Format41c, 533);
    public static final /* enum */ Opcode CHECK_CAST_JUMBO = new Opcode(-255, "check-cast/jumbo", ReferenceType.type, Format.Format41c, 533);
    public static final /* enum */ Opcode INSTANCE_OF_JUMBO = new Opcode(-254, "instance-of/jumbo", ReferenceType.type, Format.Format52c, 533);
    public static final /* enum */ Opcode NEW_INSTANCE_JUMBO = new Opcode(-253, "new-instance/jumbo", ReferenceType.type, Format.Format41c, 533);
    public static final /* enum */ Opcode NEW_ARRAY_JUMBO = new Opcode(-252, "new-array/jumbo", ReferenceType.type, Format.Format52c, 533);
    public static final /* enum */ Opcode FILLED_NEW_ARRAY_JUMBO = new Opcode(-251, "filled-new-array/jumbo", ReferenceType.type, Format.Format5rc, 525);
    public static final /* enum */ Opcode IGET_JUMBO = new Opcode(-250, "iget/jumbo", ReferenceType.field, Format.Format52c, 533);
    public static final /* enum */ Opcode IGET_WIDE_JUMBO = new Opcode(-249, "iget-wide/jumbo", ReferenceType.field, Format.Format52c, 565);
    public static final /* enum */ Opcode IGET_OBJECT_JUMBO = new Opcode(-248, "iget-object/jumbo", ReferenceType.field, Format.Format52c, 533);
    public static final /* enum */ Opcode IGET_BOOLEAN_JUMBO = new Opcode(-247, "iget-boolean/jumbo", ReferenceType.field, Format.Format52c, 533);
    public static final /* enum */ Opcode IGET_BYTE_JUMBO = new Opcode(-246, "iget-byte/jumbo", ReferenceType.field, Format.Format52c, 533);
    public static final /* enum */ Opcode IGET_CHAR_JUMBO = new Opcode(-245, "iget-char/jumbo", ReferenceType.field, Format.Format52c, 533);
    public static final /* enum */ Opcode IGET_SHORT_JUMBO = new Opcode(-244, "iget-short/jumbo", ReferenceType.field, Format.Format52c, 533);
    public static final /* enum */ Opcode IPUT_JUMBO = new Opcode(-243, "iput/jumbo", ReferenceType.field, Format.Format52c, 517);
    public static final /* enum */ Opcode IPUT_WIDE_JUMBO = new Opcode(-242, "iput-wide/jumbo", ReferenceType.field, Format.Format52c, 517);
    public static final /* enum */ Opcode IPUT_OBJECT_JUMBO = new Opcode(-241, "iput-object/jumbo", ReferenceType.field, Format.Format52c, 517);
    public static final /* enum */ Opcode IPUT_BOOLEAN_JUMBO = new Opcode(-240, "iput-boolean/jumbo", ReferenceType.field, Format.Format52c, 517);
    public static final /* enum */ Opcode IPUT_BYTE_JUMBO = new Opcode(-239, "iput-byte/jumbo", ReferenceType.field, Format.Format52c, 517);
    public static final /* enum */ Opcode IPUT_CHAR_JUMBO = new Opcode(-238, "iput-char/jumbo", ReferenceType.field, Format.Format52c, 517);
    public static final /* enum */ Opcode IPUT_SHORT_JUMBO = new Opcode(-237, "iput-short/jumbo", ReferenceType.field, Format.Format52c, 517);
    public static final /* enum */ Opcode SGET_JUMBO = new Opcode(-236, "sget/jumbo", ReferenceType.field, Format.Format41c, 533);
    public static final /* enum */ Opcode SGET_WIDE_JUMBO = new Opcode(-235, "sget-wide/jumbo", ReferenceType.field, Format.Format41c, 565);
    public static final /* enum */ Opcode SGET_OBJECT_JUMBO = new Opcode(-234, "sget-object/jumbo", ReferenceType.field, Format.Format41c, 533);
    public static final /* enum */ Opcode SGET_BOOLEAN_JUMBO = new Opcode(-233, "sget-boolean/jumbo", ReferenceType.field, Format.Format41c, 533);
    public static final /* enum */ Opcode SGET_BYTE_JUMBO = new Opcode(-232, "sget-byte/jumbo", ReferenceType.field, Format.Format41c, 533);
    public static final /* enum */ Opcode SGET_CHAR_JUMBO = new Opcode(-231, "sget-char/jumbo", ReferenceType.field, Format.Format41c, 533);
    public static final /* enum */ Opcode SGET_SHORT_JUMBO = new Opcode(-230, "sget-short/jumbo", ReferenceType.field, Format.Format41c, 533);
    public static final /* enum */ Opcode SPUT_JUMBO = new Opcode(-229, "sput/jumbo", ReferenceType.field, Format.Format41c, 517);
    public static final /* enum */ Opcode SPUT_WIDE_JUMBO = new Opcode(-228, "sput-wide/jumbo", ReferenceType.field, Format.Format41c, 517);
    public static final /* enum */ Opcode SPUT_OBJECT_JUMBO = new Opcode(-227, "sput-object/jumbo", ReferenceType.field, Format.Format41c, 517);
    public static final /* enum */ Opcode SPUT_BOOLEAN_JUMBO = new Opcode(-226, "sput-boolean/jumbo", ReferenceType.field, Format.Format41c, 517);
    public static final /* enum */ Opcode SPUT_BYTE_JUMBO = new Opcode(-225, "sput-byte/jumbo", ReferenceType.field, Format.Format41c, 517);
    public static final /* enum */ Opcode SPUT_CHAR_JUMBO = new Opcode(-224, "sput-char/jumbo", ReferenceType.field, Format.Format41c, 517);
    public static final /* enum */ Opcode SPUT_SHORT_JUMBO = new Opcode(-223, "sput-short/jumbo", ReferenceType.field, Format.Format41c, 517);
    public static final /* enum */ Opcode INVOKE_VIRTUAL_JUMBO = new Opcode(-222, "invoke-virtual/jumbo", ReferenceType.method, Format.Format5rc, 525);
    public static final /* enum */ Opcode INVOKE_SUPER_JUMBO = new Opcode(-221, "invoke-super/jumbo", ReferenceType.method, Format.Format5rc, 525);
    public static final /* enum */ Opcode INVOKE_DIRECT_JUMBO = new Opcode(-220, "invoke-direct/jumbo", ReferenceType.method, Format.Format5rc, 1549);
    public static final /* enum */ Opcode INVOKE_STATIC_JUMBO = new Opcode(-219, "invoke-static/jumbo", ReferenceType.method, Format.Format5rc, 525);
    public static final /* enum */ Opcode INVOKE_INTERFACE_JUMBO = new Opcode(-218, "invoke-interface/jumbo", ReferenceType.method, Format.Format5rc, 525);
    public static final /* enum */ Opcode INVOKE_OBJECT_INIT_JUMBO = new Opcode(-14, "invoke-object-init/jumbo", ReferenceType.method, Format.Format5rc, 1551);
    public static final /* enum */ Opcode IGET_VOLATILE_JUMBO = new Opcode(-13, "iget-volatile/jumbo", ReferenceType.field, Format.Format52c, 663);
    public static final /* enum */ Opcode IGET_WIDE_VOLATILE_JUMBO = new Opcode(-12, "iget-wide-volatile/jumbo", ReferenceType.field, Format.Format52c, 695);
    public static final /* enum */ Opcode IGET_OBJECT_VOLATILE_JUMBO = new Opcode(-11, "iget-object-volatile/jumbo", ReferenceType.field, Format.Format52c, 663);
    public static final /* enum */ Opcode IPUT_VOLATILE_JUMBO = new Opcode(-10, "iput-volatile/jumbo", ReferenceType.field, Format.Format52c, 647);
    public static final /* enum */ Opcode IPUT_WIDE_VOLATILE_JUMBO = new Opcode(-9, "iput-wide-volatile/jumbo", ReferenceType.field, Format.Format52c, 647);
    public static final /* enum */ Opcode IPUT_OBJECT_VOLATILE_JUMBO = new Opcode(-8, "iput-object-volatile/jumbo", ReferenceType.field, Format.Format52c, 647);
    public static final /* enum */ Opcode SGET_VOLATILE_JUMBO = new Opcode(-7, "sget-volatile/jumbo", ReferenceType.field, Format.Format41c, 791);
    public static final /* enum */ Opcode SGET_WIDE_VOLATILE_JUMBO = new Opcode(-6, "sget-wide-volatile/jumbo", ReferenceType.field, Format.Format41c, 823);
    public static final /* enum */ Opcode SGET_OBJECT_VOLATILE_JUMBO = new Opcode(-5, "sget-object-volatile/jumbo", ReferenceType.field, Format.Format41c, 791);
    public static final /* enum */ Opcode SPUT_VOLATILE_JUMBO = new Opcode(-4, "sput-volatile/jumbo", ReferenceType.field, Format.Format41c, 775);
    public static final /* enum */ Opcode SPUT_WIDE_VOLATILE_JUMBO = new Opcode(-3, "sput-wide-volatile/jumbo", ReferenceType.field, Format.Format41c, 775);
    public static final /* enum */ Opcode SPUT_OBJECT_VOLATILE_JUMBO = new Opcode(-2, "sput-object-volatile/jumbo", ReferenceType.field, Format.Format41c, 775);
    private static Opcode[] opcodesByValue;
    private static Opcode[] expandedOpcodesByValue;
    private static HashMap<Integer, Opcode> opcodesByName;
    public static final int CAN_THROW = 1;
    public static final int ODEX_ONLY = 2;
    public static final int CAN_CONTINUE = 4;
    public static final int SETS_RESULT = 8;
    public static final int SETS_REGISTER = 16;
    public static final int SETS_WIDE_REGISTER = 32;
    public static final int ODEXED_INSTANCE_QUICK = 64;
    public static final int ODEXED_INSTANCE_VOLATILE = 128;
    public static final int ODEXED_STATIC_VOLATILE = 256;
    public static final int JUMBO_OPCODE = 512;
    public static final int CAN_INITIALIZE_REFERENCE = 1024;
    public final short value;
    public final String name;
    public final ReferenceType referenceType;
    public final Format format;
    public final int flags;
    private final short jumboOpcode;
    private static final /* synthetic */ Opcode[] $VALUES;

    public static Opcode[] values() {
        return (Opcode[])$VALUES.clone();
    }

    public static Opcode valueOf(String name) {
        return Enum.valueOf(Opcode.class, name);
    }

    public static Opcode getOpcodeByName(String opcodeName) {
        return opcodesByName.get(opcodeName.toLowerCase().hashCode());
    }

    public static Opcode getOpcodeByValue(short opcodeValue) {
        if ((opcodeValue >> 8 & 0xFF) == 0) {
            return opcodesByValue[opcodeValue & 0xFF];
        }
        assert ((opcodeValue >> 8 & 0xFF) == 255);
        return expandedOpcodesByValue[opcodeValue & 0xFF];
    }

    private static void removeOpcodes(Opcode ... toRemove) {
        for (Opcode opcode : toRemove) {
            opcodesByName.remove(opcode.name.toLowerCase().hashCode());
            if ((opcode.value >> 8 & 0xFF) == 0) {
                Opcode.opcodesByValue[opcode.value] = null;
                continue;
            }
            Opcode.expandedOpcodesByValue[opcode.value & 0xFF] = null;
        }
    }

    private static void addOpcodes(Opcode ... toAdd) {
        for (Opcode opcode : toAdd) {
            if ((opcode.value >> 8 & 0xFF) == 0) {
                Opcode.opcodesByValue[opcode.value & 0xFF] = opcode;
            } else {
                assert ((opcode.value >> 8 & 0xFF) == 255);
                Opcode.expandedOpcodesByValue[opcode.value & 0xFF] = opcode;
            }
            opcodesByName.put(opcode.name.hashCode(), opcode);
        }
    }

    public static void updateMapsForApiLevel(int apiLevel, boolean includeJumbo) {
        if (apiLevel < 5) {
            Opcode.removeOpcodes(THROW_VERIFICATION_ERROR);
        }
        if (apiLevel < 8) {
            Opcode.removeOpcodes(EXECUTE_INLINE_RANGE);
        }
        if (apiLevel < 9) {
            Opcode.removeOpcodes(IGET_VOLATILE, IPUT_VOLATILE, SGET_VOLATILE, SPUT_VOLATILE, IGET_OBJECT_VOLATILE, IGET_WIDE_VOLATILE, IPUT_WIDE_VOLATILE, SGET_WIDE_VOLATILE, SPUT_WIDE_VOLATILE, IPUT_OBJECT_VOLATILE, SGET_OBJECT_VOLATILE, SPUT_OBJECT_VOLATILE);
        }
        if (apiLevel < 11) {
            Opcode.removeOpcodes(RETURN_VOID_BARRIER);
        }
        if (apiLevel < 14) {
            Opcode.removeOpcodes(INVOKE_OBJECT_INIT_RANGE);
            Opcode.addOpcodes(INVOKE_DIRECT_EMPTY);
        }
        if (apiLevel < 14 || !includeJumbo) {
            Opcode.removeOpcodes(CONST_CLASS_JUMBO, CHECK_CAST_JUMBO, INSTANCE_OF_JUMBO, NEW_INSTANCE_JUMBO, NEW_ARRAY_JUMBO, FILLED_NEW_ARRAY_JUMBO, IGET_JUMBO, IGET_WIDE_JUMBO, IGET_OBJECT_JUMBO, IGET_BOOLEAN_JUMBO, IGET_BYTE_JUMBO, IGET_CHAR_JUMBO, IGET_SHORT_JUMBO, IPUT_JUMBO, IPUT_WIDE_JUMBO, IPUT_OBJECT_JUMBO, IPUT_BOOLEAN_JUMBO, IPUT_BYTE_JUMBO, IPUT_CHAR_JUMBO, IPUT_SHORT_JUMBO, SGET_JUMBO, SGET_WIDE_JUMBO, SGET_OBJECT_JUMBO, SGET_BOOLEAN_JUMBO, SGET_BYTE_JUMBO, SGET_CHAR_JUMBO, SGET_SHORT_JUMBO, SPUT_JUMBO, SPUT_WIDE_JUMBO, SPUT_OBJECT_JUMBO, SPUT_BOOLEAN_JUMBO, SPUT_BYTE_JUMBO, SPUT_CHAR_JUMBO, SPUT_SHORT_JUMBO, INVOKE_VIRTUAL_JUMBO, INVOKE_SUPER_JUMBO, INVOKE_DIRECT_JUMBO, INVOKE_STATIC_JUMBO, INVOKE_INTERFACE_JUMBO, INVOKE_OBJECT_INIT_JUMBO, IGET_VOLATILE_JUMBO, IGET_WIDE_VOLATILE_JUMBO, IGET_OBJECT_VOLATILE_JUMBO, IPUT_VOLATILE_JUMBO, IPUT_WIDE_VOLATILE_JUMBO, IPUT_OBJECT_VOLATILE_JUMBO, SGET_VOLATILE_JUMBO, SGET_WIDE_VOLATILE_JUMBO, SGET_OBJECT_VOLATILE_JUMBO, SPUT_VOLATILE_JUMBO, SPUT_WIDE_VOLATILE_JUMBO, SPUT_OBJECT_VOLATILE_JUMBO);
        }
    }

    private Opcode(short opcodeValue, String opcodeName, ReferenceType referenceType, Format format) {
        this(opcodeValue, opcodeName, referenceType, format, 0);
    }

    private Opcode(short opcodeValue, String opcodeName, ReferenceType referenceType, Format format, int flags) {
        this(opcodeValue, opcodeName, referenceType, format, flags, -1);
    }

    private Opcode(short opcodeValue, String opcodeName, ReferenceType referenceType, Format format, int flags, short jumboOpcodeValue) {
        this.value = opcodeValue;
        this.name = opcodeName;
        this.referenceType = referenceType;
        this.format = format;
        this.flags = flags;
        this.jumboOpcode = jumboOpcodeValue;
    }

    public final boolean canThrow() {
        return (this.flags & 1) != 0;
    }

    public final boolean odexOnly() {
        return (this.flags & 2) != 0;
    }

    public final boolean canContinue() {
        return (this.flags & 4) != 0;
    }

    public final boolean setsResult() {
        return (this.flags & 8) != 0;
    }

    public final boolean setsRegister() {
        return (this.flags & 0x10) != 0;
    }

    public final boolean setsWideRegister() {
        return (this.flags & 0x20) != 0;
    }

    public final boolean isOdexedInstanceQuick() {
        return (this.flags & 0x40) != 0;
    }

    public final boolean isOdexedInstanceVolatile() {
        return (this.flags & 0x80) != 0;
    }

    public final boolean isOdexedStaticVolatile() {
        return (this.flags & 0x100) != 0;
    }

    public final boolean isJumboOpcode() {
        return (this.flags & 0x200) != 0;
    }

    public final boolean canInitializeReference() {
        return (this.flags & 0x400) != 0;
    }

    public final boolean hasJumboOpcode() {
        return this.jumboOpcode != -1 && Opcode.getOpcodeByValue(this.jumboOpcode) != null;
    }

    public final Opcode getJumboOpcode() {
        return Opcode.getOpcodeByValue(this.jumboOpcode);
    }

    static {
        $VALUES = new Opcode[]{NOP, MOVE, MOVE_FROM16, MOVE_16, MOVE_WIDE, MOVE_WIDE_FROM16, MOVE_WIDE_16, MOVE_OBJECT, MOVE_OBJECT_FROM16, MOVE_OBJECT_16, MOVE_RESULT, MOVE_RESULT_WIDE, MOVE_RESULT_OBJECT, MOVE_EXCEPTION, RETURN_VOID, RETURN, RETURN_WIDE, RETURN_OBJECT, CONST_4, CONST_16, CONST, CONST_HIGH16, CONST_WIDE_16, CONST_WIDE_32, CONST_WIDE, CONST_WIDE_HIGH16, CONST_STRING, CONST_STRING_JUMBO, CONST_CLASS, MONITOR_ENTER, MONITOR_EXIT, CHECK_CAST, INSTANCE_OF, ARRAY_LENGTH, NEW_INSTANCE, NEW_ARRAY, FILLED_NEW_ARRAY, FILLED_NEW_ARRAY_RANGE, FILL_ARRAY_DATA, THROW, GOTO, GOTO_16, GOTO_32, PACKED_SWITCH, SPARSE_SWITCH, CMPL_FLOAT, CMPG_FLOAT, CMPL_DOUBLE, CMPG_DOUBLE, CMP_LONG, IF_EQ, IF_NE, IF_LT, IF_GE, IF_GT, IF_LE, IF_EQZ, IF_NEZ, IF_LTZ, IF_GEZ, IF_GTZ, IF_LEZ, AGET, AGET_WIDE, AGET_OBJECT, AGET_BOOLEAN, AGET_BYTE, AGET_CHAR, AGET_SHORT, APUT, APUT_WIDE, APUT_OBJECT, APUT_BOOLEAN, APUT_BYTE, APUT_CHAR, APUT_SHORT, IGET, IGET_WIDE, IGET_OBJECT, IGET_BOOLEAN, IGET_BYTE, IGET_CHAR, IGET_SHORT, IPUT, IPUT_WIDE, IPUT_OBJECT, IPUT_BOOLEAN, IPUT_BYTE, IPUT_CHAR, IPUT_SHORT, SGET, SGET_WIDE, SGET_OBJECT, SGET_BOOLEAN, SGET_BYTE, SGET_CHAR, SGET_SHORT, SPUT, SPUT_WIDE, SPUT_OBJECT, SPUT_BOOLEAN, SPUT_BYTE, SPUT_CHAR, SPUT_SHORT, INVOKE_VIRTUAL, INVOKE_SUPER, INVOKE_DIRECT, INVOKE_STATIC, INVOKE_INTERFACE, INVOKE_VIRTUAL_RANGE, INVOKE_SUPER_RANGE, INVOKE_DIRECT_RANGE, INVOKE_STATIC_RANGE, INVOKE_INTERFACE_RANGE, NEG_INT, NOT_INT, NEG_LONG, NOT_LONG, NEG_FLOAT, NEG_DOUBLE, INT_TO_LONG, INT_TO_FLOAT, INT_TO_DOUBLE, LONG_TO_INT, LONG_TO_FLOAT, LONG_TO_DOUBLE, FLOAT_TO_INT, FLOAT_TO_LONG, FLOAT_TO_DOUBLE, DOUBLE_TO_INT, DOUBLE_TO_LONG, DOUBLE_TO_FLOAT, INT_TO_BYTE, INT_TO_CHAR, INT_TO_SHORT, ADD_INT, SUB_INT, MUL_INT, DIV_INT, REM_INT, AND_INT, OR_INT, XOR_INT, SHL_INT, SHR_INT, USHR_INT, ADD_LONG, SUB_LONG, MUL_LONG, DIV_LONG, REM_LONG, AND_LONG, OR_LONG, XOR_LONG, SHL_LONG, SHR_LONG, USHR_LONG, ADD_FLOAT, SUB_FLOAT, MUL_FLOAT, DIV_FLOAT, REM_FLOAT, ADD_DOUBLE, SUB_DOUBLE, MUL_DOUBLE, DIV_DOUBLE, REM_DOUBLE, ADD_INT_2ADDR, SUB_INT_2ADDR, MUL_INT_2ADDR, DIV_INT_2ADDR, REM_INT_2ADDR, AND_INT_2ADDR, OR_INT_2ADDR, XOR_INT_2ADDR, SHL_INT_2ADDR, SHR_INT_2ADDR, USHR_INT_2ADDR, ADD_LONG_2ADDR, SUB_LONG_2ADDR, MUL_LONG_2ADDR, DIV_LONG_2ADDR, REM_LONG_2ADDR, AND_LONG_2ADDR, OR_LONG_2ADDR, XOR_LONG_2ADDR, SHL_LONG_2ADDR, SHR_LONG_2ADDR, USHR_LONG_2ADDR, ADD_FLOAT_2ADDR, SUB_FLOAT_2ADDR, MUL_FLOAT_2ADDR, DIV_FLOAT_2ADDR, REM_FLOAT_2ADDR, ADD_DOUBLE_2ADDR, SUB_DOUBLE_2ADDR, MUL_DOUBLE_2ADDR, DIV_DOUBLE_2ADDR, REM_DOUBLE_2ADDR, ADD_INT_LIT16, RSUB_INT, MUL_INT_LIT16, DIV_INT_LIT16, REM_INT_LIT16, AND_INT_LIT16, OR_INT_LIT16, XOR_INT_LIT16, ADD_INT_LIT8, RSUB_INT_LIT8, MUL_INT_LIT8, DIV_INT_LIT8, REM_INT_LIT8, AND_INT_LIT8, OR_INT_LIT8, XOR_INT_LIT8, SHL_INT_LIT8, SHR_INT_LIT8, USHR_INT_LIT8, IGET_VOLATILE, IPUT_VOLATILE, SGET_VOLATILE, SPUT_VOLATILE, IGET_OBJECT_VOLATILE, IGET_WIDE_VOLATILE, IPUT_WIDE_VOLATILE, SGET_WIDE_VOLATILE, SPUT_WIDE_VOLATILE, THROW_VERIFICATION_ERROR, EXECUTE_INLINE, EXECUTE_INLINE_RANGE, INVOKE_DIRECT_EMPTY, INVOKE_OBJECT_INIT_RANGE, RETURN_VOID_BARRIER, IGET_QUICK, IGET_WIDE_QUICK, IGET_OBJECT_QUICK, IPUT_QUICK, IPUT_WIDE_QUICK, IPUT_OBJECT_QUICK, INVOKE_VIRTUAL_QUICK, INVOKE_VIRTUAL_QUICK_RANGE, INVOKE_SUPER_QUICK, INVOKE_SUPER_QUICK_RANGE, IPUT_OBJECT_VOLATILE, SGET_OBJECT_VOLATILE, SPUT_OBJECT_VOLATILE, CONST_CLASS_JUMBO, CHECK_CAST_JUMBO, INSTANCE_OF_JUMBO, NEW_INSTANCE_JUMBO, NEW_ARRAY_JUMBO, FILLED_NEW_ARRAY_JUMBO, IGET_JUMBO, IGET_WIDE_JUMBO, IGET_OBJECT_JUMBO, IGET_BOOLEAN_JUMBO, IGET_BYTE_JUMBO, IGET_CHAR_JUMBO, IGET_SHORT_JUMBO, IPUT_JUMBO, IPUT_WIDE_JUMBO, IPUT_OBJECT_JUMBO, IPUT_BOOLEAN_JUMBO, IPUT_BYTE_JUMBO, IPUT_CHAR_JUMBO, IPUT_SHORT_JUMBO, SGET_JUMBO, SGET_WIDE_JUMBO, SGET_OBJECT_JUMBO, SGET_BOOLEAN_JUMBO, SGET_BYTE_JUMBO, SGET_CHAR_JUMBO, SGET_SHORT_JUMBO, SPUT_JUMBO, SPUT_WIDE_JUMBO, SPUT_OBJECT_JUMBO, SPUT_BOOLEAN_JUMBO, SPUT_BYTE_JUMBO, SPUT_CHAR_JUMBO, SPUT_SHORT_JUMBO, INVOKE_VIRTUAL_JUMBO, INVOKE_SUPER_JUMBO, INVOKE_DIRECT_JUMBO, INVOKE_STATIC_JUMBO, INVOKE_INTERFACE_JUMBO, INVOKE_OBJECT_INIT_JUMBO, IGET_VOLATILE_JUMBO, IGET_WIDE_VOLATILE_JUMBO, IGET_OBJECT_VOLATILE_JUMBO, IPUT_VOLATILE_JUMBO, IPUT_WIDE_VOLATILE_JUMBO, IPUT_OBJECT_VOLATILE_JUMBO, SGET_VOLATILE_JUMBO, SGET_WIDE_VOLATILE_JUMBO, SGET_OBJECT_VOLATILE_JUMBO, SPUT_VOLATILE_JUMBO, SPUT_WIDE_VOLATILE_JUMBO, SPUT_OBJECT_VOLATILE_JUMBO};
        opcodesByValue = new Opcode[256];
        expandedOpcodesByValue = new Opcode[256];
        opcodesByName = new HashMap();
        for (Opcode opcode : Opcode.values()) {
            if (opcode == INVOKE_DIRECT_EMPTY) continue;
            if ((opcode.value >> 8 & 0xFF) == 0) {
                Opcode.opcodesByValue[opcode.value & 0xFF] = opcode;
            } else {
                assert ((opcode.value >> 8 & 0xFF) == 255);
                Opcode.expandedOpcodesByValue[opcode.value & 0xFF] = opcode;
            }
            opcodesByName.put(opcode.name.hashCode(), opcode);
        }
    }
}

