/*
 * Decompiled with CFR 0.152.
 */
package mobiledevices.dmg.reader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import mobiledevices.dmg.decmpfs.DecmpfsHeader;
import mobiledevices.dmg.ghidra.GByteProvider;
import mobiledevices.dmg.ghidra.GDataConverter;
import mobiledevices.dmg.ghidra.GDataConverterBE;
import mobiledevices.dmg.ghidra.GDataConverterLE;
import mobiledevices.dmg.ghidra.GFileUtilityMethods;
import mobiledevices.dmg.hfsplus.AttributesFileParser;
import mobiledevices.dmg.reader.DmgInfoGenerator;
import mobiledevices.dmg.reader.DmgInputStream;
import mobiledevices.dmg.zlib.ZLIB;
import org.catacombae.dmgextractor.encodings.encrypted.ReadableCEncryptedEncodingStream;
import org.catacombae.hfsexplorer.FileSystemRecognizer;
import org.catacombae.hfsexplorer.PartitionSystemRecognizer;
import org.catacombae.hfsexplorer.UDIFRecognizer;
import org.catacombae.hfsexplorer.partitioning.Partition;
import org.catacombae.hfsexplorer.partitioning.PartitionSystem;
import org.catacombae.hfsexplorer.win32.WindowsLowLevelIO;
import org.catacombae.io.ReadableConcatenatedStream;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.jparted.lib.DataLocator;
import org.catacombae.jparted.lib.ReadableStreamDataLocator;
import org.catacombae.jparted.lib.fs.FSEntry;
import org.catacombae.jparted.lib.fs.FSFile;
import org.catacombae.jparted.lib.fs.FSFolder;
import org.catacombae.jparted.lib.fs.FSFork;
import org.catacombae.jparted.lib.fs.FSForkType;
import org.catacombae.jparted.lib.fs.FileSystemHandler;
import org.catacombae.jparted.lib.fs.FileSystemHandlerFactory;
import org.catacombae.jparted.lib.fs.FileSystemMajorType;
import org.catacombae.jparted.lib.fs.hfsx.HFSXFileSystemHandler;
import org.catacombae.udif.UDIFFile;
import org.catacombae.udif.UDIFRandomAccessStream;

public class DmgFileReader
implements Closeable {
    private static final GDataConverter ledc = new GDataConverterLE();
    private static final GDataConverter bedc = new GDataConverterBE();
    private GByteProvider provider;
    private AttributesFileParser parser;
    private ReadableRandomAccessStream rras;
    private List<FSFolder> rootFolders = new ArrayList<FSFolder>();
    private List<FileSystemHandler> fileSystemHandlers = new ArrayList<FileSystemHandler>();

    public DmgFileReader(GByteProvider provider) {
        this.provider = provider;
    }

    public void open() throws IOException {
        Partition[] partitions;
        File file = this.provider.getFile();
        this.rras = WindowsLowLevelIO.isSystemSupported() ? new WindowsLowLevelIO(file.getAbsolutePath()) : new ReadableFileStream(file.getAbsolutePath());
        if (ReadableCEncryptedEncodingStream.isCEncryptedEncoding((ReadableRandomAccessStream)this.rras)) {
            // empty if block
        }
        System.err.println("Trying to detect UDIF structure...");
        if (UDIFRecognizer.isUDIF((ReadableRandomAccessStream)this.rras)) {
            System.err.println("UDIF structure found! Creating filter stream...");
            UDIFFile udifFile = new UDIFFile((ReadableRandomAccessStream)new ReadableFileStream(file.getAbsolutePath()));
            this.debug(udifFile.getView().getPlistData(), "dmg-xml");
            UDIFRandomAccessStream stream = new UDIFRandomAccessStream(this.rras);
            this.rras = stream;
        } else {
            System.err.println("UDIF structure not found. Proceeding...");
        }
        PartitionSystemRecognizer partitionSystemRecognizer = new PartitionSystemRecognizer(this.rras);
        PartitionSystem partitionSystem = partitionSystemRecognizer.getPartitionSystem();
        if (partitionSystem == null) {
            throw new IOException("No system partitions found. Perhaps the decryption failed?");
        }
        for (Partition partition : partitions = partitionSystem.getUsedPartitionEntries()) {
            this.openPartition(partition);
        }
    }

    private void debug(byte[] plistData, String fileName) {
    }

    private void openPartition(Partition selectedPartition) throws IOException {
        long fsOffset = selectedPartition.getStartOffset();
        long fsLength = selectedPartition.getLength();
        FileSystemRecognizer fsr = new FileSystemRecognizer(this.rras, fsOffset);
        FileSystemRecognizer.FileSystemType fsType = fsr.detectFileSystem();
        if (fsType == FileSystemRecognizer.FileSystemType.HFS_PLUS || fsType == FileSystemRecognizer.FileSystemType.HFSX || fsType == FileSystemRecognizer.FileSystemType.HFS) {
            FileSystemMajorType fsMajorType;
            switch (fsType) {
                case HFS: {
                    fsMajorType = FileSystemMajorType.APPLE_HFS;
                    break;
                }
                case HFS_PLUS: {
                    fsMajorType = FileSystemMajorType.APPLE_HFS_PLUS;
                    break;
                }
                case HFSX: {
                    fsMajorType = FileSystemMajorType.APPLE_HFSX;
                    break;
                }
                default: {
                    fsMajorType = null;
                }
            }
            FileSystemHandlerFactory factory = fsMajorType.createDefaultHandlerFactory();
            if (factory.isSupported(FileSystemHandlerFactory.StandardAttribute.CACHING_ENABLED)) {
                factory.getCreateAttributes().setBooleanAttribute(FileSystemHandlerFactory.StandardAttribute.CACHING_ENABLED, Boolean.valueOf(true));
            }
            Object stage1 = fsLength > 0L ? new ReadableConcatenatedStream(this.rras, fsOffset, fsLength) : this.rras;
            ReadableStreamDataLocator dataLocator = new ReadableStreamDataLocator(stage1);
            FileSystemHandler fileSystemHandler = factory.createHandler((DataLocator)dataLocator);
            this.fileSystemHandlers.add(fileSystemHandler);
            this.rootFolders.add(fileSystemHandler.getRoot());
            if (fileSystemHandler instanceof HFSXFileSystemHandler) {
                this.parser = new AttributesFileParser((HFSXFileSystemHandler)fileSystemHandler, fileSystemHandler.getRoot().getName());
            }
        } else {
            System.err.println("UNKNOWN file system type.  Can't Open filesystem.  Suspect this is an APFS.\n");
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.rras.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.parser != null) {
            this.parser.dispose();
            this.parser = null;
        }
        this.fileSystemHandlers.clear();
        this.rootFolders.clear();
    }

    public InputStream getData(FSEntry entry) throws IOException {
        if (entry != null && entry.isFile()) {
            FSFile fsFile = (FSFile)entry;
            FSFork mainFork = fsFile.getMainFork();
            if (mainFork.getLength() > 0L) {
                ReadableRandomAccessStream mainForkStream = mainFork.getReadableRandomAccessStream();
                if (mainForkStream.length() != 0L) {
                    return new DmgInputStream(mainForkStream);
                }
            } else if (mainFork.getLength() == 0L) {
                FSFork resourceFork = fsFile.getForkByType(FSForkType.MACOS_RESOURCE);
                ReadableRandomAccessStream resourceForkStream = resourceFork.getReadableRandomAccessStream();
                if (this.parser == null) {
                    return null;
                }
                DecmpfsHeader decmpfsHeader = this.parser.getDecmpfsHeader(fsFile);
                if (decmpfsHeader == null) {
                    return null;
                }
                if (decmpfsHeader.getCompressionType() == 3) {
                    if (decmpfsHeader.getAttrBytes()[0] == -1) {
                        return new ByteArrayInputStream(decmpfsHeader.getAttrBytes(), 1, decmpfsHeader.getAttrBytes().length - 1);
                    }
                    ZLIB zlib = new ZLIB();
                    ByteArrayInputStream inputStream = new ByteArrayInputStream(decmpfsHeader.getAttrBytes());
                    ByteArrayOutputStream uncompressedBytes = zlib.decompress(inputStream, (int)decmpfsHeader.getUncompressedSize());
                    File tempDecompressedFile = GFileUtilityMethods.writeTemporaryFile(uncompressedBytes.toByteArray(), entry.getName());
                    return new FileInputStream(tempDecompressedFile);
                }
                if (decmpfsHeader.getCompressionType() == 4) {
                    return this.decompressResourceFork(entry, resourceForkStream, (int)decmpfsHeader.getUncompressedSize());
                }
            }
        }
        return null;
    }

    private InputStream decompressResourceFork(FSEntry entry, ReadableRandomAccessStream resourceForkStream, int expectedLength) throws IOException {
        File tempFile = GFileUtilityMethods.writeTemporaryFile(new DmgInputStream(resourceForkStream));
        System.err.println("dmg resource fork for " + entry.getName() + ": " + tempFile.getAbsolutePath());
        FileInputStream input = new FileInputStream(tempFile);
        for (int i = 0; i < 256; ++i) {
            ((InputStream)input).read();
        }
        byte[] sizeBytes = new byte[4];
        ((InputStream)input).read(sizeBytes);
        int size = sizeBytes[0] == 0 ? bedc.getInt(sizeBytes) : ledc.getInt(sizeBytes);
        byte[] flagsBytes = new byte[4];
        ((InputStream)input).read(flagsBytes);
        byte[] startDistanceBytes = new byte[4];
        ((InputStream)input).read(startDistanceBytes);
        int startDistance = ledc.getInt(startDistanceBytes);
        ((InputStream)input).skip(startDistance - 8);
        File tempCompressedFile = GFileUtilityMethods.writeTemporaryFile(input, size - startDistance);
        FileInputStream inputStream = new FileInputStream(tempCompressedFile);
        ZLIB zlib = new ZLIB();
        ByteArrayOutputStream uncompressedByteStream = zlib.decompress(inputStream, expectedLength);
        return new ByteArrayInputStream(uncompressedByteStream.toByteArray());
    }

    public List<String> getInfo(String path) {
        if (path != null) {
            DmgInfoGenerator info = new DmgInfoGenerator(this, path, this.parser);
            return info.getInformation();
        }
        return null;
    }

    public List<FSEntry> getListing(String path) {
        ArrayList<FSEntry> list;
        block3: {
            FSEntry[] listEntries;
            block2: {
                list = new ArrayList<FSEntry>();
                if (path != null && !path.equals("/")) break block2;
                for (FileSystemHandler handler : this.fileSystemHandlers) {
                    list.add((FSEntry)handler.getRoot());
                }
                break block3;
            }
            FSEntry fileByPath = this.getFileByPath(path);
            if (fileByPath == null || !fileByPath.isFolder()) break block3;
            for (FSEntry entry : listEntries = fileByPath.asFolder().listEntries()) {
                list.add(entry);
            }
        }
        return list;
    }

    public long getLength(FSEntry entry) {
        if (entry != null & entry.isFile()) {
            FSFork mainFork = entry.asFile().getMainFork();
            if (mainFork.getLength() > 0L) {
                return mainFork.getLength();
            }
            try {
                DecmpfsHeader header;
                if (this.parser != null && (header = this.parser.getDecmpfsHeader(entry.asFile())) != null) {
                    return header.getUncompressedSize();
                }
            }
            catch (IOException e) {
                return 1L;
            }
        }
        return -1L;
    }

    public String[] convertPathToArrayAndStripFileSystemName(String path) {
        String[] splitPath = path.split("/");
        if (splitPath.length <= 2) {
            return new String[0];
        }
        String[] temp = new String[splitPath.length - 2];
        System.arraycopy(splitPath, 2, temp, 0, splitPath.length - 2);
        return temp;
    }

    public FSEntry getFileByPath(String path) {
        if (path == null || path.equals("/")) {
            return null;
        }
        for (FileSystemHandler handler : this.fileSystemHandlers) {
            FSEntry entry = handler.getEntry(this.convertPathToArrayAndStripFileSystemName(path));
            if (entry == null) continue;
            return entry;
        }
        return null;
    }
}

