/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.function.Function;
import org.jgrapht.Graph;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.util.DimensionSummaryStatistics;
import org.jungrapht.visualization.layout.algorithms.util.PointSummaryStatistics;
import org.jungrapht.visualization.layout.model.Dimension;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;

public abstract class AbstractLayoutAlgorithm<V>
implements LayoutAlgorithm<V> {
    protected Runnable after;

    protected AbstractLayoutAlgorithm(Builder builder) {
        this.after = builder.after;
    }

    @Override
    public void setAfter(Runnable after) {
        this.after = after;
    }

    @Override
    public void runAfter() {
        if (this.after != null) {
            this.after.run();
        }
    }

    protected <E> Dimension computeAverageVertexDimension(Graph<V, E> graph, Function<V, Rectangle> shapeFunction) {
        DimensionSummaryStatistics dss = new DimensionSummaryStatistics();
        graph.vertexSet().stream().map(vertex -> (Rectangle)shapeFunction.apply(vertex)).forEach(dss::accept);
        return dss.getAverage();
    }

    protected Rectangle computeLayoutExtent(LayoutModel<V> layoutModel) {
        PointSummaryStatistics pss = new PointSummaryStatistics();
        layoutModel.getLocations().values().forEach(pss::accept);
        return Rectangle.from(pss.getMin(), pss.getMax());
    }

    protected void expandToFill(LayoutModel<V> layoutModel, Rectangle occupiedRegion) {
        int regionWidth = (int)occupiedRegion.width;
        int regionHeight = (int)occupiedRegion.height;
        if (regionWidth > regionHeight) {
            double expansion = (double)regionWidth / (double)regionHeight;
            Graph graph = layoutModel.getGraph();
            graph.vertexSet().forEach(v -> {
                Point p = layoutModel.get(v);
                p = Point.of(p.x, expansion * p.y);
                layoutModel.set(v, p);
            });
        } else if (regionWidth < regionHeight) {
            double expansion = (double)regionHeight / (double)regionWidth;
            Graph graph = layoutModel.getGraph();
            graph.vertexSet().forEach(v -> {
                Point p = layoutModel.get(v);
                p = Point.of(expansion * p.x, p.y);
                layoutModel.set(v, p);
            });
        }
    }

    public static abstract class Builder<V, T extends AbstractLayoutAlgorithm<V>, B extends Builder<V, T, B>>
    implements LayoutAlgorithm.Builder<V, T, B> {
        protected Runnable after = () -> {};

        public B after(Runnable after) {
            this.after = after;
            return this.self();
        }

        protected B self() {
            return (B)this;
        }

        @Override
        public abstract T build();
    }
}

