/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.SpringLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.sugiyama.GreedyCycleRemoval;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DAGLayoutAlgorithm<V, E>
extends SpringLayoutAlgorithm<V, E> {
    private static final Logger log = LoggerFactory.getLogger(DAGLayoutAlgorithm.class);
    private Map<V, Number> minLevels = new HashMap<V, Number>();
    static int graphHeight;
    static int numRoots;
    final double SPACEFACTOR = 1.3;
    final double LEVELATTRACTIONRATE = 0.8;
    protected Collection<E> feedbackArcs;
    final double MSV_THRESHOLD = 10.0;
    double meanSquareVel;
    boolean stoppingIncrements = false;
    int incrementsLeft;
    final int COOL_DOWN_INCREMENTS = 200;

    public static <V, E> Builder<V, E, ?, ?> builder() {
        return new Builder();
    }

    protected DAGLayoutAlgorithm(Builder<V, E, ?, ?> builder) {
        super(builder);
    }

    public DAGLayoutAlgorithm() {
        this(DAGLayoutAlgorithm.builder());
    }

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        super.visit(layoutModel);
        Graph graph = layoutModel.getGraph();
        if (graph == null || graph.vertexSet().isEmpty()) {
            return;
        }
        this.initialize();
    }

    public void setRoot() {
        Graph graph = this.layoutModel.getGraph();
        numRoots = 0;
        for (Object vertex : graph.vertexSet()) {
            if (!Graphs.successorListOf(graph, vertex).isEmpty()) continue;
            this.setRoot(vertex);
            ++numRoots;
        }
    }

    public void setRoot(V vertex) {
        this.minLevels.put((Number)vertex, 0);
        this.propagateMinimumLevel(vertex);
    }

    public void propagateMinimumLevel(V vertex) {
        Graph graph = this.layoutModel.getGraph();
        int level = this.minLevels.getOrDefault(vertex, 0).intValue();
        for (Object child : Graphs.predecessorListOf(graph, vertex)) {
            Number o = this.minLevels.getOrDefault(child, 0);
            int oldLevel = o != null ? o.intValue() : 0;
            int newLevel = Math.max(oldLevel, level + 1);
            this.minLevels.put((Number)child, newLevel);
            if (newLevel > graphHeight) {
                graphHeight = newLevel;
            }
            this.propagateMinimumLevel(child);
        }
    }

    private void initializeLocation(V vertex, Point coord, int width, int height) {
        int level = this.minLevels.getOrDefault(vertex, 0).intValue();
        int minY = (int)((double)(level * height) / ((double)graphHeight * 1.3));
        double x = Math.random() * (double)width;
        double y = Math.random() * (double)(height - minY) + (double)minY;
        this.layoutModel.set(vertex, x, y);
    }

    @Override
    public void initialize() {
        super.initialize();
        Graph graph = this.layoutModel.getGraph();
        GreedyCycleRemoval gcr = new GreedyCycleRemoval(graph);
        this.feedbackArcs = gcr.getFeedbackArcs();
        gcr.reverseFeedbackArcs();
        this.setRoot();
        gcr.reverseFeedbackArcs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void moveVertices() {
        int width = this.layoutModel.getWidth();
        int height = this.layoutModel.getHeight();
        Graph graph = this.layoutModel.getGraph();
        double oldMSV = this.meanSquareVel;
        this.meanSquareVel = 0.0;
        LayoutModel layoutModel = this.layoutModel;
        synchronized (layoutModel) {
            for (Object vertex : graph.vertexSet()) {
                if (this.layoutModel.isLocked(vertex)) continue;
                if (this.cancelled) {
                    return;
                }
                SpringLayoutAlgorithm.SpringVertexData vd = this.springVertexData.computeIfAbsent(vertex, v -> new SpringLayoutAlgorithm.SpringVertexData());
                Point xyd = (Point)this.layoutModel.apply(vertex);
                int level = this.minLevels.getOrDefault(vertex, 0).intValue();
                int minY = (int)((double)(level * height) / ((double)graphHeight * 1.3));
                int maxY = level == 0 ? (int)((double)height / ((double)graphHeight * 1.3 * 2.0)) : height;
                vd.dx += 2.0 * vd.repulsiondx + vd.edgedx;
                vd.dy += vd.repulsiondy + vd.edgedy;
                double delta = xyd.y - (double)minY;
                vd.dy -= delta * 0.8;
                if (level == 0) {
                    vd.dy -= delta * 0.8;
                }
                this.meanSquareVel += vd.dx * vd.dx + vd.dy * vd.dy;
                double posX = xyd.x + Math.max(-5.0, Math.min(5.0, vd.dx));
                double posY = xyd.y + Math.max(-5.0, Math.min(5.0, vd.dy));
                if (posX < 0.0) {
                    posX = 0.0;
                } else if (posX > (double)width) {
                    posX = width;
                }
                if (posY < 0.0) {
                    posY = 0.0;
                } else if (posY > (double)height) {
                    posY = height;
                }
                if (numRoots == 1 && level == 0) {
                    posX = width / 2;
                }
                this.setLocation(vertex, posX, posY);
            }
        }
        if (!this.stoppingIncrements && Math.abs(this.meanSquareVel - oldMSV) < 10.0) {
            this.stoppingIncrements = true;
            this.incrementsLeft = 200;
        } else if (this.stoppingIncrements && Math.abs(this.meanSquareVel - oldMSV) <= 10.0) {
            --this.incrementsLeft;
            if (this.incrementsLeft <= 0) {
                this.incrementsLeft = 0;
            }
        }
    }

    @Override
    public boolean done() {
        boolean done;
        if (this.cancelled) {
            return true;
        }
        boolean bl = done = this.stoppingIncrements && this.incrementsLeft == 0;
        if (done) {
            this.runAfter();
        }
        return done;
    }

    public void setLocation(V picked, double x, double y) {
        this.layoutModel.set(picked, x, y);
        this.stoppingIncrements = false;
    }

    public void setLocation(V picked, Point p) {
        this.setLocation(picked, p.x, p.y);
    }

    @Override
    protected void relaxEdges() {
        Graph graph = this.layoutModel.getGraph();
        for (Object edge : graph.edgeSet()) {
            Object vertex1 = graph.getEdgeSource(edge);
            Object vertex2 = graph.getEdgeTarget(edge);
            Point p1 = (Point)this.layoutModel.apply(vertex1);
            Point p2 = (Point)this.layoutModel.apply(vertex2);
            double vx = p1.x - p2.x;
            double vy = p1.y - p2.y;
            double len = Math.sqrt(vx * vx + vy * vy);
            int level1 = this.minLevels.getOrDefault(vertex1, 0).intValue();
            int level2 = this.minLevels.getOrDefault(vertex2, 0).intValue();
            double desiredLen = ((Integer)this.lengthFunction.apply(edge)).intValue();
            len = len == 0.0 ? 1.0E-4 : len;
            double f = this.force_multiplier * (desiredLen - len) / len;
            f *= Math.pow(this.stretch / 100.0, graph.degreeOf(vertex1) + graph.degreeOf(vertex2) - 2);
            if (level1 != level2) {
                f /= Math.pow(Math.abs(level2 - level1), 1.5);
            }
            double dx = f * vx;
            double dy = f * vy;
            SpringLayoutAlgorithm.SpringVertexData v1D = this.springVertexData.computeIfAbsent(vertex1, v -> new SpringLayoutAlgorithm.SpringVertexData());
            SpringLayoutAlgorithm.SpringVertexData v2D = this.springVertexData.computeIfAbsent(vertex2, v -> new SpringLayoutAlgorithm.SpringVertexData());
            v1D.edgedx += dx;
            v1D.edgedy += dy;
            v2D.edgedx += -dx;
            v2D.edgedy += -dy;
        }
    }

    public static class Builder<V, E, T extends DAGLayoutAlgorithm<V, E>, B extends Builder<V, E, T, B>>
    extends SpringLayoutAlgorithm.Builder<V, E, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        @Override
        public T build() {
            return (T)new DAGLayoutAlgorithm(this);
        }
    }
}

