/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.jungrapht.visualization.layout.algorithms.AbstractIterativeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.util.IterativeContext;
import org.jungrapht.visualization.layout.algorithms.util.Pair;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GEMLayoutAlgorithm<V, E>
extends AbstractIterativeLayoutAlgorithm<V>
implements IterativeContext {
    private static final Logger log = LoggerFactory.getLogger(GEMLayoutAlgorithm.class);
    private boolean done;
    private boolean cancelled = false;
    private int nodeCount;
    private boolean clustered;
    private int nbClusters = 1;
    public int verticalSpacing;
    public int horizontalSpacing;
    public int multi;
    protected int maxIterations;
    private int ELEN = 128;
    private int ELENSQR = this.ELEN * this.ELEN;
    private int MAXATTRACT = 0x100000;
    private long iteration;
    private long temperature;
    private int centerX;
    private int centerY;
    private long maxtemp;
    private float oscillation;
    private float rotation;
    protected boolean adjustToFit;
    private float i_maxtemp = 1.0f;
    private float a_maxtemp = 1.5f;
    private float o_maxtemp = 0.25f;
    private float i_starttemp = 0.3f;
    private float a_starttemp = 1.0f;
    private float o_starttemp = 1.0f;
    private float i_finaltemp = 0.05f;
    private float a_finaltemp = 0.02f;
    private float o_finaltemp = 1.0f;
    private int i_maxiter = 10;
    private int a_maxiter = 3;
    private int o_maxiter = 3;
    private float i_gravity = 0.05f;
    private float i_oscillation = 0.4f;
    private float i_rotation = 0.5f;
    private float i_shake = 0.2f;
    private float a_gravity = 0.1f;
    private float a_oscillation = 0.4f;
    private float a_rotation = 0.9f;
    private float a_shake = 0.3f;
    private float o_gravity = 0.1f;
    private float o_oscillation = 0.4f;
    private float o_rotation = 0.9f;
    private float o_shake = 0.3f;
    long stop_temperature;
    long stop_iteration;
    private Properties[] gemProp;
    private V[] invmap;
    private Map<Integer, List<Integer>> adjacent;
    private Map<V, Integer> nodeNumbers;
    private Random rand = new Random();
    private int[] map;
    private Queue<Integer> q;
    private Graph<V, E> graph;

    public static <V, E> Builder<V, E, ?, ?> edgeAwareBuilder() {
        return new Builder();
    }

    public GEMLayoutAlgorithm() {
        this(GEMLayoutAlgorithm.edgeAwareBuilder());
    }

    protected GEMLayoutAlgorithm(Builder<V, E, ?, ?> builder) {
        super(builder);
        this.maxIterations = builder.maxIterations;
        this.multi = builder.multi;
        this.horizontalSpacing = builder.horizontalSpacing;
        this.verticalSpacing = builder.verticalSpacing;
        this.clustered = builder.clustered;
        this.adjustToFit = builder.adjustToFit;
    }

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        super.visit(layoutModel);
        this.graph = layoutModel.getGraph();
        if (this.graph == null || this.graph.vertexSet().isEmpty()) {
            return;
        }
        this.initialize();
        this.arrange();
        if (this.adjustToFit) {
            this.adjustToFit();
        }
        Rectangle range = this.computeLayoutExtent(layoutModel);
        int widthPadding = (int)(range.width * 0.05);
        int heightPadding = (int)(range.height * 0.05);
        range = Rectangle.from(range.min().add(-widthPadding, -heightPadding), range.max().add(widthPadding, heightPadding));
        this.graph.vertexSet().forEach(v -> layoutModel.set(v, ((Point)layoutModel.apply(v)).add(widthPadding, heightPadding)));
        int maxDimension = Math.max((int)range.width, (int)range.height);
        layoutModel.setSize(maxDimension, maxDimension);
    }

    private Rectangle getMaxBounds() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        for (Point p : this.layoutModel.getLocations().values()) {
            if (p.x < (double)minX) {
                minX = (int)p.x;
            }
            if (p.y < (double)minY) {
                minY = (int)p.y;
            }
            if (p.x > (double)maxX) {
                maxX = (int)p.x;
            }
            if (!(p.y > (double)maxY)) continue;
            maxY = (int)p.y;
        }
        return Rectangle.of(minX -= this.horizontalSpacing, minY -= this.verticalSpacing, (maxX += this.horizontalSpacing) - minX, (maxY += this.verticalSpacing) - minY);
    }

    private void adjustToFit() {
        Rectangle bounds = this.getMaxBounds();
        double boundsWidth = bounds.width;
        double boundsHeight = bounds.height;
        int layoutWidth = this.layoutModel.getWidth();
        int layoutHeight = this.layoutModel.getHeight();
        double scaleX = (double)layoutWidth / boundsWidth;
        double scaleY = (double)layoutHeight / boundsHeight;
        for (Object v : this.graph.vertexSet()) {
            Point vp = (Point)this.layoutModel.apply(v);
            vp = Point.of(vp.x * scaleX, vp.y * scaleY);
            vp = vp.add(this.horizontalSpacing, this.verticalSpacing);
            this.layoutModel.set(v, vp);
        }
    }

    private Graph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public synchronized void step() {
        if (this.temperature > this.stop_temperature && this.iteration < this.stop_iteration && !this.cancelled) {
            log.trace("iteration: {}", (Object)this.iteration);
            this.a_round();
        } else {
            this.done = true;
        }
    }

    @Override
    public boolean done() {
        if (this.cancelled) {
            return true;
        }
        if (this.done) {
            this.runAfter();
        }
        return this.done;
    }

    private void a_round() {
        for (int i = 0; i < this.nodeCount; ++i) {
            int dY;
            int dX;
            Properties q;
            int v = this.select();
            Properties p = this.gemProp[v];
            int pX = p.x;
            int pY = p.y;
            int n = (int)(this.a_shake * (float)this.ELEN);
            int iX = this.rand() % (2 * n + 1) - n;
            int iY = this.rand() % (2 * n + 1) - n;
            iX = (int)((float)iX + (float)(this.centerX / this.nodeCount - pX) * p.mass * this.a_gravity);
            iY = (int)((float)iY + (float)(this.centerY / this.nodeCount - pY) * p.mass * this.a_gravity);
            for (int u = 0; u < this.nodeCount; ++u) {
                q = this.gemProp[u];
                dX = pX - q.x;
                dY = pY - q.y;
                n = dX * dX + dY * dY;
                if (n <= 0) continue;
                iX += dX * this.ELENSQR / n;
                iY += dY * this.ELENSQR / n;
            }
            for (int u : this.adjacent.get(v)) {
                q = this.gemProp[u];
                dX = pX - q.x;
                dY = pY - q.y;
                n = (int)((float)(dX * dX + dY * dY) / p.mass);
                n = Math.min(n, this.MAXATTRACT);
                iX -= dX * n / this.ELENSQR;
                iY -= dY * n / this.ELENSQR;
            }
            this.displace(v, iX, iY);
            ++this.iteration;
        }
    }

    private void arrange() {
        this.vertexdata_init(this.a_starttemp);
        this.oscillation = this.a_oscillation;
        this.rotation = this.a_rotation;
        this.maxtemp = (int)(this.a_maxtemp * (float)this.ELEN);
        this.stop_temperature = (int)(this.a_finaltemp * this.a_finaltemp * (float)this.ELENSQR * (float)this.nodeCount);
        this.stop_iteration = this.a_maxiter * this.nodeCount * this.nodeCount;
        this.iteration = 0L;
    }

    private int bfs(int root) {
        if (root >= 0) {
            this.q = new LinkedList<Integer>();
            if (!this.gemProp[root].mark) {
                for (int vi = 0; vi < this.nodeCount; ++vi) {
                    this.gemProp[vi].in = 0;
                }
            } else {
                this.gemProp[root].mark = true;
            }
            this.q.add(root);
            this.gemProp[root].in = 1;
        }
        if (this.q.size() == 0) {
            return -1;
        }
        int v = this.q.poll();
        for (int ui : this.adjacent.get(v)) {
            if (this.gemProp[ui].in == 0) continue;
            this.q.add(ui);
            this.gemProp[ui].in = this.gemProp[v].in + 1;
        }
        return v;
    }

    private Point[] calcBounds(Graph<V, E> graph, Map<V, Point> coords) {
        Point[] result = new Point[2];
        Point min = null;
        Point max = null;
        Iterator it = graph.vertexSet().iterator();
        while (it.hasNext()) {
            Point point = coords.get(it.next());
            if (min == null) {
                min = point;
            }
            if (max == null) {
                max = point;
            }
            min = Point.of(Math.min(min.x, point.x), Math.min(min.y, point.y));
            max = Point.of(Math.max(max.x, point.x), Math.max(max.y, point.y));
        }
        result[0] = min;
        result[1] = max;
        return result;
    }

    public Set<Graph<V, E>> clusterGraph(Graph<V, E> original) {
        HashSet<Graph<V, Graph>> subgraphs = new HashSet<Graph<V, Graph>>();
        HashSet sorted = new HashSet();
        for (Object n : original.vertexSet()) {
            if (!sorted.contains(n)) {
                Graph cluster = GraphTypeBuilder.undirected().allowingSelfLoops(true).allowingMultipleEdges(true).buildGraph();
                subgraphs.add(cluster);
                cluster.addVertex(n);
                sorted.add(n);
                LinkedList queue = new LinkedList();
                List neigbours = Graphs.neighborListOf(original, n);
                queue.addAll(neigbours);
                while (!queue.isEmpty()) {
                    Object next = queue.poll();
                    if (sorted.contains(next)) continue;
                    cluster.addVertex(next);
                    sorted.add(next);
                    Set nextEdges = original.edgesOf(next);
                    for (Object edge : nextEdges) {
                        cluster.addVertex(original.getEdgeSource(edge));
                        cluster.addVertex(original.getEdgeTarget(edge));
                        cluster.addEdge(original.getEdgeSource(edge), original.getEdgeTarget(edge), edge);
                    }
                    queue.addAll(Graphs.neighborListOf(original, next));
                }
            }
            if (!this.cancelled) continue;
            return subgraphs;
        }
        return subgraphs;
    }

    private void displace(int v, int iX, int iY) {
        if (iX != 0 || iY != 0) {
            int n = Math.max(Math.abs(iX), Math.abs(iY)) / 16384;
            if (n > 1) {
                iX /= n;
                iY /= n;
            }
            Properties p = this.gemProp[v];
            int t = (int)p.heat;
            n = (int)Math.sqrt(iX * iX + iY * iY);
            iX = iX * t / n;
            iY = iY * t / n;
            p.x += iX;
            p.y += iY;
            this.centerX += iX;
            this.centerY += iY;
            n = t * (int)Math.sqrt(p.iX * p.iX + p.iY * p.iY);
            if (n > 0) {
                this.temperature -= (long)(t * t);
                t = (int)((float)t + (float)t * this.oscillation * (float)(iX * p.iX + iY * p.iY) / (float)n);
                t = (int)Math.min((long)t, this.maxtemp);
                p.dir += this.rotation * (float)(iX * p.iY - iY * p.iX) / (float)n;
                t = (int)((float)t - (float)t * Math.abs(p.dir) / (float)this.nodeCount);
                t = Math.max(t, 2);
                this.temperature += (long)(t * t);
                p.heat = t;
            }
            p.iX = iX;
            p.iY = iY;
        }
    }

    private int[] EVdistance(int thisNode, int thatNode, int v) {
        Properties thisGP = this.gemProp[thisNode];
        Properties thatGP = this.gemProp[thatNode];
        Properties nodeGP = this.gemProp[v];
        int aX = thisGP.x;
        int aY = thisGP.y;
        int bX = thatGP.x;
        int bY = thatGP.y;
        int cX = nodeGP.x;
        int cY = nodeGP.y;
        long m = (bX -= aX) * (cX - aX) + (bY -= aY) * (cY - aY);
        long n = bX * bX + bY * bY;
        if (m < 0L) {
            m = 0L;
        }
        if (m > n) {
            n = 1L;
            m = 1L;
        }
        if (m >> 17 > 0L) {
            n /= m >> 16;
            m /= m >> 16;
        }
        if (n != 0L) {
            aX += (int)((long)bX * m / n);
            aY += (int)((long)bY * m / n);
        }
        return new int[]{aX, aY};
    }

    private int graphCenter() {
        int c = -1;
        int u = -1;
        int h = this.nodeCount + 1;
        for (int w = 0; w < this.nodeCount; ++w) {
            int v = this.bfs(w);
            while (v >= 0 && this.gemProp[v].in < h) {
                u = v;
                v = this.bfs(-1);
            }
            Properties p = this.gemProp[u];
            if (p.in >= h) continue;
            h = p.in;
            c = w;
        }
        if (c == -1) {
            return (int)Math.rint((double)(this.nodeCount - 1) * Math.random());
        }
        return c;
    }

    private int[] i_impulse(int v) {
        int dY;
        int dX;
        Properties q;
        Properties p = this.gemProp[v];
        int pX = p.x;
        int pY = p.y;
        int n = (int)(this.i_shake * (float)this.ELEN);
        int iX = this.rand() % (2 * n + 1) - n;
        int iY = this.rand() % (2 * n + 1) - n;
        iX = (int)((float)iX + (float)(this.centerX / this.nodeCount - pX) * p.mass * this.i_gravity);
        iY = (int)((float)iY + (float)(this.centerY / this.nodeCount - pY) * p.mass * this.i_gravity);
        for (int u = 0; u < this.nodeCount; ++u) {
            q = this.gemProp[u];
            if (q.in <= 0 || (n = (dX = pX - q.x) * dX + (dY = pY - q.y) * dY) <= 0) continue;
            iX += dX * this.ELENSQR / n;
            iY += dY * this.ELENSQR / n;
        }
        for (int u : this.adjacent.get(v)) {
            q = this.gemProp[u];
            if (q.in <= 0) continue;
            dX = pX - q.x;
            dY = pY - q.y;
            n = (int)((float)(dX * dX + dY * dY) / p.mass);
            n = Math.min(n, this.MAXATTRACT);
            iX -= dX * n / this.ELENSQR;
            iY -= dY * n / this.ELENSQR;
        }
        return new int[]{iX, iY};
    }

    public void initialize() {
        this.cancelled = false;
        if (this.clustered) {
            Set<Graph<V, E>> clusters = this.clusterGraph(this.getGraph());
            this.nbClusters = clusters.size();
            this.runClustered(clusters);
        } else {
            this.runNormal(this.getGraph());
            for (int i = 0; i < this.nodeCount && !this.cancelled; ++i) {
                Properties p = this.gemProp[i];
                V n = this.invmap[i];
                this.layoutModel.set(n, p.x, p.y);
            }
        }
    }

    private void insert() {
        this.vertexdata_init(this.i_starttemp);
        this.oscillation = this.i_oscillation;
        this.rotation = this.i_rotation;
        this.maxtemp = (int)(this.i_maxtemp * (float)this.ELEN);
        int v = this.graphCenter();
        for (int ui = 0; ui < this.nodeCount; ++ui) {
            this.gemProp[ui].in = 0;
        }
        this.gemProp[v].in = -1;
        int startNode = -1;
        for (int i = 0; i < this.nodeCount; ++i) {
            int d = 0;
            for (int u = 0; u < this.nodeCount; ++u) {
                if (this.gemProp[u].in >= d) continue;
                d = this.gemProp[u].in;
                v = u;
            }
            this.gemProp[v].in = 1;
            for (int u : this.adjacent.get(v)) {
                if (this.gemProp[u].in > 0) continue;
                --this.gemProp[u].in;
            }
            Properties p = this.gemProp[v];
            p.y = 0;
            p.x = 0;
            if (startNode >= 0) {
                d = 0;
                p = this.gemProp[v];
                for (int w : this.adjacent.get(v)) {
                    Properties q = this.gemProp[w];
                    if (q.in <= 0) continue;
                    p.x += q.x;
                    p.y += q.y;
                    ++d;
                }
                if (d > 1) {
                    p.x /= d;
                    p.y /= d;
                }
                d = 0;
                while (d++ < this.i_maxiter && p.heat > this.i_finaltemp * (float)this.ELEN) {
                    int[] i_impulse = this.i_impulse(v);
                    this.displace(v, i_impulse[0], i_impulse[1]);
                }
            } else {
                startNode = i;
            }
            if (!this.cancelled) continue;
            return;
        }
    }

    private int[] o_impulse(Graph<V, E> graph, int v) {
        Properties p = this.gemProp[v];
        int pX = p.x;
        int pY = p.y;
        int n = (int)(this.o_shake * (float)this.ELEN);
        int iX = this.rand() % (2 * n + 1) - n;
        int iY = this.rand() % (2 * n + 1) - n;
        iX = (int)((float)iX + (float)(this.centerX / this.nodeCount - pX) * p.mass * this.o_gravity);
        iY = (int)((float)iY + (float)(this.centerY / this.nodeCount - pY) * p.mass * this.o_gravity);
        for (Object e : graph.edgeSet()) {
            int dY;
            int dX;
            Properties up;
            Pair<Object> ends = Pair.of(graph.getEdgeSource(e), graph.getEdgeTarget(e));
            int u = this.nodeNumbers.get(ends.first);
            int w = this.nodeNumbers.get(ends.second);
            if (u != v && w != v) {
                up = this.gemProp[u];
                Properties wp = this.gemProp[w];
                dX = (up.x + wp.x) / 2 - pX;
                dY = (up.y + wp.y) / 2 - pY;
                n = dX * dX + dY * dY;
                if (n < 8 * this.ELENSQR) {
                    int[] evdist = this.EVdistance(u, w, v);
                    dX = evdist[0];
                    dY = evdist[1];
                    n = (dX -= pX) * dX + (dY -= pY) * dY;
                }
                if (n <= 0) continue;
                iX -= dX * this.ELENSQR / n;
                iY -= dY * this.ELENSQR / n;
                continue;
            }
            if (u == v) {
                u = w;
            }
            up = this.gemProp[u];
            dX = pX - up.x;
            dY = pY - up.y;
            n = (int)((float)(dX * dX + dY * dY) / p.mass);
            n = Math.min(n, this.MAXATTRACT);
            iX -= dX * n / this.ELENSQR;
            iY -= dY * n / this.ELENSQR;
        }
        return new int[]{iX, iY};
    }

    private void o_round(Graph<V, E> graph) {
        for (int i = 0; i < this.nodeCount; ++i) {
            int v = this.select();
            int[] o_impulse = this.o_impulse(graph, v);
            this.displace(v, o_impulse[0], o_impulse[1]);
            ++this.iteration;
        }
    }

    private void optimize(Graph<V, E> graph) {
        this.vertexdata_init(this.o_starttemp);
        this.oscillation = this.o_oscillation;
        this.rotation = this.o_rotation;
        this.maxtemp = (int)(this.o_maxtemp * (float)this.ELEN);
        long stop_temperature = (int)(this.o_finaltemp * this.o_finaltemp * (float)this.ELENSQR * (float)this.nodeCount);
        long stop_iteration = this.o_maxiter * this.nodeCount * this.nodeCount;
        while (this.temperature > stop_temperature && this.iteration < stop_iteration) {
            this.o_round(graph);
            if (!this.cancelled) continue;
            return;
        }
    }

    private int rand() {
        return (int)(this.rand.nextDouble() * 2.147483647E9);
    }

    public void runClustered(Set<Graph<V, E>> subgraphs) {
        Graph[] sortedSubgraphs = subgraphs.toArray(new Graph[0]);
        Arrays.sort(sortedSubgraphs, Comparator.comparingInt(g -> g.vertexSet().size()));
        HashMap localLayouts = new HashMap();
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int j = 0;
        for (Graph subgraph : sortedSubgraphs) {
            ++j;
            this.runNormal(subgraph);
            localLayouts.put(subgraph, new HashMap());
            for (int i = 0; i < this.nodeCount; ++i) {
                Properties p = this.gemProp[i];
                V n = this.invmap[i];
                Point coord = Point.of(p.x, p.y);
                this.layoutModel.set(n, coord);
                if (p.x < minX) {
                    minX = p.x;
                }
                if (p.x > maxX) {
                    maxX = p.x;
                }
                if (p.y < minY) {
                    minY = p.y;
                }
                if (p.y > maxY) {
                    maxY = p.y;
                }
                ((Map)localLayouts.get(subgraph)).put(n, coord);
            }
            if (!this.cancelled) continue;
            return;
        }
        int width = (Math.abs(minX) + Math.abs(maxX)) * this.multi;
        double offsetX = 0.0;
        double offsetY = 0.0;
        double maxposY = 0.0;
        Graph[] graphArray = sortedSubgraphs;
        int n = graphArray.length;
        for (int i = 0; i < n; ++i) {
            Graph sub;
            Graph subgraph = sub = graphArray[i];
            Map coords = (Map)localLayouts.get(subgraph);
            Point[] result = this.calcBounds(subgraph, coords);
            Point min = result[0];
            double tmpY = 0.0;
            double tmpX = 0.0;
            for (Object n2 : coords.keySet()) {
                Point coord = (Point)coords.get(n2);
                double newX = offsetX + coord.x - min.x;
                double newY = offsetY + coord.y - min.y;
                if (newX > tmpX) {
                    tmpX = newX;
                }
                if (newY > tmpY) {
                    tmpY = newY;
                }
                ((Map)localLayouts.get(subgraph)).put(n2, Point.of(newX, newY));
                this.layoutModel.set(n2, Point.of(newX, newY));
            }
            offsetX = tmpX + (double)this.horizontalSpacing;
            if (tmpY > maxposY) {
                maxposY = tmpY;
            }
            if (!(offsetX > (double)width)) continue;
            offsetY = maxposY + (double)this.verticalSpacing;
            offsetX = 0.0;
            maxposY = 0.0;
        }
    }

    private void runNormal(Graph<V, E> graph) {
        Set nodes = graph.vertexSet();
        this.nodeCount = nodes.size();
        if (this.nodeCount == 0) {
            return;
        }
        this.gemProp = new Properties[this.nodeCount];
        this.invmap = new Object[this.nodeCount];
        this.adjacent = new HashMap<Integer, List<Integer>>(this.nodeCount);
        this.nodeNumbers = new HashMap<V, Integer>();
        Iterator nodeSet = nodes.iterator();
        int i = 0;
        while (nodeSet.hasNext()) {
            Object n = nodeSet.next();
            this.gemProp[i] = new Properties(graph.outgoingEdgesOf(n).size());
            this.invmap[i] = n;
            this.nodeNumbers.put((Integer)n, i);
            ++i;
        }
        for (int i2 = 0; i2 < this.nodeCount; ++i2) {
            List neighbors = Graphs.neighborListOf(graph, this.invmap[i2]);
            this.adjacent.put(i2, new ArrayList(neighbors.size()));
            for (Object n : neighbors) {
                this.adjacent.get(i2).add(this.nodeNumbers.get(n));
            }
        }
        if (this.cancelled) {
            return;
        }
        if (this.i_finaltemp < this.i_starttemp) {
            this.insert();
            if (this.cancelled) {
                return;
            }
        }
        if (this.a_finaltemp < this.a_starttemp) {
            this.arrange();
            if (this.cancelled) {
                return;
            }
        }
        if (this.o_finaltemp < this.o_starttemp) {
            this.optimize(graph);
            if (this.cancelled) {
                return;
            }
        }
    }

    private int select() {
        if (this.iteration == 0L) {
            this.map = new int[this.nodeCount];
            for (int i = 0; i < this.nodeCount; ++i) {
                this.map[i] = i;
            }
        }
        int n = (int)((long)this.nodeCount - this.iteration % (long)this.nodeCount);
        int v = this.rand() % n;
        if (v == this.nodeCount) {
            --v;
        }
        if (n == this.nodeCount) {
            --n;
        }
        int u = this.map[v];
        this.map[v] = this.map[n];
        this.map[n] = u;
        return u;
    }

    private void vertexdata_init(float starttemp) {
        this.temperature = 0L;
        this.centerY = 0;
        this.centerX = 0;
        for (int v = 0; v < this.nodeCount; ++v) {
            Properties p = this.gemProp[v];
            p.heat = starttemp * (float)this.ELEN;
            this.temperature = (long)((float)this.temperature + p.heat * p.heat);
            p.iY = 0;
            p.iX = 0;
            p.dir = 0.0f;
            p.mass = 1.0f + this.gemProp[v].mass / 3.0f;
            this.centerX += p.x;
            this.centerY += p.y;
        }
    }

    private class Properties<V> {
        public int x = 0;
        public int y = 0;
        public int in;
        public int iX = 0;
        public int iY = 0;
        public float dir = 0.0f;
        public float heat = 0.0f;
        public float mass;
        public boolean mark;

        public Properties(int m) {
            this.mass = m;
            this.mark = false;
        }
    }

    public static class Builder<V, E, T extends GEMLayoutAlgorithm<V, E>, B extends Builder<V, E, T, B>>
    extends AbstractIterativeLayoutAlgorithm.Builder<V, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        private int maxIterations = 700;
        private int multi = 3;
        private int verticalSpacing = 75;
        private int horizontalSpacing = 75;
        private boolean clustered = true;
        protected boolean adjustToFit = true;

        public B multi(int multi) {
            this.multi = multi;
            return (B)((Builder)this.self());
        }

        public B maxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            return (B)((Builder)this.self());
        }

        public B verticalSpacing(int verticalSpacing) {
            this.verticalSpacing = verticalSpacing;
            return (B)((Builder)this.self());
        }

        public B horizontalSpacing(int horizontalSpacing) {
            this.horizontalSpacing = horizontalSpacing;
            return (B)((Builder)this.self());
        }

        public B clustered(boolean clustered) {
            this.clustered = clustered;
            return (B)((Builder)this.self());
        }

        public B adjustToFit(boolean adjustToFit) {
            this.adjustToFit = adjustToFit;
            return (B)((Builder)this.self());
        }

        @Override
        public T build() {
            return (T)new GEMLayoutAlgorithm(this);
        }
    }
}

