/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.layout.algorithms;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jgrapht.Graph;
import org.jgrapht.GraphType;
import org.jgrapht.alg.interfaces.SpanningTreeAlgorithm;
import org.jgrapht.alg.spanning.PrimMinimumSpanningTree;
import org.jgrapht.graph.AsUndirectedGraph;
import org.jgrapht.graph.DefaultGraphType;
import org.jgrapht.graph.builder.GraphTypeBuilder;
import org.jungrapht.visualization.layout.algorithms.AbstractTreeLayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.LayoutAlgorithm;
import org.jungrapht.visualization.layout.algorithms.TreeLayout;
import org.jungrapht.visualization.layout.model.Dimension;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.layout.model.Point;
import org.jungrapht.visualization.layout.model.Rectangle;
import org.jungrapht.visualization.layout.util.Caching;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeLayoutAlgorithm<V>
extends AbstractTreeLayoutAlgorithm<V>
implements LayoutAlgorithm<V>,
TreeLayout<V> {
    private static final Logger log = LoggerFactory.getLogger(TreeLayoutAlgorithm.class);

    public static <V> Builder<V, ?, ?> builder() {
        return new Builder();
    }

    public TreeLayoutAlgorithm() {
        this(TreeLayoutAlgorithm.builder());
    }

    protected TreeLayoutAlgorithm(Builder<V, ?, ?> builder) {
        super(builder);
    }

    @Override
    public void visit(LayoutModel<V> layoutModel) {
        if (!layoutModel.getGraph().vertexSet().isEmpty()) {
            super.visit(layoutModel);
            this.buildTree(layoutModel);
        }
    }

    @Override
    public Map<V, Rectangle> getBaseBounds() {
        return this.baseBounds;
    }

    protected Set<V> buildTree(LayoutModel<V> layoutModel) {
        Graph graph = layoutModel.getGraph();
        if (graph == null || graph.vertexSet().isEmpty()) {
            return Collections.emptySet();
        }
        if (layoutModel instanceof Caching) {
            ((Caching)((Object)layoutModel)).clear();
        }
        this.defaultRootPredicate = v -> graph.incomingEdgesOf(v).isEmpty() || TreeLayout.isIsolatedVertex(graph, v);
        if (this.vertexBoundsFunction != null) {
            Dimension averageVertexSize = this.computeAverageVertexDimension(graph, this.vertexBoundsFunction);
            this.horizontalVertexSpacing = averageVertexSize.width * 2;
            this.verticalVertexSpacing = averageVertexSize.height * 2;
        }
        this.rootPredicate = this.rootPredicate == null ? this.defaultRootPredicate : this.rootPredicate.or(this.defaultRootPredicate);
        List roots = graph.vertexSet().stream().filter(this.rootPredicate).sorted(this.rootComparator).sorted(Comparator.comparingInt(v -> TreeLayout.vertexIsolationScore(graph, v))).collect(Collectors.toList());
        if (roots.size() == 0) {
            Graph tree = TreeLayoutAlgorithm.getSpanningTree(graph);
            layoutModel.setGraph(tree);
            Set<V> treeRoots = this.buildTree(layoutModel);
            return treeRoots;
        }
        this.calculateWidth(layoutModel, roots, (Set<V>)new HashSet());
        this.calculateHeight(layoutModel, roots, (Set<V>)new HashSet());
        int x = this.horizontalVertexSpacing;
        int y = 0;
        HashSet seen = new HashSet();
        for (Object vertex : roots) {
            int w = (int)((Rectangle)this.baseBounds.get(vertex)).width;
            log.trace("w is {} and baseWidths.get(vertex) = {}", (Object)w, (Object)((Rectangle)this.baseBounds.get(vertex)).width);
            log.trace("currentX after vertex {} is now {}", vertex, (Object)(x += w / 2));
            this.buildTree(layoutModel, vertex, x, y, seen);
            this.merge(layoutModel, vertex);
            x += w / 2 + this.horizontalVertexSpacing;
        }
        this.rootPredicate = null;
        if (this.expandLayout) {
            this.expandToFill(layoutModel);
        }
        this.after.run();
        return new LinkedHashSet(roots);
    }

    protected int getInitialPosition(int initialPosition, int layoutSpan, int treeSpan) {
        if (layoutSpan <= treeSpan) {
            return initialPosition;
        }
        return layoutSpan / 2 - treeSpan / 2;
    }

    protected void buildTree(LayoutModel<V> layoutModel, V vertex, int x, int y, Set<V> seen) {
        if (seen.add(vertex)) {
            log.trace("buildTree placing {}", vertex);
            log.trace("Set vertex {} to {}", vertex, (Object)Point.of(x, y += this.verticalVertexSpacing));
            layoutModel.set(vertex, x, y);
            this.merge(layoutModel, vertex);
            double sizeXofCurrent = ((Rectangle)this.baseBounds.get(vertex)).width;
            x = (int)((double)x - sizeXofCurrent / 2.0);
            for (Object element : this.neighborCache.successorsOf(vertex)) {
                if (this.rootPredicate.test(element) || seen.contains(element)) continue;
                log.trace("get base position of {} from {}", element, (Object)this.baseBounds);
                double sizeXofChild = ((Rectangle)this.baseBounds.get(element)).width;
                x = (int)((double)x + sizeXofChild / 2.0);
                this.buildTree(layoutModel, element, x, y, seen);
                this.merge(layoutModel, element);
                x = (int)((double)x + (sizeXofChild / 2.0 + (double)this.horizontalVertexSpacing));
            }
        }
    }

    protected void merge(LayoutModel<V> layoutModel, V vertex) {
        Point p = (Point)layoutModel.apply(vertex);
        this.baseBounds.merge(vertex, Rectangle.of(p.x, p.y, 0.0, 0.0), (r, s) -> Rectangle.of(s.x - r.width / 2.0, s.y, r.width, r.height));
    }

    protected int calculateWidth(LayoutModel<V> layoutModel, V vertex, Set<V> seen) {
        if (seen.add(vertex)) {
            Graph graph = layoutModel.getGraph();
            int width = Math.max(0, this.neighborCache.successorsOf(vertex).stream().filter(v -> !this.rootPredicate.test(v) && !seen.contains(v)).mapToInt(element -> this.calculateWidth(layoutModel, element, seen) + this.horizontalVertexSpacing).sum() - this.horizontalVertexSpacing);
            log.trace("calcWidth baseWidths put {} {}", vertex, (Object)width);
            this.baseBounds.merge(vertex, Rectangle.of(0, 0, width, 0), (r, t) -> Rectangle.of(r.x, r.y, t.width, r.height));
            return width;
        }
        return 0;
    }

    protected int calculateWidth(LayoutModel<V> layoutModel, Collection<V> roots, Set<V> seen) {
        int width = roots.stream().filter(v -> !seen.contains(v)).mapToInt(vertex -> this.calculateWidth(layoutModel, vertex, seen)).sum();
        log.debug("entire width from {} is {}", roots, (Object)width);
        return width;
    }

    protected int calculateHeight(LayoutModel<V> layoutModel, V vertex, Set<V> seen) {
        if (seen.add(vertex)) {
            Graph graph = layoutModel.getGraph();
            int height = this.neighborCache.successorsOf(vertex).stream().filter(v -> !this.rootPredicate.test(v) && !seen.contains(v)).mapToInt(element -> this.calculateHeight(layoutModel, element, seen) + this.verticalVertexSpacing).max().orElse(0);
            this.baseBounds.merge(vertex, Rectangle.of(0, 0, 0, height), (r, t) -> Rectangle.of(r.x, r.y, r.width, t.height));
            return height;
        }
        return 0;
    }

    protected int calculateHeight(LayoutModel<V> layoutModel, Collection<V> roots, Set<V> seen) {
        return roots.stream().filter(v -> !seen.contains(v)).mapToInt(vertex -> this.calculateHeight(layoutModel, vertex, seen)).max().orElse(this.verticalVertexSpacing) + this.verticalVertexSpacing;
    }

    public Point getCenter(LayoutModel<V> layoutModel) {
        return Point.of(layoutModel.getWidth() / 2, layoutModel.getHeight() / 2);
    }

    public static <V, E> Graph<V, E> getSpanningTree(Graph<V, E> graph) {
        if (graph.getType().isDirected()) {
            graph = new AsUndirectedGraph(graph);
        }
        PrimMinimumSpanningTree prim = new PrimMinimumSpanningTree(graph);
        SpanningTreeAlgorithm.SpanningTree tree = prim.getSpanningTree();
        Graph newGraph = GraphTypeBuilder.forGraphType((GraphType)DefaultGraphType.dag()).buildGraph();
        for (Object edge : tree.getEdges()) {
            newGraph.addVertex(graph.getEdgeSource(edge));
            newGraph.addVertex(graph.getEdgeTarget(edge));
            newGraph.addEdge(graph.getEdgeSource(edge), graph.getEdgeTarget(edge), edge);
        }
        return newGraph;
    }

    @Override
    public boolean constrained() {
        return false;
    }

    public static class Builder<V, T extends TreeLayoutAlgorithm<V>, B extends Builder<V, T, B>>
    extends AbstractTreeLayoutAlgorithm.Builder<V, T, B>
    implements LayoutAlgorithm.Builder<V, T, B> {
        @Override
        public T build() {
            return (T)new TreeLayoutAlgorithm(this);
        }
    }
}

