/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.extension.datatype.finder;

import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.extension.datatype.finder.DecompilerReference;
import ghidra.app.extension.datatype.finder.VariableAccessDR;
import ghidra.app.services.DataTypeReference;
import ghidra.program.model.data.DataType;
import java.util.List;

public class AnonymousVariableAccessDR
extends VariableAccessDR {
    protected AnonymousVariableAccessDR(ClangLine line, ClangFieldToken token) {
        super(line, token);
    }

    @Override
    public void accumulateMatches(DataType dt, String fieldName, List<DataTypeReference> results) {
        boolean noMatch;
        ClangFieldToken field = (ClangFieldToken)this.sourceToken;
        DataType compositeType = field.getDataType();
        DataType fieldDt = DecompilerReference.getFieldDataType(field);
        boolean matchesComposite = AnonymousVariableAccessDR.isEqual(dt, compositeType);
        boolean matchesField = AnonymousVariableAccessDR.isEqual(dt, fieldDt);
        boolean bl = noMatch = !matchesComposite && !matchesField;
        if (noMatch) {
            return;
        }
        if (fieldName == null) {
            if (matchesField) {
                results.add(this.createReference(this.variable));
            }
            return;
        }
        if (matchesComposite && field.getText().equals(fieldName)) {
            results.add(new DataTypeReference(compositeType, fieldName, this.getFunction(), this.getAddress(), this.getContext()));
        }
    }
}

