/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.extension.datatype.finder;

import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangLine;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.extension.datatype.finder.DecompilerVariable;
import ghidra.app.extension.datatype.finder.DecompilerVariableType;
import ghidra.app.services.DataTypeReference;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.listing.Function;
import ghidra.util.StringUtilities;
import java.util.Arrays;
import java.util.List;

public abstract class DecompilerReference {
    protected ClangLine line;
    protected ClangToken sourceToken;
    protected DecompilerVariable variable;

    protected DecompilerReference(ClangLine line, ClangToken token) {
        this.line = line;
        this.sourceToken = token;
        if (token != null) {
            this.variable = new DecompilerVariableType(token);
        }
    }

    public abstract void accumulateMatches(DataType var1, String var2, List<DataTypeReference> var3);

    public DecompilerVariable getVariable() {
        return this.variable;
    }

    public DataType getDataType() {
        return this.variable.getDataType();
    }

    public Function getFunction() {
        Function function = this.variable.getFunction();
        return function;
    }

    public Address getAddress() {
        return this.variable.getAddress();
    }

    public Address getAddress(DecompilerVariable var) {
        return var.getAddress();
    }

    public ClangLine getLine() {
        return this.line;
    }

    protected String getContext() {
        String context = this.getContext(this.variable);
        return context;
    }

    protected String getContext(DecompilerVariable var) {
        String context = this.line.toDebugString(Arrays.asList(var.variable), "[|", "|]");
        return context;
    }

    public static boolean isEquivalent(DataType dt1, DataType dt2) {
        DataType base1 = DecompilerReference.getBaseType(dt1);
        DataType base2 = DecompilerReference.getBaseType(dt2);
        if (base1 == null || base2 == null) {
            return false;
        }
        return base1.isEquivalent(base2);
    }

    public static boolean isEqual(DataType dt1, DataType dt2) {
        DataType base1 = DecompilerReference.getBaseType(dt1);
        DataType base2 = DecompilerReference.getBaseType(dt2);
        if (base1 == null || base2 == null) {
            return false;
        }
        return base1.equals(base2);
    }

    public static DataType getBaseType(DataType dt) {
        if (dt instanceof Array) {
            return DecompilerReference.getBaseType(((Array)dt).getDataType());
        }
        if (dt instanceof Pointer) {
            DataType baseDataType = ((Pointer)dt).getDataType();
            if (baseDataType != null) {
                return DecompilerReference.getBaseType(baseDataType);
            }
        } else if (dt instanceof TypeDef) {
            DataType baseDataType = ((TypeDef)dt).getBaseDataType();
            return DecompilerReference.getBaseType(baseDataType);
        }
        return dt;
    }

    public static DataType getFieldDataType(ClangFieldToken field) {
        DataType fieldDt = field.getDataType();
        if ((fieldDt = DecompilerReference.getBaseType(fieldDt)) instanceof Structure) {
            Structure parent = (Structure)fieldDt;
            int offset = field.getOffset();
            int n = parent.getLength();
            if (offset >= 0 && offset < n) {
                DataTypeComponent dtc = parent.getComponentAt(field.getOffset());
                fieldDt = dtc.getDataType();
            }
        }
        return fieldDt;
    }

    public String toString() {
        return "{\n\tvariable: " + StringUtilities.toStringWithIndent((Object)this.variable) + ",\n\tdata type: " + this.getDataType() + ",\n\tline " + this.getContext() + ",\n\tfunction: " + this.getFunction() + "\n}";
    }
}

